//////////////////////////////////////////////////////////////////////////
// SceneConstants.inc  1.0  KEA  Copyright(c) 2003, K.E. Ayers Designs  //
//////////////////////////////////////////////////////////////////////////
// Common constants needed in multiple scenes.                          //
//////////////////////////////////////////////////////////////////////////

#ifndef (_SceneConstants_Inc_)
#declare _SceneConstants_Inc_ = true;

#declare FT                     = 12;   // Default dimensions are inches

#declare BallBoyRad             = 1 * FT;
#declare BallBoyGirth           = 2 * pi * BallBoyRad;
#declare TurnDist               = BallBoyGirth;
#declare BallBoyEyeRad          = BallBoyRad * 0.33;
#declare BallBoyEyebrowRad      = BallBoyEyeRad * 1.5;
#declare BallBoyEyebrowWid      = BallBoyEyeRad * 0.15;
#declare BallBoyEyebrowArc      = 90;


//////////////////////////////////////////////////////////////////////////
// Ball Boy doesn't have much room to roam in his pen!                  //
//                                                                      //
// However, we have to make sure that the paths he rolls along are      //
// multiples of Ball Boy's girth (circumference), so that his eyes will //
// always be oriented properly when he finishes rolling; because he'll  //
// always be rolling an integral number of turns.                       //
//                                                                      //
// Here's the pen's general layout, with respect to the number of turns //
// along Ball Boy's various paths:                                      //
//                                                                      //
//                                +Z (N)                                //
//                                  ^                                   //
//                                  |                                   //
//      XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX      //
//      X                                                        X      //
//      X                                                        X      //
//      X                                                        X      //
//      X                                                        X      //
//      X                                                        X      //
//      X                                                        X      //
//      X                         (Room)                         X      //
//      X     |                                            |     X      //
// -X<--X .5t-+<----------------- 3 turns ---------------->+-    X-->+X //
// (W)  X     ^                                            |     X  (E) //
//      X     |                                                  X      //
//      X     |                                                  X      //
//      X     |                                                  X      //
//      X  1.5 turns                                             X      //
//      X     |                                                  X      //
//      X     |                                                  X      //
//      X     |                                                  X      //
//      X    -+-.5t XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX      //
//      X     |                                                  X      //
//      X  .5 turn                                               X      //
//      X     |                  (Hall)                          X      //
//      X     v                                            |     X      //
//      X .5t-+<----------------- 3 turns ---------------->+-.5t X      //
//      X     |                                            |     X      //
//      X                                                        X      //
//      X                                                        X      //
//      X                                                        X      //
//      XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX      //
//                                  |                                   //
//                                  v                                   //
//                                -Z (S)                                //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#declare PenWallHgt             =  BallBoyRad * 3;
#declare PenWallThick           =  BallBoyRad;
#declare EastWestTurns          =  3;
#declare HallTurns              =  0.5;
#declare RoomTurns              =  1.5;
#declare EastWestPathLen        =  TurnDist * EastWestTurns;
#declare HallPathLen            =  TurnDist * HallTurns;
#declare RoomPathLen            =  TurnDist * RoomTurns;
#declare NorthMarkOfs           =  TurnDist * RoomTurns;
#declare SouthMarkOfs           =  TurnDist * HallTurns;
#declare EastMarkOfs            =  TurnDist / 2;
#declare WestMarkOfs            =  TurnDist / 2;

#declare EastWallPos            =  (EastWestPathLen + TurnDist) / 2;
#declare WestWallPos            = -(EastWestPathLen + TurnDist) / 2;
#declare NorthWallPos           =  RoomPathLen;
#declare SouthWallPos           =  NorthWallPos
                                        - 2 * (RoomPathLen + HallPathLen);
#declare CenterWallPos          = -RoomPathLen;
#declare OpeningWid             =  TurnDist;

#declare RoomCenterXOfs         = (EastWallPos + WestWallPos) / 2;


// Macro to linearly move a start vector, to an end vector,
// by a fractional amount ranging from 0=at start, to 1=at end.
#macro PanVector(VStart, VEnd, Fraction)
    VStart + ((VEnd - VStart) * Fraction)
#end


#end    // #ifndef (_SceneConstants_Inc_)

