#! /usr/bin/perl -w
use strict;


# The maze will be bounded by box with the corners <0, 0, 0>
# and <$xsize + $wallthickness, $wallheight, $ysize + $wallthickness>.

use vars qw($xsize $ysize $filename $wallthickness $wallheight);
*xsize =         \ 15;
*ysize =         \ 15;
*filename =      \ 'maze.inc';
*wallthickness = \ 0.15;
*wallheight    = \ 1.0;



use vars qw($e $s $visited);
*e =       \ 0x1;
*s =       \ 0x2;
*visited = \ 0x4;

use vars qw($w $n);
*w = \ 3;
*n = \ 4;


my ($x, $y);
my @maze = ($e | $s) x (($xsize + 1) * ($ysize + 1));

$maze [0] = 0;
for ($x = 1; $x <= $xsize; ++$x) { $maze [$x] = $s; }
for ($y = 1; $y <= $ysize; ++$y) { $maze [$y * ($xsize + 1)] = $e; }


# Make an 5x5 empty area with an exit in the center.
for ($y = int ($ysize / 2) - 1; $y < int ($ysize / 2) + 4; ++$y) {
    for ($x = int ($xsize / 2) - 1; $x < int ($xsize / 2) + 4; ++$x) {
	if ($x < int ($xsize / 2) + 3)                               { $maze [$x + $y * ($xsize + 1)] &= ~$e; }
	if ($y < int ($ysize / 2) + 3 || $x == int ($xsize / 2) + 1) { $maze [$x + $y * ($xsize + 1)] &= ~$s; }
	$maze [$x + $y * ($xsize + 1)] |= $visited;
    }
}

# Make an exit in the outer wall.
$maze [int ($xsize / 2) + 1 + $ysize * ($xsize + 1)] &= ~$s;


($x, $y) = (1, 1);
my %unvisitedneighbor = ();
while (1) {
    $maze [$x + $y * ($xsize + 1)] |= $visited;

    my @possible = ();
    push @possible, $e if $x < $xsize && !($maze [($x + 1) + $y * ($xsize + 1)] & $visited);
    push @possible, $s if $y < $ysize && !($maze [$x + ($y + 1) * ($xsize + 1)] & $visited);
    push @possible, $w if $x > 1      && !($maze [($x - 1) + $y * ($xsize + 1)] & $visited);
    push @possible, $n if $y > 1      && !($maze [$x + ($y - 1) * ($xsize + 1)] & $visited);

    if ($#possible >= 1) { $unvisitedneighbor {"$x:$y"} = 1; }
    else                 { delete $unvisitedneighbor {"$x:$y"}; }

    if ($#possible < 0) {
	my @uvn = keys %unvisitedneighbor;

	last if ($#uvn < 0);
	($x, $y) = split /:/, $uvn [rand ($#uvn + 1)];
	next;
    }

    my $direction = $possible [rand ($#possible + 1)];
    if    ($direction == $e) { $maze [$x++ + $y * ($xsize + 1)] &= ~$e; }
    elsif ($direction == $s) { $maze [$x + $y++ * ($xsize + 1)] &= ~$s; }
    elsif ($direction == $w) { $maze [--$x + $y * ($xsize + 1)] &= ~$e; }
    else                     { $maze [$x + --$y * ($xsize + 1)] &= ~$s; }
}



for ($y = 0; $y <= $ysize; ++$y) {
    print "\n";
    for ($x = 0; $x <= $xsize; ++$x) {
	print ($maze [$x + ($ysize - $y) * ($xsize + 1)] & $s ? '---+' : '   +');
    }
    print "\n";
    for ($x = 0; $x <= $xsize; ++$x) {
	print ($maze [$x + ($ysize - $y) * ($xsize + 1)] & $e ? '   |' : '    ');
    }
}
print "\n";



open F, "> $filename" or die "$0: $filename: $!\n";

for ($y = 0; $y <= $ysize; ++$y) {
    my $from = -1;
    for ($x = 0; $x <= $xsize + 1; ++$x) {
	my $havewall = $x <= $xsize && $maze [$x + $y * ($xsize + 1)] & $s;

	if ($havewall) {
	    if ($from < 0) { $from = $x; }
	} elsif ($from >= 0) {
	    print F ('box { <', $from - 1, ', 0, ', $y, '>, <',
		     $x - 1 + $wallthickness, ', ', $wallheight, ', ', $y + $wallthickness, "> }\n");
	    $from = -1;
	}
    }
}

for ($x = 0; $x <= $xsize; ++$x) {
    my $from = -1;
    for ($y = 0; $y <= $ysize + 1; ++$y) {
	my $havewall = $y <= $ysize && $maze [$x + $y * ($xsize + 1)] & $e;

	if ($havewall) {
	    if ($from < 0) { $from = $y; }
	} elsif ($from >= 0) {
	    print F ('box { <', $x, ', 0, ', $from - 1, '>, <',
		     $x + $wallthickness, ', ', $wallheight, ', ', $y - 1 + $wallthickness, "> }\n");
	    $from = -1;
	}
    }
}

close F or die "$0: $filename: $!\n";

exit 0;
