///////////////////////////////////////////////////////////////////////////
// INTERNET MOVIE PROJECT                                                //
//                                                                       //
//      textfunc.inc                                                     //
//      Functions for text fade-ins and scrolls                          //
//                                                                       //
//      Rev 0.1                                                          //
//      June 30, 2002                                                    //
//      Andy Read                                                        //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include "include/colors.inc"
#include "include/textures.inc"
#include "include/shapes.inc"


///////////////////////////////////////////////////////////////////////////
//
// textfade() macro
//
///////////////////////////////////////////////////////////////////////////

#macro textfade(string,clk,fade_up,fade_on,fade_down,fade_off)

#if (clk >= fade_up && clk <= fade_off)

#switch (clk)

  #range ( fade_up, fade_on )

    #declare level = (clk - fade_up) / (fade_on - fade_up);

  #break 

  #range ( fade_on, fade_down )

    #declare level = 1;

  #break 

  #range ( fade_down, fade_off )

    #declare level = (fade_off - clk) / (fade_off - fade_down);

  #break 

  #else // should never be used

    #declare level = 0;

#end // switch

text { ttf fontname string 0.15 0
        pigment { rgbft <.9,.9,.9,0,(1-level)> }
        finish { Phong_Shiny ambient .5}
        rotate <0,55,0>
        scale 25
        translate <-16,55,-75>
        }

#end // if

#end // macro

///////////////////////////////////////////////////////////////////////////
// End of textfade() macro
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
// textscroll() macro
//
///////////////////////////////////////////////////////////////////////////

#macro textscroll(str_filename,clk,start_time,speed)

#fopen FileHndl str_filename read

#declare line = 0;
#declare textsize = 0.15; 

#while (defined(FileHndl))

    #read (FileHndl,string)

    #declare line = line + 1;
    
    #if (((clk - start_time) >=  line     / speed) &
         ((clk - start_time) <= (line+20) / speed))

        #declare strwid = Text_Width(fontname, string, textsize, 0);
        
        text { ttf fontname string textsize 0
               pigment { rgb <.9,.9,.9> }
               finish { Phong_Shiny ambient .5}
               translate (3 - 3*strwid)*x
               translate (((clk-start_time)*speed)-line-10)*y
               scale 5.5  //6
        }

    #end // if

#end // while

#end // macro

///////////////////////////////////////////////////////////////////////////
// End of textscroll() macro
///////////////////////////////////////////////////////////////////////////

