

/*

===========================================================

     ATTENTION!!!!



     This file is in the Public Domain.

     Provided by the Internet Movie Project (www.imp.org)

===========================================================

 

 File        : main.pov

 Project     : IRTC Entry for "The end of..." round

 cvs module  : theendof

 POV Version : 3.5

 Description : Master Project file

 Date        : 20031104

 Created by  :	Oscar Pena (troya - at - optonline.net)

 Edited by   :	Tom Galvin (tom - at - imp - dot - org)

		Sascha Ledinsky

                Dennis Borree 20031123 (trulayne - at - new - dot - rr - dot - com)

                Dennis Borree 20031129 (trulayne - at - new - dot - rr - dot - com)

 Copyright   : Released into the Public Domain

 

===========================================================



 Suggested settings for checking selected frames



*********************************************************************************************

 changed shot02 lenght from 6 to 4 seconds, so subtract 60 frames after shot02, I'll correct

 frame counts after we agree on shot02's final length, sorry

 - sascha

********************************************************************************************* 

 

 IMPLogo Shot0:  +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF90   +EF90

 Title Shot:     +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF550  +EF550

 opening shot:   +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF750  +EF750

 Shelf Shot1:    +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF970  +EF970

 Shelf Shot2:    +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF1150 +EF1150

 Shelf Shot3:    +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF1250 +EF1250

 Shelf Shot4:    +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF1450 +EF1450

 hourglass Shot: +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF1650 +EF1650

 Skeleton shot:  +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF1750 +EF1750

 Closing Shot:	  +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF2050 +EF2050

 Credits Shot:   +fn +kfi1 +kff2430 +KI0 +KF81 +W256 +H144 +a0.3 +am2 -j +SF2300 +EF2300

===========================================================



  Shots are marked by change of camera point of view not pans or zooms  

  clock always marks time in seconds.  Use only shot specific clocks in 

  the scene files as changes to the length of other scenes duration will

  cause the master clock to change in your scene.  The only thing you should

  change in this file is the shot length for your scene. All Declares in

  the individual scene file should be prefaced with "shot0x" where x is

  the shot number that include file.



  The final version will be rendered with a 720*304 size. So test renderings

  should use that, too.



===========================================================

*/





#include "scenes/units.inc"

#declare framerate = 30; //Final_Frame / Final_Clock = Frames per second

#declare frame = (clock * framerate);



/* Nov 9 2003	Sascha Ledinsky

* some global settings...

*/

global_settings {

	max_trace_level 8

	adc_bailout 0.05

	ambient_light 1

}



#declare preview = false;



/*

*********************************************************************************************

 changed shot02 lenght from 6 to 4 seconds, so subtract 60 frames after shot02, I'll correct

 frame counts after we agree on shot02's final length, sorry

 - sascha

********************************************************************************************* 

*/



/*

* Nov 8 2003	Sascha Ledinsky

* edited basic script:

*

* shot 0:	imp logo

* shot 1:	title

* shot 2:	opening shot (room with door)

* shot 3:	shelfs shot 1

* shot 4:	shelfs shot 2

* shot 5:	shelfs shot 3

* shot 6:	shelfs shot 4

* shot 7:	camera scans over hourglasses and zooms to nearly empty glass

* shot 8:	change fov to 15 degs, slow motion (1:3)

* shot 9:	change fov to 5 dges, ultra slow motion (1:10)

* shot 10:	closing shot (room with door)

* shot 11:	credits

*/



#declare shot00Length=15; //time in seconds	   1	 450

#declare shot01Length=6;  //time in seconds	 451	 630

#declare shot02Length=6;  //time in seconds	 631	 810

#declare shot03Length=8;  //time in seconds	 811	1050

#declare shot04Length=6;  //time in seconds	1051	1230

#declare shot05Length=4;  //time in seconds	1231	1350

#declare shot06Length=9;  //time in seconds	1351	1620

#declare shot07Length=0;  //time in seconds	-	-

#declare shot08Length=3;  //time in seconds	1621	1710

#declare shot09Length=10; //time in seconds	1711	2010

#declare shot10Length=10;  //time in seconds	2011	2310

#declare shot11Length=16; //time in seconds	2311	2790 

//		total = 93 seconds



#declare shot00start = 1; //inital frame

#declare shot00end = (shot00Length * framerate);



#declare shot01start = shot00end;

#declare shot01end = shot00end + (shot01Length * framerate);



#declare shot02start = shot01end;

#declare shot02end = shot01end + (shot02Length * framerate);



#declare shot03start = shot02end;

#declare shot03end = shot02end + (shot03Length * framerate);



#declare shot04start = shot03end;

#declare shot04end = shot03end + (shot04Length * framerate);



#declare shot05start = shot04end;

#declare shot05end = shot04end + (shot05Length * framerate);



#declare shot06start = shot05end;

#declare shot06end = shot05end + (shot06Length * framerate);



#declare shot07start = shot06end;

#declare shot07end = shot06end + (shot07Length * framerate);



#declare shot08start = shot07end;

#declare shot08end = shot07end + (shot08Length * framerate);



#declare shot09start = shot08end;

#declare shot09end = shot08end + (shot09Length * framerate);



#declare shot10start = shot09end;

#declare shot10end = shot09end + (shot10Length * framerate);



#declare shot11start = shot10end;

#declare shot11end = shot10end + (shot11Length * framerate);





#switch (frame)



/////////////////////

//                 //

//  Begin Shot 00  //

//                 //

/////////////////////

//

// Intro

//

//

//

#range ( shot00start , shot00end ) 

    #declare clock00 = clock;

    #include "scenes/shot00.inc"

#break 

/////////////////////

//                 //

//   End Shot 00   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 01  //

//                 //

/////////////////////

//

// First Room



//

//

//

#range ( shot01start , shot01end ) 

    #declare clock01 = clock-shot00Length;

    #include "scenes/shot01.inc"

#break 

/////////////////////

//                 //

//   End Shot 01   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 02  //



//                 //

/////////////////////

//

// Credits

//

//

//

#range ( shot02start , shot02end ) 

    #declare clock02 = clock-(shot00Length+shot01Length);

    #include "scenes/shot02.inc"

#break 

/////////////////////

//                 //

//   End Shot 02   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 03  //

//                 //

/////////////////////

//

// Comment

//

//

//

#range ( shot03start , shot03end ) 

    #declare clock03 = clock-(shot00Length+shot01Length+shot02Length);

    #include "scenes/shot03.inc"

#break 

/////////////////////

//                 //

//   End Shot 03   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 04  //

//                 //

/////////////////////

//

// Comment

//

//

//

#range ( shot04start , shot04end ) 

    #declare clock04 = clock-(shot00Length+shot01Length+shot02Length+shot03Length);

    #include "scenes/shot04.inc"

#break 

/////////////////////

//                 //

//   End Shot 04   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 05  //

//                 //

/////////////////////

//

// Comment

//

//

//

#range ( shot05start , shot05end ) 

    #declare clock05 = clock-(shot00Length+shot01Length+shot02Length+shot03Length+shot04Length);

    #include "scenes/shot05.inc"

#break 

/////////////////////

//                 //

//   End Shot 05   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 06  //

//                 //

/////////////////////

//

// Comment

//

//

//

#range ( shot06start , shot06end ) 

    #declare clock06 = clock-(shot00Length+shot01Length+shot02Length+shot03Length+shot04Length+shot05Length);

    #include "scenes/shot06.inc"

#break 

/////////////////////

//                 //

//   End Shot 06   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 07  //

//                 //

/////////////////////

//

// Comment : combined into shot06

//

//

//

/*#range ( shot07start , shot07end ) 

    #declare clock07 = clock-(shot00Length+shot01Length+shot02Length+shot03Length+shot04Length+shot05Length+shot06Length);

    #include "scenes/shot07.inc"

#break*/ 

/////////////////////

//                 //

//   End Shot 07   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 08  //

//                 //

/////////////////////

//

// Comment

//

//

//

#range ( shot08start , shot08end ) 

    #declare clock08 = clock-(shot00Length+shot01Length+shot02Length+shot03Length+shot04Length+shot05Length+shot06Length+shot07Length);

    #include "scenes/shot08.inc"

#break 

/////////////////////

//                 //

//   End Shot 08   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 09  //

//                 //

/////////////////////

//

// Comment

//

//

//

#range ( shot09start , shot09end ) 

    #declare clock09 = clock-(shot00Length+shot01Length+shot02Length+shot03Length+shot04Length+shot05Length+shot06Length+shot07Length+shot08Length);

    #include "scenes/shot09.inc"

#break 

/////////////////////

//                 //

//   End Shot 09   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 10  //

//                 //

/////////////////////

//

// Comment

//

//

//

#range ( shot10start , shot10end ) 

    #declare clock10 = clock-(shot00Length+shot01Length+shot02Length+shot03Length+shot04Length+shot05Length+shot06Length+shot07Length+shot08Length+shot09Length);

    #include "scenes/shot10.inc"

#break 

/////////////////////

//                 //

//   End Shot 10   //

//                 //

/////////////////////





/////////////////////

//                 //

//  Begin Shot 11  //

//                 //

/////////////////////

//

// Comment

//

//

//

#range ( shot11start , shot11end ) 

    #declare clock11 = clock-(shot00Length+shot01Length+shot02Length+shot03Length+shot04Length+shot05Length+shot06Length+shot07Length+shot08Length+shot09Length+shot10Length);

    #include "scenes/shot11.inc"

#break 

/////////////////////

//                 //

//   End Shot 11   //

//                 //

/////////////////////



#else

   #warning "frame is out of range"

#end



///////////////////////////////////////////////////////////////////////////

//                                                                       //

//                                                                       //

//                        THAT'S ALL FOLKS                               //

//                                                                       //

//                                                                       //

///////////////////////////////////////////////////////////////////////////



