/*

===========================================================

     ATTENTION!!!!



     This file is in the Public Domain.

     Provided by the Internet Movie Project (www.imp.org)

===========================================================



 File        : hourglass.inc

 Project     : IRTC Entry for "The end of..." round

 cvs module  : theendof

 POV Version : 3.5

 Description : room with door and window

 Date        : 20031109

 Created by  : Sascha Ledinsky

 Copyright   : Released into the Public Domain

 

===========================================================

*/



/*

* this file contains macros to produce the hourglass objects

*/



#include "scenes/sand/sand.inc"	// load particle system





/*

* object hourglass(float halfHeight, float radius, float coneHeight, float round, float holeRadius, float glassThickness, float sandLevelTop, float sandLevelBottom, boolean preview, float grain_size, float time, float deltaT, float time_end, int level_of_detail)

*

* returns a hourglass centered at the origin

*

* level_of_detail:	3 = particle sand, < 3 no sand 

*/

#macro hourglass(h1,r0,h0,round,hole,thick,sl,sl2,prev,grain_size,time,deltaT,time_end,lod)

	#local glass = material {

		texture {

			pigment { transmit 1 }

			finish {

				specular 10 roughness 0.001

				conserve_energy

				reflection { 0,1 falloff 2 }

			}

		}

		interior {

			ior 1.5

			//caustics 5

			fade_distance thick * 10

			fade_power 2

		}

	}

	#local preview = material {

		texture {

			pigment { color rgbt <1,1,1,0.95> }

			finish { diffuse 1 brilliance 3 ambient 0 specular 5 roughness 0.002 }

		}

		interior {

			fade_distance thick * 10

			fade_power 2

		}

	}

	#local sand = material {

		texture {

			pigment { color rgb 1 }

			finish { ambient 0.0 diffuse 0.8 brilliance 0.3 specular 1 roughness 0.01 }

			normal { crackle 1 scale 0.0005 triangle_wave}

		}

	}



	#local dSand = thick;

	#local ramp = tan(30/180*pi);

			

	#local C0 = <-(hole + round),0>;

	#local C1 = <-(r0 - round),h0>;

	#local P = (C0 - C1)/2;

	#local B = tangent(round,P);

	#local B1 = C1 + B;

	#local S = P - B;

	

	#local y0 = B1.y - B1.x / S.x * S.y;

	

	#local y1 = -C0.x / B.x * B.y;

	

	#local y2 = C1.y - C1.x / B.x * B.y;

	#local x2 = C1.x * y2 / (y2 - C1.y);

	

	#local dx = sqrt(S.x*S.x + S.y*S.y) * thick / S.y;

	

	#local dxs = sqrt(S.x*S.x + S.y*S.y) * (thick + dSand) / S.y;

	#local dys = sqrt(S.x*S.x + S.y*S.y) * (thick + dSand) / S.x;

	

	#local bound = cylinder { <0,-h1 - 2*thick,0>,<0,h1 + 2*thick,0>,r0 + 2*thick }

	

	union {

		/*

		* sand in the upper half...

		*/

		difference {

			union {

				cone {

					<0,y0+dys,0>,0,<0,h0,0>,-S.x / S.y*(h0 - y0) + dxs 

					clipped_by { cone { <0,y2,0>,0,<0,0,0>,-x2 } }

				}

				torus { -C1.x, round - thick -dSand translate <0,C1.y,0>}

				cylinder { <0, -(round - thick - dSand),0>,<0,round - thick - dSand,0>, -C1.x -(round - thick - dSand) translate <0,C1.y,0> }

				cylinder { <0,C1.y,0>,<0,h1,0>, -C1.x + round - thick - dSand }

			}

			plane { -y,-(y0+dys+sl) }

			material { sand translate <0,sl/5,0>}

		}

		/*

		* sand in the lower half...

		*/

		union {

			union {

				/*

				cone {

					<0,y0+dys,0>,0,<0,h0,0>,-S.x / S.y*(h0 - y0) + dxs 

					clipped_by { cone { <0,y2,0>,0,<0,0,0>,-x2 } }

				}

				*/

				torus { -C1.x, round - thick -dSand translate <0,-h1 + round + thick + dSand,0>}

				cylinder { <0, -(round - thick - dSand),0>,<0,round - thick - dSand,0>, -C1.x -(round - thick - dSand) translate <0,-h1 + round + thick + dSand,0> }

				cylinder { <0,-h1 + round + thick + dSand,0>,<0,0,0>, -C1.x + round - thick - dSand }

				clipped_by { plane { y,sl2 - h1 } }	

			}

			cone { <0,sl2 - h1,0>, -C1.x + round - thick - dSand, <0,sl2 - h1 + ramp * (-C1.x + round - thick - dSand),0>,0 }

			material { sand translate <0,sl/5,0>}

		}

		

		/*

		* hourglass shape...

		*/		

		union {

			/*

			* center piece

			*/

			difference {

				torus { -C0.x, round + thick }

				torus { -C0.x, round - thick }

				clipped_by {

					union {

						cone { <0,y1,0>,0,0,-C0.x }

						cone { <0,-y1,0>,0,0,-C0.x }

					}

				}

			}

			/*

			* upper rouded edge (cone)

			*/

			difference {

				torus { -C1.x, round + thick }

				torus { -C1.x, round - thick }

				translate <0,C1.y,0>

				clipped_by {

					plane { y, C1.y }

					difference {

						object { bound }

						cone { <0,y2,0>,0,<0,0,0>,-x2 }

					}

				}

			}

			/*

			* lower rounded edge (cone)

			*/

			difference {

				torus { -C1.x, round + thick }

				torus { -C1.x, round - thick }

				translate <0,-C1.y,0>

				clipped_by {

					plane { -y, C1.y }

					difference {

						object { bound }

						cone { <0,-y2,0>,0,<0,0,0>,-x2 }

					}

				}

			}

			/*

			* cone (upper part)

			*/

			difference {

				cone { <0,y0,0>,-dx,<0,h0,0>,-S.x / S.y*(h0 - y0) - dx }

				cone { <0,y0,0>,+dx,<0,h0,0>,-S.x / S.y*(h0 - y0) + dx}

				clipped_by {

					cone { <0,y2,0>,0,<0,0,0>,-x2 }

					difference {

						object { bound }

						cone { <0,y1,0>,0,0,-C0.x }

					}

					plane { y, C1.y -0.0001 }

				}

			}

			/*

			* cone (lower part)

			*/

			difference {

				cone { <0,-y0,0>,-dx,<0,-h0,0>,-S.x / S.y*(h0 - y0) - dx }

				cone { <0,-y0,0>,+dx,<0,-h0,0>,-S.x / S.y*(h0 - y0) + dx}

				clipped_by {

					cone { <0,-y2,0>,0,<0,0,0>,-x2 }

					difference {

						object { bound }

						cone { <0,-y1,0>,0,0,-C0.x }

					}

					plane { -y, C1.y -0.0001 }

				}

			}

			/*

			* upper cylinder

			*/

			difference {

				cylinder { <0,h0,0>,<0,h1 - round,0>,r0 + thick open }

				cylinder { <0,h0,0>,<0,h1 - round,0>,r0 - thick open }

			}

			/*

			* lower cylinder

			*/

			difference {

				cylinder { <0,-h0,0>,<0,-h1 + round,0>,r0 + thick open }

				cylinder { <0,-h0,0>,<0,-h1 + round,0>,r0 - thick open }

			}

			/*

			* top

			*/

			box {

				<-r0, h1 - thick, -r0>,<r0, h1 + thick, r0>

				clipped_by {

					cylinder { <0, h1 - thick * 1.1, 0>,<0, h1 + thick,0>,r0 - round open }

				}

			}

			/*

			* rounded edge (top)

			*/

			difference {

				torus { r0 - round, round + thick }

				torus { r0 - round, round - thick }

				

				clipped_by { plane { -y,0 } }

				

				clipped_by {

					difference {

						object { bound }

						cylinder { <0,0,0>,<0,round + thick * 1.1,0>,r0 - round open}

					}

				}

				

				translate <0,h1 - round,0>

			}

			/*

			* bottom

			*/

			box {

				<-r0, -h1 - thick, -r0>,<r0, -h1 + thick, r0>

				clipped_by {

					cylinder { <0, -h1 - thick * 1.1, 0>,<0, -h1 + thick,0>,r0 - round open }

				}

			}

			/*

			* rouded edge (bottom)

			*/

			difference {

				torus { r0 - round, round + thick }

				torus { r0 - round, round - thick }

				

				clipped_by { plane { y,0 } }

				

				clipped_by {

					difference {

						object { bound }

						cylinder { <0,0,0>,<0,-round - thick * 1.1,0>,r0 - round open}

					}

				}

				

				translate <0,-h1 + round,0>

			}

			/*

			* assign photorealistic glass material or

			* simplified glass for previews

			*/ 

			#if (prev)

				material { preview }

			#else

				material { glass }

			#end

		}

		/*

		* the sand...

		*

		* levels of detail:

		* -----------------

		* lod = 3: invoke particle system

		* lod = 2: *reserved*

		* lod = 1: draw white paraboliod

		* lod = 0: no sand at all

		*/

		#if (lod = 3)

			initialize_sand(<0,y0+dys,0>,time_end,80,y0 + dys + h1 - thick - sl2,grain_size)// initialize particle system

			run_sand(time, deltaT)								// invoke particle system

		#end

		

		#if (lod = 1)

			#debug "yes\n"

			quadric {

				#local g = 9.80665;						// gravity in m/s/s

				#local vh = 0.02;						// horizontal speed in m/s

				#local yOff = g * grain_size*grain_size / 2 / vh / vh;

				<-1,0,-1>,<0,0,0>,<0,- 2 * vh*vh / g,0>,0				// a paraboloid: -x^2 - z^2 - y * vh^2 / g = 0

				clipped_by { plane { -y,h1 } }

				translate <0,y0+dys + yOff,0>

				material { sand }

			}

		#end

			

	}	

#end









/*

* vector tangent(float r, vector P)

*

* computes and returns the position where the tangent through point P hits the circle at <0/0> with radius r

* of course there are two solutions, if the point P is on the lower right side in returns the lower left point

*/

#macro tangent(r,P)

	#local A = 1 + P.x*P.x / (P.y*P.y);

	#local B = -2 * r*r * P.x / (P.y*P.y);

	#local C = r*r*r*r / (P.y*P.y) - r*r;

	#local p = B / A;

	#local q = C / A;

	#local X = -p/2 - sqrt((p/2)*(p/2) - q);

	#local Y = -sqrt(r*r - X*X);

	<X,Y>

#end





	

