/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : bat.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Makes Bat
 Date        : 20031226
 Created by  : Dennis Borree (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/


#include "include/colors.inc"


#declare bat_wing=difference{
cylinder{<36,-.05,0>,<36,.05,0>,40 }
cylinder{<3,1,-6>,<3,-1,-6>,3 }
cylinder{<4,1,-1>,<4,-1,-1>,3 }
cylinder{<-.1,1,-10>,<-.1,-1,-10>,2.5 }
box{<80,1,0>,<-10,-1,50>}
box{<80,1,-11>,<-10,-1,-50> }
box{<80,1,1>,<1.9,-1,-50>}
box{<-80,1,1>,<0,-1,-50> rotate y*10 translate <-3,0,0>}
finish{roughness .3} pigment{bat_color}}

#declare bat_body=  blob{
            		threshold 0.6
            		cylinder{<-3.5,0,0>,<3.5,0,0>,2,1 }
            		cylinder{<-1.5,0,0>,<1.5,0,0>,1.5,1 }
            		sphere{<0,0,0>,1,1 translate<-3.5,.4,0>}
            		sphere{<0,0,0>,.7,.3 translate<-4.7,-.4,0>}
            		sphere{<0,0,0>,2,-.4 translate<3.5,0,0>}
            		sphere{<0,0,0>,.6,1.0 scale<.5,1,1>rotate z*45 rotate <0,45,0>translate<-3.5,1,.6>}
            		sphere{<0,0,0>,.6,1.0 scale<.5,1,1>rotate z*45 rotate <0,-45,0>translate<-3.5,1,-.6>}
            		translate x*0.5
            		pigment{bat_color} 
            		finish{roughness .3}
            		normal{crackle 5 
            		       turbulence 1 
            		       scale .03}
            		}



#declare bay_wing_flap=50*sin(bat_time*pi*11 );

#declare bat=union{object{bat_body}
                   object{bat_wing translate <2,0,0>scale <1.5,1,1> rotate x*-bay_wing_flap translate z*-1}
                   object{bat_wing translate <2,0,0>scale <1.5,1,-1>rotate x*bay_wing_flap translate z*1}
                   rotate <0,90,0>  
                   }