/*

===========================================================

     ATTENTION!!!!



     This file is in the Public Domain.

     Provided by the Internet Movie Project (www.imp.org)

===========================================================



 File        : bricks.inc

 Project     : IRTC Entry for "The end of..." round

 cvs module  : theendof

 POV Version : 3.5

 Description : macros for brick-wall

 Date        : 20031116

 Created by  : Sascha Ledinsky 

 Copyright   : Released into the Public Domain

 

===========================================================

*/



/*

* object roundcube(vector corner1, vector corner2, float roundness)

*/

#macro roundcube(p1,p2,r)

  #local x1 = p1.x;

  #local y1 = p1.y;

  #local z1 = p1.z;

  #local x2 = p2.x;

  #local y2 = p2.y;

  #local z2 = p2.z;

  #if (x1 > x2) #local d = x2; #local x2 = x1; #local x1 = d; #end

  #if (y1 > y2) #local d = y2; #local y2 = y1; #local y1 = d; #end

  #if (z1 > z2) #local d = z2; #local z2 = z1; #local z1 = d; #end

  union {

    sphere { <x1+r,y1+r,z1+r>,r }

    sphere { <x1+r,y2-r,z1+r>,r }

    sphere { <x2-r,y2-r,z1+r>,r }

    sphere { <x2-r,y1+r,z1+r>,r }

    sphere { <x1+r,y1+r,z2-r>,r }

    sphere { <x1+r,y2-r,z2-r>,r }

    sphere { <x2-r,y2-r,z2-r>,r }

    sphere { <x2-r,y1+r,z2-r>,r }

    cylinder { <x1+r,y1+r,z1+r>,<x2-r,y1+r,z1+r>,r }

    cylinder { <x1+r,y2-r,z1+r>,<x2-r,y2-r,z1+r>,r }

    cylinder { <x1+r,y1+r,z1+r>,<x1+r,y2-r,z1+r>,r }

    cylinder { <x2-r,y1+r,z1+r>,<x2-r,y2-r,z1+r>,r }

    cylinder { <x1+r,y1+r,z2-r>,<x2-r,y1+r,z2-r>,r }

    cylinder { <x1+r,y2-r,z2-r>,<x2-r,y2-r,z2-r>,r }

    cylinder { <x1+r,y1+r,z2-r>,<x1+r,y2-r,z2-r>,r }

    cylinder { <x2-r,y1+r,z2-r>,<x2-r,y2-r,z2-r>,r }

    cylinder { <x1+r,y1+r,z1+r>,<x1+r,y1+r,z2-r>,r }

    cylinder { <x2-r,y1+r,z1+r>,<x2-r,y1+r,z2-r>,r }

    cylinder { <x1+r,y2-r,z1+r>,<x1+r,y2-r,z2-r>,r }

    cylinder { <x2-r,y2-r,z1+r>,<x2-r,y2-r,z2-r>,r }

    box { <x1+r,y1+r,z1>,<x2-r,y2-r,z2> }

    box { <x1+r,y1,z1+r>,<x2-r,y2,z2-r> }

    box { <x1,y1+r,z1+r>,<x2,y2-r,z2-r> }

    }

#end



#declare s0 = seed(0);



#macro random_bricks(run,pr,min_size,pos,xf,round,displace,dist)  

	#local block_pos = array[run];

	#local block_size = array[run];

	

	#local block_pos[0] = <0,0,0>;

	#local block_size[0] = pr;

	#local this = 0;

	#local blocks = 1;

	#while (blocks < run) 

		#local block = 0;

		#local volume = 0;

		#local b = 0;

		#while (b < blocks)

			#local vol = block_size[b].x*block_size[b].y*block_size[b].z;

			#if (vol > volume)

				#local block = b;

				#local volume = vol;

			#end

			#local b = b + 1;

		#end  

		#if (block_size[block].x/xf >= block_size[block].y & block_size[block].x >= block_size[block].z)

			#local dir = 1;

		#end

		#if (block_size[block].y >= block_size[block].x/xf & block_size[block].y >= block_size[block].z)

			#local dir = 2;

		#end

		#if (block_size[block].z >= block_size[block].y & block_size[block].z >= block_size[block].x/xf)

			#local dir = 3;

		#end    

		#local h = rand(s0)/2 + 1/4;

		#if (dir = 1 & block_size[block].x > min_size.x) // split x

			#local block_pos[blocks] = block_pos[block] + block_size[block]*<h,0,0>;

			#local block_size[blocks] = block_size[block]*<1-h,1,1>;

			#local block_size[block] = block_size[block]*<h,1,1>;

			#local blocks = blocks + 1;

		#end

		#if (dir = 2 & block_size[block].y > min_size.y) // split y

			#local block_pos[blocks] = block_pos[block] + block_size[block]*<0,h,0>;

			#local block_size[blocks] = block_size[block]*<1,1-h,1>;

			#local block_size[block] = block_size[block]*<1,h,1>;

			#local blocks = blocks + 1;

		#end

		#if (dir = 3 & block_size[block].z > min_size.z) // split z

			#local block_pos[blocks] = block_pos[block] + block_size[block]*<0,0,h>;

			#local block_size[blocks] = block_size[block]*<1,1,1-h>;

			#local block_size[block] = block_size[block]*<1,1,h>;

			#local blocks = blocks + 1;

		#end      

		#local this = this + 1;

	#end

	#local this = 0;

	#while (this < blocks)

		object {

			roundcube(block_pos[this]+dist,block_pos[this]+block_size[this]-dist,round)

			translate pos

			translate <displace.x * (rand(s0) * 2 - 1),displace.y * (rand(s0) * 2 - 1),displace.z * (rand(s0) * 2 - 1)>

		}

		#local this = this + 1;

	#end  

#end