/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : room.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : room with door and window
 Date        : 20031108
 Created by  : Sascha Ledinsky
 Modified by : Dennis Borree 20031123 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031214 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#include "scenes/flame/flame.inc"
#include "include/colors.inc"
#include "include/woods.inc"
#include "include/functions.inc"
#include "scenes/room/bricks.inc"
#include "scenes/shelfs/web.inc"
#include "scenes/shelfs/torch.inc"


/*
* lights
*/

#macro light_flicker()
	f_agate(clock_room,0,0).x * 0.3 + 0.7
#end

#declare Dimmer=1;

// key light  added new spot further back to light silhouette & room
light_source {
	<-2,6,-10>
	#local c = light_flicker();
	color rgb <1.3,0.7,0.4> * c*Dimmer
	//fade_power 2
	//fade_distance 12
	spotlight
	point_at <0,0,0>
	area_light <3,0,0>,<0,0,3>,4,4 adaptive 1 jitter circular orient
	radius 6
	falloff 13	
}

// fill
light_source {
	<10,10,-10>
	color rgb <0.2,0.3,0.6>*Dimmer
	fade_power 2
	fade_distance 12
	shadowless
}

// moonlight
light_source {
	<25,200,250>
	color rgb <1,1,1> *0.7
	spotlight
	point_at <-1.5,1,0>
	radius 0.1 falloff 0.2
}

/*
* outside
*/
sky_sphere {
	pigment {
		gradient y
		color_map {
			[0.0 color rgb <0.5,0.25,1.0>]
			[0.5 color rgb <0,0,0.3>]
			[1.0 color rgb 0]
		}
	}
}

/*
* floor
*/

#include "scenes/room/floor.inc"

/*
* wall
*/


difference {
	box { <-5,0,0.05>,<5,4,0.48> }		// wall
	box { <-0.62,-0.1,-0.1>,<0.62,1.92,0.6> }	// door
	box { <-2.12,0.68,-0.1>,<-0.98,1.92,0.6> }	// window
	pigment {
		granite
		color_map {
			[0.0 color rgb 0.2]
			[1.0 color rgb 0.4]
		}
		scale 0.2
		turbulence 0.5
	}
	finish { ambient 0.05 diffuse 0.9 brilliance 0.5 }
}

union {
	
	random_bricks(150,<4.4,0.7,0.5>,<0.05,0.15,0.10>,<-5,0,0>,1,0.04,<0,0,0.01>,0.01)
	random_bricks(100,<2.9,1.2,0.5>,<0.05,0.15,0.10>,<-5,0.7,0>,1,0.04,<0,0,0.01>,0.01)
	random_bricks(20,<0.4,1.2,0.5>,<0.05,0.15,0.10>,<-1,0.7,0>,1,0.04,<0,0,0.01>,0.01)
	random_bricks(300,<4.4,1.9,0.5>,<0.05,0.15,0.10>,<0.6,0,0>,1,0.04,<0,0,0.01>,0.01)
	random_bricks(300,<10,1,0.5>,<0.05,0.15,0.10>,<-5,1.9,0>,1,0.04,<0,0,0.01>,0.01)
	
	
	//random_bricks(20,<1,1,0.5>,<0.1,0.1,0.1>,<-3.6,1,0>,1,0.06,<0,0,0.05>)
	//random_bricks(20,<1,1,0.5>,<0.1,0.1,0.1>,<-1.6,1,0>,1,0.06,<0,0,0.05>)
	//random_bricks(20,<3,1,0.5>,<0.1,0.1,0.1>,<-3.6,2,0>,1,0.06,<0,0,0.05>)
	pigment {
		granite
		color_map {
			[0.0 color rgb 0.4]
			[1.0 color rgb 0.8]
		}
		scale 1
		turbulence 0.5
	}
	finish { ambient 0.05 diffuse 0.9 }
	normal { crackle 2 scale 0.2 turbulence 0.2}
}

/*
* window frame
*/

union{
      difference{
                 box { <-2.12,0.68,-0.0>,<-0.98,1.92,0.48> }
                 box { <-2.08,0.72,-0.2>,<-1.02,1.88,0.7> }
      }
      box { <-2.2,0.64,-0.1>,<-0.90,0.72,0.6> }
      texture { T_Wood34 rotate <-45,0,0> scale 10 translate z*1 } 
}

        
/*
* door
*/

#declare hinge=union{
                     box { <-0.58,0.93,0.18>,<-0.38,1.03,0.19> }
                     box { <-0.68,1.08,0.18>,<-0.58,0.88,0.19> }
                     cylinder {<-0.38,0.98,0.18>,<-0.38,0.98,0.19>,0.05}
                     cylinder {<-0.43,1.03,0.18>,<-0.43,1.03,0.19>,0.05}
                     cylinder {<-0.43,0.93,0.18>,<-0.43,0.93,0.19>,0.05}
                     sphere{<-0.38,0.98,0.18>,0.02 pigment{Black} }
                     sphere{<-0.43,1.03,0.18>,0.02 pigment{Black} }
                     sphere{<-0.43,0.93,0.18>,0.02 pigment{Black} }
                     sphere{<-0.63,1.03,0.18>,0.02 pigment{Black} }
                     sphere{<-0.63,0.93,0.18>,0.02 pigment{Black} }
                     cylinder {<-0.71,1.1.185,>,<-0.71,0.86,0.185>,0.03}
                     scale<1,.7,1> translate y*0.3} 

union {
	union {
		box { <-0.58,0.05,0.19>,<-0.40,1.88,0.25> }
		box { <-0.39,0.04,0.2>,<-0.20,1.88,0.25> }
		box { <-0.19,0.05,0.21>,<0.00,1.88,0.25> }
		box { <0.01,0.03,0.19>,<0.20,1.88,0.25> }
		box { <0.21,0.04,0.21>,<0.39,1.88,0.25> }
		box { <0.40,0.03,0.20>,<0.58,1.88,0.25> }
		box { <-0.60,0.05,0.26>,<-0.56,1.88,0.25> }
		texture { T_Wood35 rotate <90,0,0> }
	}
	
	box { <-0.6,0.0,0.26>,<0.6,1.9,0.30> pigment { color rgb 0 } }
	union {
		torus {
			0.10,0.02
			rotate <90,0,0>
			
			    #ifdef(clock10)
			    #local swing=22;
			    translate <0,-0.06,0.01>
			       #switch (clock10)
			       #range (0,1)
			       rotate x*(2*swing*clock10)
			       #break
			       #range (1, 1.3)
			       rotate x*(2*swing-2*swing*(clock10-1)/0.3)
			       #break
			       #range (1.3,1.6)
			       rotate x*(swing*(clock10-1.3)/0.3)
			       #break
			       #range (1.6, 1.9)
			       rotate x*(swing-swing*(clock10-1.6)/0.3)
			       #break
			       #end
			    translate <0,0.06,-0.01> 
			    #end
			
			translate <0.4,0.8,0.17>
		}
		box { <-0.58,0.5,0.18>,<0.58,0.58,0.19> }
		box { <-0.58,1.4,0.18>,<0.58,1.48,0.19> }
		box { <0.3,0.85,0.18>,<0.5,0.95,0.19> }
		object{hinge translate <.115,0,0>}
		object{hinge translate <.115,0.67,0>}
		object{hinge translate <.115,-0.70,0>}
		pigment { color rgb <0.2,0,0> }
		finish { ambient 0.1 diffuse 0.5 brilliance 2 specular 1 roughness 0.1 metallic }		 
	}       
	        cylinder{<-0.02,0,0>,<0.02,0,0>,0.03 translate <0.4,0.9,0.17> pigment{color rgb<.5,.2,.5>}}
	        
	        #local rivit=0;
	        #while (rivit<6)
	        sphere{<0,0,0>,0.02 pigment{Black} translate <-0.49+0.196*rivit,0.54,0.18>}
	        sphere{<0,0,0>,0.02 pigment{Black} translate <-0.49+0.196*rivit,1.44,0.18>}
	        #local rivit=rivit+1;
	        #end
	translate <0.6,0,-0.2>
	rotate <0,door_open,0>
	translate <-0.6,0,0.2>
}

/*
* scythe
*/

// - moved to shot02.inc - !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

/*
* clouds
*/

plane {
	-y,-201
	pigment {
		bozo
		color_map {
			[0.0 color rgbt <0,0,0,1>]
			[0.3 color rgbt <0,0,0,1>]
			[0.5 color rgbt <0,0,0,0.8>*Dimmer]
			[0.7 color rgbt <0,0,0,0>]
			[1.0 color rgbt <0,0,0,0>]
		}
		turbulence 2 lambda 1.9 octaves 9 omega 0.66
		scale <1200,100,300>
		translate <-100 * clock/4,1 * clock/4,0>  // reduced cloud speed to 1/4
		rotate <0,60,0>
	}
	finish {
		ambient 0 diffuse 1
	}
}

/*
* mountains
*/

sphere { <0,0,0>,1 scale <500,60,1> translate <+100,40,1000> pigment{Black}}
sphere { <0,0,0>,1 scale <400,70,1> translate <-650,50,1000> pigment{Black}}

/*
* web
*/

#declare web_text=texture{pigment{rgbt<1,1,1,.5>}finish{reflection .1  ambient .8}}
#declare web_spokes=7;
#declare web_x=0.75;
#declare web_y=1;
#declare web_thickness=0.001;
#declare web_spiral=0.002;
 

object{web(web_spokes,web_x,web_y,web_thickness,web_spiral,123,web_text)
rotate<0,180,0> rotate<0,0,0> translate<-1.02,1.88,0>
}

//////////// Fog //////////////////////

 /* fog {
    distance 6
    color rgbft<1.0, 1.0, 1.0, 1,.8>
    turbulence 1
    turb_depth .3
    fog_type 2
    fog_offset .1
    fog_alt .005
  }
  
  fog {
    distance 1.5
    color rgbft<1, .95, .95, 1, .85>
    turbulence .9
    turb_depth .9
  }*/
  

////// torch position //////////////////////////

#local flame_position = <2,1.5,-0.2>;

object{torch scale .75 rotate y*90 translate flame_position}

//flame(camera_location, flame_position, flame_height, time, hotair)
#ifdef(clock10)
	#local shear = 0;
	#if (clock10 > 0.7)
		#local cc = clock10 - 0.7;
		#local mag = max(0,1-cc);
		#local shear = mag * sin(cc*2*pi) * 0.3;
	#end
	sheared_flame(camera_location, flame_position, 0.7, clock_room - 200, false,shear)	// add flame without hot air
#else
	flame(camera_location, flame_position, 0.7, clock_room - 200, false)	// add flame without hot air
#end
