/*

===========================================================

     ATTENTION!!!!



     This file is in the Public Domain.

     Provided by the Internet Movie Project (www.imp.org)

===========================================================



 File        : sand.inc

 Project     : IRTC Entry for "The end of..." round

 cvs module  : theendof

 POV Version : 3.5

 Description : room with door and window

 Date        : 20031109

 Created by  : Sascha Ledinsky

 Copyright   : Released into the Public Domain

 

===========================================================

*/



/*

* this file contains macros to create the grains of sand

*

* one unit = 1m, time unit = 1sec

*/



#include "include/functions.inc"



/*

* sand grain material

*/

#declare grain = material {

	texture {

		pigment {

			color rgb 1

		}

		finish {

			ambient 0.8 diffuse 0.2

		}

	}

}



/*

* macro to set some parameters

*

* void initialize(vector Source, float t_end, int particles, float height, float grain_size)

* Source:	particle source

* t_end:	time when the last particle is crated

* particles:	max. number of paricles visible

* hight:	distance to fall

* grain_size:	in meters!

*/

#macro initialize_sand(Source,time,num, height, grain)

	#declare S = Source;

	#declare t_end = time;

	#declare particles = num;

	#declare t_fall = sqrt(2 * height / 9.80665);	// time to fall, g = 9.80665 m/s/s

	#declare grain_size = grain;

#end



/*

* void run(float time, float deltaT)

* time

* deltaT (deltaT to next frame, for motion blur)

*

* start particle system

*/

#macro run_sand(time, deltaT)		

	#local p1 = time * particles / t_fall;				//last particle visible

	#local p0 = p1 - particles;					//first particle visible

	#if (time > t_end)						//has the last particle fallen?

		#local p1 = p1 - (time - t_end) / t_fall * particles;

	#end

	

	#local p0 = int(p0);

	#local p1 = int(p1);

	

	#local p = p0;

	#while (p <= p1)						//loop over visible particles

		#local pos_this = particlePosition(p,time);		//compute current position

		#local pos_next = particlePosition(p,time + deltaT);	//compute position at t + deltaT

		

		//#debug concat("particle #",str(p,5,5)," pos:<",str(pos_this.x,5,5),",",str(pos_this.y,5,5),",",str(pos_this.z,5,5),">\n")

		

		union {							//draw motion blurred grain

			sphere { pos_this, grain_size }

			sphere { pos_next, grain_size }

			cylinder { pos_this, pos_next, grain_size}

			material { sand }

		}

		#local p = p + 1;

	#end

#end







/*------------------------------------------------------------------------------------------------------------*/

/*

* private macros, used by the run macro.....

*/





/*

* compute start time of particle (evenly distributed)

*/

#macro particleStartTime(n)

	n * t_fall / particles

#end



/*

* compute horizontal particle speed (random)

*

* vector particleHSpeed(int particle_number)

*/

#macro particleHSpeed(n)

	/*

	#declare r = seed(n);

	#local dummy = rand(r);

	#local dummy = rand(r);

	#declare rr = seed(int(rand(r)*10000));

	#local dummy = rand(rr);

	#local dummy = rand(rr);

	//<rand(r) - 0.5, 0, rand(r)* - 0.5> * 5;

	<rand(rr)*2-1,0,rand(rr)*2-1> * 2

	*/

	<f_agate(n,0,0).x * 2 - 1,0,f_agate(0,0,n).x * 2 - 1> * 0.02

#end



/*

* compute particles position at a given time

*

* vector particlePosition(int particle_number, float time)

*/

#macro particlePosition(n,T)

	#local t_p = T - particleStartTime(n);			// how long has the particle been falling

	#local s = 9.80665 * t_p * t_p / 2;			// a*t^2/2

	S - <0,s,0> + t_p * particleHSpeed(n)

#end