/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : hourglass_holder.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Makes wood frome for hourglass
 Date        : 20031115
 Created by  : Dennis Borree
 Modified by : Dennis Borree 20031122 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031214 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031220 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#include "scenes/shelfs/name_plate.inc"
#include "include/math.inc"
#declare hg_rotate1=0;
#macro hourglass_holder()

#declare base_height=half_height;
#declare base_width=glass_radius;


/////////////////////////    hourglass holder rods   ////////////////////////////////////////////////

//// type 0 rod = shape built rods should fit within ////

#declare hourglass_rod0 = cylinder {<0, 0, 0>, <0, (0.02+base_height*2), 0>, 0.01 translate <0, 0.015, 0> 
    texture { hourglass_texture scale 0.105 translate <rand(r), rand(r), rand(r)> rotate x*90 rotate y*(360*rand(r))}
  }

//// type 1 rod ////

#declare subrod_1 = cone {
    <0, -0.035, 0>, 0.015  
    <0, 0.035, 0>, 0.008}

#declare hourglass_rod1=merge{  sphere {<0, 0, 0>, 0.02 scale <1, 0.5, 1> translate y*0.220 }
  sphere {<0, 0, 0>, 0.02 scale <1, 0.5, 1> translate y*0.235 }
  sphere {<0, 0, 0>, 0.02 scale <1, 0.5, 1> translate y*0.25 }
  
  sphere {<0 ,0, 0>, 0.02 scale <1, 0.5, 1> translate y*.07 }
  
  sphere {<0, 0, 0>, 0.02 scale <1, 0.5, 1> translate y*.4 }
  
  
    object {subrod_1    
    translate y*0.0365

  }
  
    object {subrod_1    
    rotate x*180
    translate y*0.435

  } 
  
    object {subrod_1    
    rotate x*180
    translate y*0.1055

  }
  
     object {subrod_1    
    translate y*0.1755

  }
  
    object {subrod_1    
    rotate x*180
    translate y*0.2855

  }
  
    object {subrod_1    
    translate y*0.3555

  }
   scale <0.5, 0.94*base_height/0.2, 0.5> translate y*0.011 texture { hourglass_texture scale 0.105 translate <rand(r),rand(r),rand(r)> rotate x*90 rotate y*(360*rand(r))}}
  
//// type 2 rod ////

#declare subrod_2 = sphere{<0, 0, 0>, 0.01}

#declare hourglass_rod2 = 
merge {cylinder {<0, 0, 0>, <0, (0.02+base_height*2), 0>, 0.005}
       object {subrod_2 translate y*(0.01+base_height*2-0.04)}
       object {subrod_2 translate y*(0.01+base_height*2+0.015-0.04)}
       object {subrod_2 translate y*(0.01+base_height*2-0.015-0.04)}
       object {subrod_2 translate y*(0.01+base_height*0+0.04)}
       object {subrod_2 translate y*(0.01+base_height*0+0.015+0.04)}
       object {subrod_2 translate y*(0.01+base_height*0-0.015+0.04)}
       object {subrod_2 scale <1, base_height*70, 1> translate y*(0.01+base_height)}
       translate <0, 0.015, 0>
       texture { hourglass_texture scale 0.105 translate <rand(r), rand(r), rand(r)> rotate x*90 rotate y*(360*rand(r))}
       }
       
//// type 3 rod ////

#declare subrod_3a= torus{0.01, 0.003}
#declare subrod_3b= torus{0.009, 0.005}
#declare subrod_3c= torus{0.0075, 0.005}

#declare hourglass_rod3=merge{ difference{ cylinder {<0, 0, 0>, <0, (0.02+base_height*2), 0>, 0.0075}
           object {subrod_3b translate y*(0.02+base_height*2-0.05)}
           object {subrod_3b translate y*0.05}
           object {subrod_3b translate y*(0.02+base_height*1-0.01)}
           }
           object {subrod_3c translate y*(0.02+base_height*2-0.06)}
           object {subrod_3c translate y*(0.02+base_height*2-0.04)}
           object {subrod_3c translate y*0.06}
           object {subrod_3c translate y*0.04}
           object {subrod_3c translate y*(0.02+base_height)}
           object {subrod_3c translate y*(0.02+base_height*1-0.02)}
           translate y*0.015 
           texture { hourglass_texture scale 0.105 translate <rand(r), rand(r), rand(r)> rotate x*90 rotate y*(360*rand(r))}
           }


//// type 4 rod ////

#declare hourglass_rod4= difference{
merge {cylinder {<0, 0, 0>, <0, (0.02+base_height*2), 0>, 0.009 }
             box{<-0.005, 0, -0.005>,<0.005, (0.02+base_height*2)*.23, 0.005> scale <2, 1, 2> rotate y*45 }
             box{<-0.005, 0, -0.005>,<0.005, (0.02+base_height*2)*.23, 0.005> scale <2, 1, 2> rotate <180, 45, 0> translate y*(0.02+base_height*2)}
             }
             torus{0.001, 0.01 scale <1, 1, 1> translate y*(0.01+base_height)}
             torus{0.001, 0.01 scale <1, 1, 1> translate y*(0.25*(0.02+base_height*2))}
             torus{0.001, 0.01 scale <1, 1, 1> translate y*(0.75*(0.02+base_height*2))}
             torus{0.024, 0.015 scale <1, 1, 1> translate y*(0.02+base_height*2)*0.23}
             torus{0.024, 0.015 scale <1, 1, 1> translate y*(0.77*(0.02+base_height*2))} 
    translate <0, 0.015, 0> texture { hourglass_texture scale 0.105 translate <rand(r), rand(r), rand(r)> rotate x*90 rotate y*(360*rand(r))}
  }

//// type 5 rod ////  

//// type 5 rod ////
  
#declare rw=0.006;
#declare hourglass_rod5=merge {
             box{<-0.005, 0, -0.005>,<0.005, (0.02+base_height*2)*.23, 0.005> scale <2, 1, 2> rotate y*45 }
             box{<-0.005, 0, -0.005>,<0.005, (0.02+base_height*2)*.23, 0.005> scale <2, 1, 2> rotate <180, 45, 0> translate y*(0.02+base_height*2)}
             #local how_many=int((0.02+base_height*2)/(rw*2));
             #local what_count=0;
             #while (what_count<(how_many+1))
                torus{(0.01-rw),(rw) scale <1, 1, 1> rotate z*60 translate y*(what_count*((0.02+base_height*2)/(1*how_many)))}
             #local what_count= what_count + 1;
             #end           
              
    translate <0, 0.015, 0> texture { hourglass_texture scale 0.105 translate <rand(r), rand(r), rand(r)> rotate x*90 rotate y*(360*rand(r))}
  }

//// type 6 rod ////
  
#declare rw=0.003;
#declare hourglass_rod6=merge {cylinder {<0, 0, 0>, <0, (0.02+base_height*2), 0>, 0.006 }
                              sphere {<0, 0, 0>,(0.015*base_height/0.144) scale <1, 0.7, 1> translate y*0.5*(0.02+base_height*2)}
                              sphere {<0, 0, 0>,(0.015*base_height/0.144) scale <1, 0.7, 1> translate y*0.6*(0.02+base_height*2)}
                              sphere {<0, 0, 0>,(0.015*base_height/0.144) scale <1, 0.7, 1> translate y*0.4*(0.02+base_height*2)}
             #local how_many=int((0.02+base_height*2)/(rw*2)-25*base_height/0.144);
             #local what_count=0;
             #while (what_count<(how_many+1))
                torus{(0.01-rw),(rw) scale <1, 1, 1> rotate z*45 rotate y*90 translate y*(what_count*((0.02+base_height*2)/(1*how_many)))}
             #local what_count= what_count + 1;
             #end
             
             #local how_many=int((0.02+base_height*2)/(rw*2)-25*base_height/0.144);
             #local what_count=0;
             #while (what_count<(how_many+1))
                torus{(0.01-rw),(rw) scale <1, 1, 1> rotate z*-45 translate y*(what_count*((0.02+base_height*2)/(1*how_many)))}
             #local what_count= what_count + 1;
             #end           
              
    translate <0, 0.015, 0> texture { hourglass_texture scale 0.105 translate <rand(r), rand(r), rand(r)> rotate x*90 rotate y*(360*rand(r))}
  }

//// type 7 rod ////
  
#declare rw=0.003;
#declare hourglass_rod7=merge {cylinder {<0, 0, 0>, <0, (0.02+base_height*2)/5, 0>, 0.01 translate y*(0.02+base_height*2)/5 }
                               cylinder {<0, 0, 0>, <0, (0.02+base_height*2)/5, 0>, 0.01 translate y*3*(0.02+base_height*2)/5 }
                               sphere {<0, 0, 0>,0.015 scale <1, 0.7, 1>translate y*0.5*(0.02+base_height*2)}
             #local how_many=int((0.02+base_height*2)/(rw*2)-25*base_height/0.144);
             #local what_count=0;
             #while (what_count<(how_many+1))
                torus{(0.01-rw),(rw) scale <1, 1, 1> rotate z*45 rotate y*90 translate y*(what_count*((0.02+base_height*2)/(1*how_many)))}
             #local what_count= what_count + 1;
             #end
             
                          #local how_many=int((0.02+base_height*2)/(rw*2)-25*base_height/0.144);
             #local what_count=0;
             #while (what_count<(how_many+1))
                torus{(0.01-rw),(rw) scale <1, 1, 1> rotate z*-45 translate y*(what_count*((0.02+base_height*2)/(1*how_many)))}
             #local what_count= what_count + 1;
             #end           
              
    translate <0, 0.015, 0> texture { hourglass_texture scale 0.105 translate <rand(r), rand(r), rand(r)> rotate x*90 rotate y*(360*rand(r))}
  }

/////////////////////////////////////////////////////////////////////////////////////////////////////


//// hourglass base and top parts  ////////////////////////////////////////////////////////////////////

//// type 0 base/top ////

#declare base_sub0   = cylinder {<0, 0, 0>,<0, 0.025, 0>, 0.15}

#declare base_0 = merge {object { base_sub0 texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         object { base_sub0 translate y*((0.025+base_height*2)) texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         scale <base_width/0.08, 1, base_width/0.08>
                         }
     
//// type 1 base/top ////

#declare base_sub1_1 = superellipsoid {<1, 0.5> scale <0.135, 0.135, 0.02> rotate x*90}
#declare base_sub1_2 = cylinder {<0, 0, 0>, <0, 0.02, 0>, 0.15}
#declare base_sub1a  = merge{object{base_sub1_1 translate y*0.025}
                             object{base_sub1_2}
                            }
                           
#declare base_1=union{object{base_sub1a texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                             object{base_sub1a rotate x*180 translate y*((0.05+base_height*2)/0.55)  texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}} 
                             scale <base_width/0.08, 0.55, base_width/0.08>}
                             
//// type 2 base/top ////

#declare base_sub2_1   = cone {<0, 0, 0>, 0.15
                               <0, 0.01, 0>, 0.145}
#declare base_sub2_2   = cone {<0, 0.01, 0>, 0.14
                               <0, 0.02, 0>, 0.135}
#declare base_sub2_3   = cone {<0, 0.02, 0>, 0.13
                               <0, 0.025, 0>, 0.125}
                             
                             
                             
#declare base_sub2=merge{object {base_sub2_1}
                         object {base_sub2_2}
                         object {base_sub2_3} 
                         texture { hourglass_texture scale 0.105 translate <rand(r), rand(r), rand(r)> rotate z*-90 rotate y*(360*rand(r))}
                        }

#declare base_2 = merge {object { base_sub2}   
                         object { base_sub2         
                         rotate x*180
                         translate y*((0.05+base_height*2))}   
                         scale <base_width/0.08, 1, base_width/0.08>
                         }
     
//// type 3 base/top ////

#declare base_sub3=merge{cylinder {<0,0,0>, <0, 0.025, 0>, 0.146}
                         torus{0.146, 0.004 translate y*0.004 }
                         torus{0.146, 0.004 translate y*0.012 }
                         torus{0.146, 0.004 translate y*0.020 }
                         texture { hourglass_texture scale 0.05 rotate x*70 rotate y*(360*rand(r))}
                         scale <base_width/0.08, 1, base_width/0.08>}

#declare base_3 = merge {object { base_sub3 texture { hourglass_texture scale 0.1 rotate x*60 rotate y*(360*rand(r))}}
                         object { base_sub3 translate y*((0.025+base_height*2)) texture { hourglass_texture scale 0.1 rotate x*-60 rotate y*(360*rand(r))}}
                        }
         

//// type 4 base/top ////

#declare base_sub4= merge{ cylinder {<0, 0, 0>,<0, 0.025, 0>, 0.144}
                 #local step = 0;
                 #while (step<=360)
                 sphere {<0, 0, 0>, 0.006 scale <1.3, 1, 1> rotate y*step translate <0.144*sind(step), 0.0125, 0.144*cosd(step)> }
                 #local step=step+10;
                 #end
                 #local step = 5;
                 #while (step<=360)
                 sphere {<0, 0, 0>, 0.006 scale <1.3, 1, 1> rotate y*step translate <0.144*sind(step), 0.01875, 0.144*cosd(step)> }
                 sphere {<0, 0, 0>, 0.006 scale <1.3, 1, 1> rotate y*step translate <0.144*sind(step), 0.00625, 0.144*cosd(step)> }
                 #local step=step+10;
                 #end
                 texture { hourglass_texture scale 0.1 rotate x*-60 rotate y*(360*rand(r))}
                 }


#declare base_4 = merge {object { base_sub4 texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         object { base_sub4 translate y*((0.025+base_height*2)) texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         scale <base_width/0.08, 1, base_width/0.08>
                         }
                         
//// type 5 base/top ////
                         
#declare base_sub5 = merge{#local base_sizing = base_width/0.08;
                           #local base_sizing1 = 0.15*base_sizing;
                           #local base_sizing2 = 0.0025;
                           #local base_sizing3 = base_sizing1-base_sizing2;
                           cylinder {<0, 0, 0>,<0, 0.025, 0>, (base_sizing1-base_sizing2)}
                           torus{(base_sizing1-base_sizing2), (base_sizing2) translate y*(.025-base_sizing2)}
                           torus{(base_sizing1-base_sizing2), (base_sizing2) translate y*(base_sizing2)}
                           
                           #local step = 0;
                           #while (step<=360)
                           cylinder {<0, 0, 0>,<0, 0.025-2*base_sizing2, 0>, base_sizing2  translate <(base_sizing1-base_sizing2)*sind(step), base_sizing2, (base_sizing1-base_sizing2)*cosd(step)> }
                           #local step=step+3/base_sizing;
                           #end
                                 }

#declare base_5 = merge {object { base_sub5 texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         object { base_sub5 translate y*((0.025+base_height*2)) texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         }

//// type 6 base/top ////

#declare base_sub6 = merge{difference{#local base_sizing = base_width/0.08;
                                #local base_sizing1 = 0.15*base_sizing;
                                #local base_sizing2 = 0.7;
                                #local base_sizing3 = 0.0025;
                                cylinder {<0, 0, 0>,<0, 0.025, 0>, (base_sizing1)}
                                torus{(base_sizing1), 0.0125*base_sizing2 translate y*0.0125}
                                }
                                #local step = 0;
                           #while (step<=360)
                           cylinder {<0, 0, 0>,<0, 0.025*0.8, 0>, base_sizing3  translate <(base_sizing1-base_sizing3)*sind(step), 0.0025, (base_sizing1-base_sizing3)*cosd(step)> }
                           #local step=step+3/base_sizing;
                           #end
                                }

#declare base_6 = merge {object { base_sub6 texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         object { base_sub6 translate y*((0.025+base_height*2)) texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         }

//// type 7 base/top ////

#declare base_sub7 = merge{difference{#local base_sizing = base_width/0.08;
                                #local base_sizing1 = 0.15*base_sizing;
                                #local base_sizing2 = 0.7;
                                #local base_sizing3 = 0.0025;
                                cylinder {<0, 0, 0>,<0, 0.025, 0>, (base_sizing1)}
                                torus{(base_sizing1), 0.0125*base_sizing2 translate y*0.0125}
                                }
                                #local step = 0;
                           #while (step<=360)
                           torus{ 0.0088,.001  rotate z*90 rotate y*(step+60)  translate <(base_sizing1-base_sizing3-.004)*sind(step), 0.0125, (base_sizing1-base_sizing3-.004)*cosd(step)> }
                           torus{ 0.0088,.001  rotate z*90 rotate y*(step-60)  translate <(base_sizing1-base_sizing3-.004)*sind(step), 0.0125, (base_sizing1-base_sizing3-.004)*cosd(step)> }
                           sphere{<0, 0, 0>, 0.002 translate <(base_sizing1-base_sizing3-.000)*sind(step+3/base_sizing/2), 0.0125, (base_sizing1-base_sizing3-.000)*cosd(step+3/base_sizing/2)>}
                           sphere{<0, 0, 0>, 0.002 translate <(base_sizing1-base_sizing3-.000)*sind(step), 0.019, (base_sizing1-base_sizing3-.000)*cosd(step)>}
                           sphere{<0, 0, 0>, 0.002 translate <(base_sizing1-base_sizing3-.000)*sind(step), 0.006, (base_sizing1-base_sizing3-.000)*cosd(step)>}
                           #local step=step+3/base_sizing;
                           #end
                                }


#declare base_7 = merge {object { base_sub7 texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         object { base_sub7 translate y*((0.025+base_height*2)) texture { hourglass_texture scale 0.2 rotate y*(360*rand(r))}}
                         }

/////////////////////////////////////////////////////////////////////////////////////////////////////

#if (hourglass_base_style = 1) #declare hourglass_base = base_1 #end
#if (hourglass_base_style = 2) #declare hourglass_base = base_2  #end
#if (hourglass_base_style = 3) #declare hourglass_base = base_3  #end
#if (hourglass_base_style = 4) #declare hourglass_base = base_4  #end
#if (hourglass_base_style = 5) #declare hourglass_base = base_5  #end
#if (hourglass_base_style = 6) #declare hourglass_base = base_6  #end
#if (hourglass_base_style = 7) #declare hourglass_base = base_7  #end
#if (hourglass_rods_style = 1) #declare hourglass_rods = hourglass_rod1 #end
#if (hourglass_rods_style = 2) #declare hourglass_rods = hourglass_rod2  #end
#if (hourglass_rods_style = 3) #declare hourglass_rods = hourglass_rod3  #end
#if (hourglass_rods_style = 4) #declare hourglass_rods = hourglass_rod4  #end
#if (hourglass_rods_style = 5) #declare hourglass_rods = hourglass_rod5  #end
#if (hourglass_rods_style = 6) #declare hourglass_rods = hourglass_rod6  #end
#if (hourglass_rods_style = 7) #declare hourglass_rods = hourglass_rod7  #end


/////////////////////////////////////////////////////////////////////////////////////////////////////

merge{ object {hourglass_base}  
       object {hourglass_rods rotate <0, 45, 0> translate x* (0.01+base_width )}
       object {hourglass_rods rotate y*90 translate x* -(0.01+base_width ) }
       object {hourglass_rods rotate y*135 translate z* (0.01+base_width ) }
       object {hourglass_rods translate z* -(0.01+base_width ) }
       object {Name_Plate(name_number) rotate y*(225+hg_rotate1/2)}
     }
#end


