/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shelf_fill.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Fills the shelves with hourglasses
 Date        : 20031115
 Created by  : Dennis Borree
 Modified by : Dennis Borree 20031122 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031214 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031220 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#include "scenes/hourglass/hourglass.inc"
#include "scenes/shelfs/web.inc"
#include "scenes/shelfs/web_fill.inc"

#macro shelf_fill(row_start,row_finish,column_start,column_finish,shelving)

//#include "scenes/hourglass/five_majors.inc"

#declare preview=false;
                            

////// Gives the X location of the 2 shelves to be filled /////////////

#if (shelving=1) #declare x_locate=-0.78;#declare webx_locate=-0.705; #declare hg_rotate2=0; #end
#if (shelving=2) #declare x_locate=0.78;#declare webx_locate=0.705; #declare hg_rotate2=180; #end

//// Loop to fill shelves /////////////////////////////////////////////

#declare hourglass_base_style = 1;
#declare hourglass_rods_style = 1;
#declare name_number=int(20*rand(r));


#ifdef(clock06)
/////////////////////////////////////////////////////
#declare row=9;                                    //
#declare column=9;                                 //
                                                   //
#declare grain_size = 0.001;                       //
#declare deltaT = 1/framerate;                     //
#declare time = clock06;                           //
#declare sl = pow((9.2-time),1/3)*0.01;            //
#declare nameplate_font= "fonts/riverave.ttf";     //
                                                   //    fills in
#include "scenes/hourglass/five_majors.inc"        //
                                                   //    the 5 major
#declare column=9;                                 //
    object {third_left_one}                        //
    #local webx_locate=-0.705-0.25;                //
    web_fill()   // adds spider webs               //    hourglasses
                                                   //                                                   
#declare column=10;                                //
    object {second_left_one}                       //
    #local webx_locate=-0.705-0.25;                //
    web_fill()   // adds spider webs               //
    #declare webx_locate=-0.705;                   //
                                                   //
    object {left_one}                              //
                                                   //
                                                   //
    object {the_one}                               //
                                                   //
                                                   //
    object {right_one}                             //
#end                                               //
/////////////////////////////////////////////////////

#declare nameplate_font="fonts/aurabesh.ttf";

#declare row=row_start;
#while (row<=row_finish)
#declare column=column_start;
#while (column<=column_finish)



#declare random_wood_texture=int(30*rand(r));
#if (random_wood_texture = 0)  #declare hourglass_texture=T_Wood1;#end
#if (random_wood_texture = 1)  #declare hourglass_texture=T_Wood2;#end
#if (random_wood_texture = 2)  #declare hourglass_texture=T_Wood3;#end
#if (random_wood_texture = 3)  #declare hourglass_texture=T_Wood4;#end
#if (random_wood_texture = 4)  #declare hourglass_texture=T_Wood5;#end
#if (random_wood_texture = 5)  #declare hourglass_texture=T_Wood6;#end
#if (random_wood_texture = 6)  #declare hourglass_texture=T_Wood7;#end
#if (random_wood_texture = 7)  #declare hourglass_texture=T_Wood8;#end
#if (random_wood_texture = 8)  #declare hourglass_texture=T_Wood9;#end
#if (random_wood_texture = 9)  #declare hourglass_texture=T_Wood10;#end
#if (random_wood_texture = 10)  #declare hourglass_texture=T_Wood11;#end
#if (random_wood_texture = 11)  #declare hourglass_texture=T_Wood12;#end
#if (random_wood_texture = 12)  #declare hourglass_texture=T_Wood13;#end
#if (random_wood_texture = 13)  #declare hourglass_texture=T_Wood14;#end
#if (random_wood_texture = 14)  #declare hourglass_texture=T_Wood15;#end
#if (random_wood_texture = 15)  #declare hourglass_texture=T_Wood16;#end
#if (random_wood_texture = 16)  #declare hourglass_texture=T_Wood17;#end
#if (random_wood_texture = 17)  #declare hourglass_texture=T_Wood18;#end
#if (random_wood_texture = 18)  #declare hourglass_texture=T_Wood19;#end
#if (random_wood_texture = 19)  #declare hourglass_texture=T_Wood20;#end
#if (random_wood_texture = 20)  #declare hourglass_texture=T_Wood21;#end
#if (random_wood_texture = 21)  #declare hourglass_texture=T_Wood22;#end
#if (random_wood_texture = 22)  #declare hourglass_texture=T_Wood23;#end
#if (random_wood_texture = 23)  #declare hourglass_texture=T_Wood24;#end
#if (random_wood_texture = 24)  #declare hourglass_texture=T_Wood25;#end
#if (random_wood_texture = 25)  #declare hourglass_texture=T_Wood26;#end
#if (random_wood_texture = 26)  #declare hourglass_texture=T_Wood27;#end
#if (random_wood_texture = 27)  #declare hourglass_texture=T_Wood28;#end
#if (random_wood_texture = 28)  #declare hourglass_texture=T_Wood29;#end
#if (random_wood_texture = 29)  #declare hourglass_texture=T_Wood30;#end
#if (random_wood_texture = 30)  #declare hourglass_texture=T_Wood31;#end
#if (random_wood_texture = 31)  #declare hourglass_texture=T_Wood32;#end
#if (random_wood_texture = 32)  #declare hourglass_texture=T_Wood33;#end


////////////////////////////////random base/rod pick/////////////////////////////////////////////////

#ifdef(clock06)
#if (row=9 )

#local hmm=0; 
#while (hmm<300)
#declare base_random= rand(r);
#local hmm=hmm+1;
#end

#if (base_random<0.2) #declare hourglass_base_style = 1;  #end
#if (base_random>=0.2) #if (base_random<0.4) #declare hourglass_base_style = 2;#end #end
#if (base_random>=0.4) #if (base_random<0.6) #declare hourglass_base_style = 3;#end #end
#if (base_random>=0.6) #if (base_random<0.8) #declare hourglass_base_style = 4;#end #end
#if (base_random>=0.8) #declare hourglass_base_style = 5; #end

#local hmm=0; 
#while (hmm<300)
#declare rod_random= rand(r);
#local hmm=hmm+1;
#end

#if (rod_random<0.2) #declare hourglass_rods_style = 1;  #end
#if (rod_random>=0.2) #if (rod_random<0.4) #declare hourglass_rods_style = 2;#end #end
#if (rod_random>=0.4) #if (rod_random<0.6) #declare hourglass_rods_style = 3;#end #end
#if (rod_random>=0.6) #if (rod_random<0.8) #declare hourglass_rods_style = 4;#end #end
#if (rod_random>=0.8) #declare hourglass_rods_style = 5; #end


/////////////////////////////////////////////////////////////////////////////////////////////////////

///////// finishes fill on row  after 5 majors //////////////////

#if(column>13)

#declare time=clock;
#declare preview=true;
#declare glass=false;
#declare level_of_detail= 0;
#declare framerate = 30;
#declare deltaT = 1/framerate;
#declare grain_size = 0.001;
#declare nameplate_font= "fonts/aurabesh.ttf";

#if (row>=pre_row1 & row<=pre_row2 & column>=pre_column1 & column<=pre_column2)
#declare preview=false;
#declare glass=true;
#declare level_of_detail= 1;
#end

        #local hmm=0; 
        #while (hmm<300)
        #declare height_random= rand(r);
        #local hmm=hmm+1;
        #end
	#local half_height = 0.12+0.04*height_random;
	#local glass_radius = 0.4*half_height+0.4*rand(r)*(0.16-half_height);

#declare hourglass_glass =
object {
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = half_height*0.80-half_height*0.40*rand(r); 
	#local sand_level_2 = half_height*0.80-sand_level_1;
	#local time_end = 1000;
	#local level_of_detail=3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0,half_height + glass_thickness + .025,0> 
}

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare name_number=int(20*rand(r));
#declare hg_rotate=(40+rand(r)*10);
#declare hg_rotate1=hg_rotate-22.5;

#if (glass=false)
#declare hourglass_glass=sphere{<0,0,0>,0.000001 pigment{Black}}
#end

#declare hourglass_complete= union{
  object {hourglass_holder() rotate y*hg_rotate}
  object {hourglass_glass}
  }

object {hourglass_complete  translate <x_locate,0.11+row*0.5,-3.55+column*0.3>}


web_fill()   // adds spider webs

#end
//// fills in row before 5 majors  ///////////

#if(column<9)

#declare time=clock;
#declare preview=true;
#declare glass=false;
#declare level_of_detail= 0;
#declare framerate = 30;
#declare deltaT = 1/framerate;
#declare grain_size = 0.001;
#declare nameplate_font= "fonts/aurabesh.ttf";

#if (row>=pre_row1 & row<=pre_row2 & column>=pre_column1 & column<=pre_column2)
#declare preview=false;
#declare glass=true;
#declare level_of_detail= 1;
#end

        #local hmm=0; 
        #while (hmm<300)
        #declare height_random= rand(r);
        #local hmm=hmm+1;
        #end
	#local half_height = 0.12+0.04*height_random;
	#local glass_radius = 0.4*half_height+0.4*rand(r)*(0.16-half_height);

#declare hourglass_glass =
object {
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = half_height*0.80-half_height*0.40*rand(r); 
	#local sand_level_2 = half_height*0.80-sand_level_1;
	#local time_end = 1000;
	#local level_of_detail=3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0, half_height + glass_thickness + 0.025, 0> 
}

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare name_number=int(20*rand(r));
#declare hg_rotate=(40+rand(r)*10);
#declare hg_rotate1=hg_rotate-22.5;

#if (glass=false)
#declare hourglass_glass=sphere{<0,0,0>,0.000001 pigment{Black}}
#end

#declare hourglass_complete= union{
  object {hourglass_holder() rotate y*hg_rotate}
  object {hourglass_glass}
  }

object {hourglass_complete  translate <x_locate, 0.11+row*0.5, -3.55+column*0.3>}

web_fill()   // adds spider webs

#end




#else

/////// fills in for all rows in shot06 but the row the 5 majors are in  /////////

#declare time=clock;
#declare preview=true;
#declare glass=false;
#declare level_of_detail= 0;
#declare framerate = 30;
#declare deltaT = 1/framerate;
#declare grain_size = 0.001;
#declare nameplate_font= "fonts/aurabesh.ttf";

#if (row>=pre_row1 & row<=pre_row2 & column>=pre_column1 & column<=pre_column2)
#declare preview=false;
#declare glass=true;
#declare level_of_detail= 1;
#end

        #local hmm=0; 
        #while (hmm<300)
        #declare height_random= rand(r);
        #local hmm=hmm+1;
        #end
	#local half_height = 0.12+0.04*height_random;
	#local glass_radius = 0.4*half_height+0.4*rand(r)*(0.16-half_height);

#declare hourglass_glass =
object {
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = half_height*0.80-half_height*0.40*rand(r); 
	#local sand_level_2 = half_height*0.80-sand_level_1;
	#local time_end = 1000;
	#local level_of_detail=3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0, half_height + glass_thickness + .025, 0> 
}
////////////////////////////////random base/rod pick/////////////////////////////////////////////////

#local hmm=0; 
#while (hmm<300)
#declare base_random= rand(r);
#local hmm=hmm+1;
#end

#if (base_random<0.2) #declare hourglass_base_style = 1;  #end
#if (base_random>=0.2) #if (base_random<0.4) #declare hourglass_base_style = 2;#end #end
#if (base_random>=0.4) #if (base_random<0.6) #declare hourglass_base_style = 3;#end #end
#if (base_random>=0.6) #if (base_random<0.8) #declare hourglass_base_style = 4;#end #end
#if (base_random>=0.8) #declare hourglass_base_style = 5; #end

#local hmm=0; 
#while (hmm<300)
#declare rod_random= rand(r);
#local hmm=hmm+1;
#end

#if (rod_random<0.2) #declare hourglass_rods_style = 1;  #end
#if (rod_random>=0.2) #if (rod_random<0.4) #declare hourglass_rods_style = 2;#end #end
#if (rod_random>=0.4) #if (rod_random<0.6) #declare hourglass_rods_style = 3;#end #end
#if (rod_random>=0.6) #if (rod_random<0.8) #declare hourglass_rods_style = 4;#end #end
#if (rod_random>=0.8) #declare hourglass_rods_style = 5; #end


/////////////////////////////////////////////////////////////////////////////////////////////////////

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare name_number=int(20*rand(r));
#declare hg_rotate=(40+rand(r)*10);
#declare hg_rotate1=hg_rotate-22.5;

#if (glass=false)
#declare hourglass_glass=sphere{<0,0,0>,0.000001 pigment{Black}}
#end

#declare hourglass_complete= union{
  object {hourglass_holder() rotate y*hg_rotate}
  object {hourglass_glass}
  }

object {hourglass_complete  translate <x_locate, 0.11+row*0.5, -3.55+column*0.3>}

web_fill()   // adds spider webs

#end

///////// fills in hourglasses in all shots but shot06 /////////

#else

#declare preview=true;
#declare glass=false;
#declare level_of_detail= 0;
#declare time=clock;
#declare framerate = 30;
#declare deltaT = 1/framerate;
#declare grain_size = 0.001;

#if (row>=pre_row1 & row<=pre_row2 & column>=pre_column1 & column<=pre_column2)
#declare preview=false;
#declare glass=true;
#declare level_of_detail= 1;
#end

#local hmm=0; 
        #while (hmm<300)
        #declare height_random= rand(r);
        #local hmm=hmm+1;
        #end
	#local half_height = 0.12+0.04*height_random;
	#local glass_radius = 0.4*half_height+0.4*rand(r)*(0.16-half_height);

#declare hourglass_glass =
object {
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = half_height*0.80-half_height*0.40*rand(r); 
	#local sand_level_2 = half_height*0.80-sand_level_1;
	#local time_end = 1000;
	#local level_of_detail= 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <0, half_height + glass_thickness + 0.025, 0> 
}

////////////////////////////////random base/rod pick/////////////////////////////////////////////////

#local hmm=0; 
#while (hmm<300)
#declare base_random= rand(r);
#local hmm=hmm+1;
#end

#if (base_random<0.2) #declare hourglass_base_style = 1;  #end
#if (base_random>=0.2) #if (base_random<0.4) #declare hourglass_base_style = 2;#end #end
#if (base_random>=0.4) #if (base_random<0.6) #declare hourglass_base_style = 3;#end #end
#if (base_random>=0.6) #if (base_random<0.8) #declare hourglass_base_style = 4;#end #end
#if (base_random>=0.8) #declare hourglass_base_style = 5; #end

#local hmm=0; 
#while (hmm<300)
#declare rod_random= rand(r);
#local hmm=hmm+1;
#end

#if (rod_random<0.2) #declare hourglass_rods_style = 1;  #end
#if (rod_random>=0.2) #if (rod_random<0.4) #declare hourglass_rods_style = 2;#end #end
#if (rod_random>=0.4) #if (rod_random<0.6) #declare hourglass_rods_style = 3;#end #end
#if (rod_random>=0.6) #if (rod_random<0.8) #declare hourglass_rods_style = 4;#end #end
#if (rod_random>=0.8) #declare hourglass_rods_style = 5; #end


/////////////////////////////////////////////////////////////////////////////////////////////////////

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare name_number=int(20*rand(r));
#declare hg_rotate=(40+rand(r)*10);
#declare hg_rotate1=hg_rotate-22.5;

#if (glass=false)
#declare hourglass_glass=sphere{<0,0,0>,0.000001 pigment{Black}}
#end

#declare hourglass_complete= union{
  object {hourglass_holder() rotate y*(hg_rotate+hg_rotate2)}
  object {hourglass_glass}
  }

object {hourglass_complete  translate <x_locate, 0.11+row*0.5, -3.55+column*0.3>}

web_fill()   // adds spider webs


#end

#declare column=column+1;
#end
#declare row=row+1;
#end

#end