/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : torch.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : makes a torch
 Date        : 20040106
 Created by  : Dennis Borree
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#include "include/metals.inc"

#declare torch_material = material {
	texture {
		pigment {
			color rgb <0.70, 0.55, 0.40>//color rgb 0.2
		}
		finish {
			ambient 0.00 diffuse 1 brilliance 1 specular 1 roughness 0.05
			reflection {
				0 1
				falloff 2
			}
			conserve_energy
		}
	}
}

#declare torch_material2 = material {
	texture {
		pigment {
			color rgb 0.2 
		}
		finish {
			ambient 0.00 diffuse 1 brilliance 0.5 specular .5 roughness 0.35
			reflection {
				0 1
				falloff 2
			}
			conserve_energy
		}
	}
}
		
#declare torch_a=difference{union{union{                            
                                        torus{0.15, 0.03  translate<0, -0.03, 0>}
                                        cone{<0,0,0>, 0.15 <0,-0.05,0>, 0.12 translate<0, -0.06, 0> }
                                        cone{<0,0,0>, 0.12 <0,-0.89,0>, 0.05 translate<0, -0.11, 0>}
                                        sphere{<0, 0, 0>, 0.1 scale<1, 0.25, 1>translate<0, -1, 0>}
                                        sphere{<0, 0, 0>, 0.07 translate <0, -1, 0> }
                                        
                                        material { torch_material }
                                       }
                                        cone{<0,0,0>, 0.12 <0,-0.05,0>, 0.117 material { torch_material2 } translate<0, -0.31, 0>} //upper attachment
                                        cone{<0,0,0>, 0.085 <0,-0.05,0>, 0.08 material { torch_material2 } translate<0, -0.75, 0>} // lower attachment
                                        
                                            difference{
                                                       cylinder{<0, 0, 0>,<0, 0.07, 0>, 0.15 translate<0, 0, 0>}
                                                       cylinder{<0, 0, 0>,<0, 0.08, 0>, 0.14 translate<0, 0, 0>}
                                        
                                                       material { torch_material2 }
                                                       }
                                  }

                                   #local seg_rot=0;
                                   #while (seg_rot<=360)
                                   box{<-0.2, -0.015, -0.015>,<0.2, 0.015, 0.015> rotate x*45 rotate y*seg_rot translate<0, 0.035, 0> }
                                   #local seg_rot=seg_rot+22.5;
                                   #end
                                   
                              scale <0.6, 1, 0.6> rotate z*-10 
                              }


#declare torch_mount=union{
                           box{<-0.38, 0, -0.01>,<0, 0.05, 0.01>  translate <-0.08, -0.34, 0>}
                           box{<-0.28, 0, -0.01>,<0, 0.05, 0.01>  translate <-0.18, -0.78, 0>}
                           box{<-0.07, 0, -0.02>,<0, 0.07, 0.02>  translate <-0.45, -0.35, 0>}
                           box{<-0.07, 0, -0.02>,<0, 0.07, 0.02>  translate <-0.45, -0.79, 0>}
                           sphere{<0, 0, 0>, 0.01 translate <-0.505, -0.295, -0.02>}
                           sphere{<0, 0, 0>, 0.01 translate <-0.47, -0.295, -0.02>}
                           sphere{<0, 0, 0>, 0.01 translate <-0.505, -0.335, -0.02>}
                           sphere{<0, 0, 0>, 0.01 translate <-0.47, -0.335, -0.02>}
                           sphere{<0, 0, 0>, 0.01 translate <-0.505, -0.735, -0.02>}
                           sphere{<0, 0, 0>, 0.01 translate <-0.47, -0.735, -0.02>}
                           sphere{<0, 0, 0>, 0.01 translate <-0.505, -0.775, -0.02>}
                           sphere{<0, 0, 0>, 0.01 translate <-0.47, -0.775, -0.02>}

                           material { torch_material2 }

                           }

#declare torch= union{
                      object{torch_a}
                      object{torch_mount}
                      }