/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : web.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Makes spider webs
 Date        : 20031231
 Created by  : Dennis Borree (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

//WEB: simple INC-file to create a spiderweb in a corner
//March 2000 - Remco de Korte
//e-mail: remcodek@xs4all.nl
//web:    www.xs4all.nl/~remcodek/

/*camera {
  location<0,0,-3>
  look_at<0,0,0>
  angle 30    
  orthographic
}

  light_source { <-10, 10, -10> color rgb .7 }
  light_source { <10, 10, -10> color rgb .5 shadowless}
  light_source { <-10, -10, 10> color rgb 0.3 shadowless}
  light_source { <10, -10, -10> color rgb 0.1 shadowless}

background { color rgb 0}*/  

#macro web(pcount,xsize,ysize,Size,step,randseed,wtext)
  
/*the values between brackets assume a web of 1 pov-unit in size

   pcount      - number of points at each side of the web [4..6]
   xsize/ysize - hor. and vert. size of the web
   size        - size of the threads [0.005]
   step        - space between the threads [0.005]
   randseed    - ???                               
   wtext       - texture
*/

  #ifndef(web_round)  
    #local web_round=.5;
  #end               
  /* web_round indicates how round the inside of the web is
     range [0..1] with 1 giving the most round result */


  #local rpoint=array[pcount*3] // setting up point-array
  #local h0=<0,0>;              // setting up corners 
  #local h1=<xsize,0>;
  #local h2=<0,-ysize>;
  #local rs=seed(randseed);     // initializing rand seed
  #local mm=(h0+h1+h2)/4;       // calculating center of the web
  #local tt=0;#while(tt<pcount) // calcuting points on the edge
    #local vv=rand(rs)/3;
    #local rpoint[tt]=(h2*(tt+vv+1)+h1*(pcount-tt-vv))/(pcount+1);
    #local rpoint[tt+pcount]=(h0*(tt+vv+1)+h2*(pcount-tt-vv))/(pcount+1);
    #local rpoint[tt+pcount*2]=(h1*(tt+vv+1)+h0*(pcount-tt-vv))/(pcount+1);
  #local tt=tt+1;#end

  #local tt=0;#while (tt<pcount) // pinching the 'free' side (support thread)
    #local zz=abs(tt*2-pcount+1)/pcount;
    #local rpoint[tt]=rpoint[tt]*(.8+zz*zz*.2);
  #local tt=tt+1;#end
    

  union{
    cylinder{h1,rpoint[0],Size} // creating the 'support thread' (h1->h2)
    cylinder{h2,rpoint[pcount-1],Size}
    #local tt=0;#while (tt<pcount-1)
      cylinder{rpoint[tt],rpoint[tt+1],Size}
    #local tt=tt+1;#end

    #local tt=0;#while (tt<pcount*3) // creating the spokes
      cylinder{rpoint[tt],mm,Size}
    #local tt=tt+1;#end
    

    #local ms=vlength((h1+h2)/2-mm); // setting up the spiral
    #local cc=0;
    #local ss=ms/10;

    #local p2=rpoint[cc]-mm;
    #local p2=mm+p2*ss/vlength(p2);
    #local zz=ss/ms;
    #local q2=rpoint[cc]*zz+mm*(1-zz);

    #while (ss<ms*.75) // creating spiral
      #local p1=p2;
      #local q1=q2;
      
      #local cc=cc+1;    
      #if (cc=pcount*3) #local cc=0; #end
      #local ss=ss+step*rand(rs); 
      
      #local p2=rpoint[cc]-mm;
      #local p2=mm+p2*ss*(.95+rand(rs)/10)/vlength(p2);
      #local zz=ss/ms;
      #local q2=rpoint[cc]*zz+mm*(1-zz);
      
      #local v1=web_round;
      #local v2=1-v1;
      cylinder{p1*v1+q1*v2,p2*v1+q2*v2,Size}
    #end
    
    texture{wtext} 
 
  }
#end

//eof