/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot01.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Title Shot
 Date        : 20031031
 Created by  : Tom Galvin (tom - at - imp - dot - org)
 Edited by   :  
 Copyright   : Released into the Public Domain
 
===========================================================
*/

//
//   3 seconds
//
 
//*



//#declare bat_time=clock01;
//#include "include/transforms.inc"

 
camera {
   location 0
   look_at z
   right 16/9 * x
   up y
   angle 90
   rotate <-20,0,0>
   translate <0,50,0>
}


//Title
/*
text {
	ttf "fonts/riverave.ttf"
	"The End of..."
	0.25, 0
	pigment {rgbt <1,1,1,1-(clock01/shot01Length*.75)>}
	finish { ambient rgb <0.5,0.5,0.55> }
	scale <1,1,.1>
	rotate<0,180,0>
	translate <3,1,0+clock01*10>
}
*/
plane { z,1
	pigment {
		image_map { png "image/EndOf4.png" once}
		translate <-0.5,-0.5,0>
		translate <0,0,1>
		scale <2,2/(16/9),1>
	}
	rotate <-20,0,0>
	translate <0,50,0>
	finish {
		diffuse 0 ambient 1
	}
no_shadow
}

 
//SKY
/*
plane {
	-y,-21
	pigment {
		bozo
		color_map {
			[0.0 color rgb <0.7,0.3,1.0>]
			[0.5 color rgb <0,0,0.5>]
			[1.0 color rgb 0]
		}
		turbulence 2 lambda 1.9 octaves 9 omega 0.66
		scale <1200,100,300>
		rotate <0,60,0>
	}
	finish {
		ambient 0.3 diffuse 1
	}
} 
*/
background { color rgb <0,0,1.0> }
//Clouds

fog {
	fog_type 2
	fog_alt 100
	distance 200
	color rgb 0
}

plane {
	-y,-200
	pigment {
		bozo
		color_map {
			[0.0 color rgbt <0,0,0,1>]
			[0.4 color rgbt <0,0,0,1>]
			//[0.5 color rgbt <0,0,0,0.8>]
			[0.6 color rgbt <0,0,0,0>]
			[1.0 color rgbt <0,0,0,0>]
		}
		turbulence 2 lambda 1.9 octaves 9 omega 0.66
		scale <1200,100,300>
		translate <clock01*20,clock01/10,clock01*5>
		rotate <0,60,0>
		
	}
	finish {
		ambient 1 diffuse 0
	}
}

plane {
	-y,-300
	pigment {
		bozo
		color_map {
			[0.0 color rgbt <1,1,0,1>]
			//[0.4 color rgbt <1,1,0,1>]
			[0.6 color rgbt <1,0.5,0,0.5>]
			//[0.5 color rgbt <0,0,0,0.8>]
			//[0.8 color rgbt <0,0,0,0>]
			[1.0 color rgbt <0.5,0,0,0>]
		}
		turbulence 2 lambda 1.9 octaves 9 omega 0.66
		scale <1200,100,300>
		translate <clock01*20,clock01/10,clock01*5>
		rotate <0,60,0>
		
	}
	finish {
		ambient 0.5 diffuse 0
	}
}

#declare Dimmer=.5; 

light_source {
	<-20,10,-10>
	color rgb 1*Dimmer
	shadowless
}

light_source {
	<20,10,-10>
	color rgb 1*Dimmer
	shadowless
}

light_source {
	<-20,-10,-10>
	color rgb 1*Dimmer
	shadowless
}

light_source {
	<20,-10,-10>
	color rgb 1*Dimmer
	shadowless
}



/*#declare bat_move1= spline{
                        cubic_spline
    
                        -.2, <-2.0, 51.8, 1.6>
                        0, <-2, 50.5, 1.5>,
                        0.1, <-1.1,  51, 1.7>,
                        0.25, <-1.1,  51.3, 1.7>,
                        0.3, < 1.2,  51.7, 2.0>,
                        0.4, <-1.1, 51, 1.5>,
                        0.55, <-0.3, 50, 1.5>,
                        0.6, <1.3, 50.1, 2.1>,
                        0.7, <0, 50.3, 1.9>,
                        0.85, <1.2, 51.5, 1.5>,
                        0.9, <1.3, 51, 1.8>,
                        1.0, <1.5, 51.3, 1.5>,
                        1.1, <2, 51.8, 1.6>,
                        }
                        
#declare bat_move2= spline{
                        cubic_spline
    
                        -.2, <2.0, 51.8, 1.6>
                        0, <1.5, 51.3, 1.5>,
                        0.1, <1.3,  51, 1.7>,
                        0.25, <1.2,  51.5, 1.7>,
                        0.3, < 0,  50.3, 2.0>,
                        0.4, <1.3, 50.1, 1.5>,
                        0.55, <-0.3, 50, 1.5>,
                        0.6, <-1.1, 51, 2.1>,
                        0.7, <1.2, 50.7, 1.9>,
                        0.85, <-1.1, 51.3, 1.5>,
                        0.9, <-1.1, 51, 1.8>,
                        1.0, <-2, 50.5, 1.5>,
                        1.1, <-2, 51.8, 1.6>,
                        }                        

#declare bat_color=rgb 0.5;
#declare bat_time=clock01;
#include "scenes/room/bat.inc"

object {bat scale 0.01  Spline_Trans(bat_move1,(bat_time/6), y, .01, .05) pigment{rgb bat_color}}
object {bat scale 0.01  Spline_Trans(bat_move2,(bat_time/6), y, .01, .05) pigment{rgb bat_color}}*/

/*#declare tt=0;
#while (tt<1)
sphere{<0,0,0>,.03 Spline_Trans(bat_move1,tt, y, .1, 0) translate x*0 pigment {Red}}
//sphere{<0,0,0>,.03 Spline_Trans(bat_move2,tt, y, .1, 0) translate x*0 pigment {Blue}}
#declare tt=tt+.005;
#end*/
