/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot06.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : a shot in the narrow alleyway
 Date        : 20031108
 Created by  : Sascha Ledinsky
 Modified by : Dennis Borree 20031122 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031214 (trulayne - at - new - dot - rr - dot - com) 
 Copyright   : Released into the Public Domain
 
===========================================================
*/

//
//   14 seconds
//

/*
#include "include/colors.inc"
#include "include/textures.inc"
#include "include/shapes.inc"
#include "include/metals.inc"
#include "include/glass.inc"
#include "include/woods.inc"
*/

#declare clock_shelfs=clock06;
#declare time = clock06;

#include "scenes/flame/flame.inc"
#include "scenes/shelfs/shelfs.inc"
#include "scenes/shelfs/shelf_fill.inc"
#include "scenes/shelfs/hourglass_holder.inc"
#include "scenes/shelfs/torch.inc"


/*
camera {
	right <16/9,0,0>
	up <0,1,0>
	#local time_x=0.60*time;
	#local time_z = 0;
	#if (time>3)
	  #local time_x=1.8;
	  #local time_z = 0.1*(time-3.0);
	#end
	location <(2.5-time_x),4.8,(-0.55+time_z)>   // modified camera usage
	look_at <-.9,4.8,(-0.55+time_z)>
	#local time_a = 35*time/3;
	#if (time>3)
	  #local time_a = 35;
	#end
	angle 65-time_a
}
*/

#local tt = (1 - (1 - time/9)*(1-time/9));
#local cam_angle = 50 - 20 * tt;
#if (cam_angle < 30)
	#local cam_angle = 30;
#end
#local cam_pos_y = 4.4 + 0.5 * tt;
#local cam_pos_z = -0.55 - 2 + 2.5 * sqrt(tt);
#local cam_pos_x = 2.5 - 1.8 * sqrt(tt);

#declare camera_location = <cam_pos_x,cam_pos_y,cam_pos_z>;

camera {
	right <16/9,0,0>
	up <0,1,0>
	//location 0
	//look_at -x
	location camera_location
	look_at <-1,4.8,0>
	angle cam_angle
}

#declare Dimmer= 0.7;
/*
#if(true)
	light_source {
		<2,20,0>//<2,20,0>
		color rgb 0.5
		shadowless
		parallel
	}
#end
*/
///// added spotlight

#if(true)
	light_source {
		<1,5,-.15>        
		color rgb <1.8,1.7,1.6>*0.3//0.5
		spotlight
		#local r1 = 51-11*time;
		#if (time>3)
		#local r1 = 18-2.50*(time-3.0); //2.65
		#end
		radius r1 falloff r1*2 
		point_at <-.9,4.8,0.05>
		fade_power 2
		fade_distance 3  
	}
#end

#if(true)
	light_source {
		<5,10,-2>
		color rgb <0.6,0.6,1.5>*clock06/9
		shadowless
		fade_power 2
		fade_distance 4
		
	}
#end
	
//////////// Fog //////////////////////
/*
  fog {
    distance 5
    color rgb 0 
  }
*/
/////  Fill Shelves  //////////////////////////////////////////////

#declare r= seed(0);

#declare row_finish=12;    
#declare column_finish=22; 
#declare row_start=7;     
#declare column_start=6;

#switch (clock06)
#range (0,1.33)
#declare pre_row1=7;
#declare pre_row2=12;
#declare pre_column1=6;
#declare pre_column2=22;
#break
#range (1.33,4.63)
#declare pre_row1=8;
#declare pre_row2=10;
#declare pre_column1=8;
#declare pre_column2=16;
#break
#range (4.63, 9)
#declare pre_row1=9;
#declare pre_row2=9;
#declare pre_column1=9;
#declare pre_column2=13;
#break
#end
 
#declare shelving=1;
#declare name_number=int(20*rand(r));

shelf_fill(row_start,row_finish,column_start,column_finish,shelving)

/*
* torch and flame
*/

#local flame_0_pos = <-0.4,4.5,-0.7-0.3*1>;  

object{torch scale 0.66 translate flame_0_pos}

//flame(camera_location, flame_position, flame_height, time, hotair)
/*
* flames
*/
#if(true)
	flame(camera_location, flame_0_pos, 0.7 * 0.66, clock06 + 500, true)
#end
