/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot07.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : camera scans over some hourglasses and stops
 Date        : 20031109
 Created by  : Sascha Ledinsky
 Modified by : Dennis Borree 20031122 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#include "include/colors.inc"
#include "include/woods.inc"
#include "scenes/hourglass/hourglass.inc"
#include "scenes/shelfs/hourglass_holder.inc"

#declare grain_size = 0.001;
#declare time = clock07;
#declare deltaT = 1/framerate;


background {
	color rgb <0.8,0.8,1>
}

#declare r = seed(0);



#macro bar()
	box {
		<-0.15,-0.01,-1.00>,<0.15,0.01,1.00>
		texture { T_Wood35 scale 0.5 translate <rand(r)*0.05,rand(r)*0.05,rand(r)*0.5> }
	}
#end
		

object { bar() rotate <0,90,0> translate <-0.30,0,-0.01> }
object { bar() rotate <0,90,0> translate <-0.30,0.60,-0.01> }
object { bar() rotate <90,90,0> translate <-1.05,0,0>}
object { bar() rotate <90,90,0> translate <-0.75,0,0>}
object { bar() rotate <90,90,0> translate <-0.45,0,0>}
object { bar() rotate <90,90,0> translate <-0.15,0,0>}
object { bar() rotate <90,90,0> translate < 0.15,0,0>}
object { bar() rotate <90,90,0> translate < 0.45,0,0>}
object { bar() rotate <90,0,0> translate <-1.20,0,0.15> }
object { bar() rotate <90,0,0> translate <-0.90,0,0.15> }
object { bar() rotate <90,0,0> translate <-0.60,0,0.15> }
object { bar() rotate <90,0,0> translate <-0.30,0,0.15> }
object { bar() rotate <90,0,0> translate < 0,0,0.15> }
object { bar() rotate <90,0,0> translate < 0.30,0,0.15> }
object { bar() rotate <90,0,0> translate < 0.60,0,0.15> }



/*
* fill light
*/
light_source {
	<100,10,-200>
	color rgb <0.1,0.2,0.6>
	parallel
	shadowless
}

light_source {
	<0,-100,-200>
	color rgb <0.3,0.3,0.6>
	parallel
	shadowless
}


/*
* back light
*/
light_source {
	<0,200,200>
	color rgb 0.5
	shadowless
	parallel
}



/*
#if (clock < 2) 
	#declare time = clock / 2;
	#declare delta_t = clock_delta / 2;
	#declare ang = 15;
	#declare grain_size	= 0.09;
#end
#if (clock >=2)
	#declare time = 1 + (clock - 2) / 4;
	#declare delta_t = clock_delta / 4;
	#declare ang = 5;
	#declare grain_size	= 0.03;
#end
*/

//#include "sand.inc"

camera {
	location <0,0.196,-1.70> /// changed location to look at
	look_at <0,0.196,0>      /// new center of hourglass
	up <0,1,0>
	right <16/9,0,0>
	angle 30
	#local cl = (6-clock07)/6;
	translate <-0.60*cl*cl,0,0>
	//translate <-1,0,0>
}

/*
* key light
*/
light_source {
	<-0.35,0.45,-2.00>        /// changed location to give better light spot on back wall with new hourglass center
	color rgb <1.8,1.7,1.6>
	spotlight
	#local r1 = (7.2 - time) * 2;
	radius r1 falloff r1*2 
	point_at <0,0.196,0>  /// changed look at for new hourglass center
}

#declare r = seed(0);
#declare sl = pow((7.2-time),1/3)*0.01;
#if (time > 7.2)
	#declare sh = 0;
#end#





/*
* the ONE clock
*/
#declare hourglass_texture=T_Wood8;
 union{object{
	#local half_height = 0.16;
	#local glass_radius = 0.4*half_height;//.08
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = sl;
	#local sand_level_2 = half_height*0.80-sand_level_1-.05;//0.05;
	#local time_end = 7.2;
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
        translate <0,half_height + glass_thickness+0.035,0>
        }

#declare hourglass_base_style = 1;
#declare hourglass_rods_style = 1;

        object {hourglass_holder() rotate y*30  translate <0,0.01,0> }
        }

/*
* the third left clock
*/ 
#declare hourglass_texture=T_Wood23;
union{object {
	#local half_height = 0.12;
	#local glass_radius = 0.4*half_height;//.08
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = 0.07;
	#local sand_level_2 = half_height*0.80-sand_level_1;//0.07;
	#local time_end = 1000;
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <-0.90,half_height + glass_thickness+0.035,0>
        }

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare hourglass_base_style = 3;
#declare hourglass_rods_style = 1;

        object {hourglass_holder() rotate y*(30+rand(r)*5)  translate <-0.90,0.01,0> }
        }

/*
* the second left clock
*/
#declare hourglass_texture=T_Wood18;
union{object {
	#local half_height = 0.17;
	#local glass_radius = 0.4*half_height;//.08
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = 0.06;
	#local sand_level_2 = half_height*0.80-sand_level_1;//0.10;
	#local time_end = 1000;
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <-0.60,half_height + glass_thickness+0.035,0>
        }

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare hourglass_base_style = 2;
#declare hourglass_rods_style = 1;

        object {hourglass_holder() rotate y*(-30+rand(r)*5)  translate <-0.60,0.01,0> }
        }

/*
* the left clock
*/
#declare hourglass_texture=T_Wood3;
union{ object{
	#local half_height = 0.15;
	#local glass_radius = 0.4*half_height;//.08
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = 0.04;
	#local sand_level_2 = half_height*0.80-sand_level_1;//0.08;
	#local time_end = 1000;
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <-0.30,half_height + glass_thickness+0.035,0>
        }

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare hourglass_base_style = 3;
#declare hourglass_rods_style = 2;

        object {hourglass_holder() rotate y*(30+rand(r)*5)  translate <-0.30,0.01,0> }
        }

/*
* the right clock
*/
#declare hourglass_texture=T_Wood7;
union{object {
	#local half_height = 0.145;
	#local glass_radius = 0.4*half_height;//.08
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	#local sand_level_1 = 0.10;
	#local sand_level_2 = half_height*0.80-sand_level_1;//0.05;
	#local time_end = 1000;
	#local level_of_detail = 3;
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
	translate <+0.30,half_height + glass_thickness+0.035,0>
        }

#declare base_height=half_height;
#declare base_width=glass_radius;
#declare hourglass_base_style = 2;
#declare hourglass_rods_style = 3;

        object {hourglass_holder() rotate y*(-30+rand(r)*5)  translate <0.30,0.01,0> }
        }

