/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot09.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : zoom a bit closer, slow motion 0.1
 Date        : 20031109
 Created by  : Sascha Ledinsky
 Modified by : Dennis Borree 20031122 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031129 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031206 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031214 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#include "include/transforms.inc"
#include "include/colors.inc"
#include "include/woods.inc"
#include "scenes/hourglass/hourglass.inc"
#include "scenes/shelfs/hourglass_holder.inc"
#include "scenes/room/skeleton_hand_presets.inc"
#include "scenes/room/skeleton_hand.inc"
#include "scenes/shelfs/web.inc"

#declare grain_size = 0.00025;
#declare time = 9.9 + clock09 * 0.1;
#declare deltaT = 1/framerate * 0.1;
#declare nameplate_font="fonts/riverave.ttf";

background {
	color rgb <0.8,0.8,1>
}

#declare r = seed(0);

#macro bar()
	box {
		<-0.15,-0.01,-1.00>,<0.15,0.01,1.00>
		texture { T_Wood35 scale 0.5 translate <rand(r)*0.05,rand(r)*0.05,rand(r)*0.5> }
	}
#end
		

object { bar() rotate <0,90,0> translate <-0.30,0,-0.01> }
object { bar() rotate <0,90,0> translate <-0.30,0.60,-0.01> }
object { bar() rotate <90,90,0> translate <-1.05,0,0>}
object { bar() rotate <90,90,0> translate <-0.75,0,0>}
object { bar() rotate <90,90,0> translate <-0.45,0,0>}
object { bar() rotate <90,90,0> translate <-0.15,0,0>}
object { bar() rotate <90,90,0> translate < 0.15,0,0>}
object { bar() rotate <90,90,0> translate < 0.45,0,0>}
object { bar() rotate <90,0,0> translate <-1.20,0,0.15> }
object { bar() rotate <90,0,0> translate <-0.90,0,0.15> }
object { bar() rotate <90,0,0> translate <-0.60,0,0.15> }
object { bar() rotate <90,0,0> translate <-0.30,0,0.15> }
object { bar() rotate <90,0,0> translate < 0,0,0.15> }
object { bar() rotate <90,0,0> translate < 0.30,0,0.15> }
object { bar() rotate <90,0,0> translate < 0.60,0,0.15> }

/////// reflector screen so name plate reflrcts wood color not background ///////

object { bar() rotate <90,90,0> translate < 0.45,0,-0.3>}
object { bar() rotate <90,90,0> translate < 0.45,0,-0.6>}
object { bar() rotate <90,0,0> translate <-1.20,0,-2.15> }
object { bar() rotate <90,0,0> translate <-0.90,0,-2.15> }
object { bar() rotate <90,0,0> translate <-0.60,0,-2.15> }
object { bar() rotate <90,0,0> translate <-0.30,0,-2.15> }
object { bar() rotate <90,0,0> translate < 0,0,-2.15> }
object { bar() rotate <90,0,0> translate < 0.30,0,-2.15> }
object { bar() rotate <90,0,0> translate < 0.60,0,-2.15> }
object { bar() rotate <90,0,0> translate < 0.90,0,-2.15> }
object { bar() rotate <90,0,0> translate < 0.60,0,-1.15> }
object { bar() rotate <90,0,0> translate < 0.90,0,-1.15> }
object { bar() rotate <90,0,0> translate < 1.20,0,-1.15> }
object { bar() rotate <90,0,0> translate < 1.50,0,-1.15> }
object { bar() rotate <90,0,0> translate < 1.50,0,-0.15> }
object { bar() rotate <90,0,0> translate < 1.80,0,-0.15> }
object { bar() rotate <90,0,0> translate < 2.10,0,-0.15> }

/////////////////////////////////////////////////////////////////////////////////////

#declare Dimmer= 0.7;

/*
* fill light
*/
light_source {
	<100, 10, -200>
	color rgb <0.1, 0.2, 0.6>*Dimmer
	parallel
	shadowless
}

light_source {
	<0, -100, -200>
	color rgb <0.3, 0.3, 0.6>*Dimmer
	parallel
	shadowless
}

/***************************lighting for hand**********************/
#switch (clock09)
#range (5,8)

light_source {
	<0.5, 2, -6>
	color rgb <1, 0.7, 0.4>*Dimmer*Dimmer
	fade_power 2
	fade_distance 2*(clock09-5)/3
	shadowless
	}
#break
#range (8,11)

light_source {
	<0.5, 2, -6>
	color rgb <1, 0.7, 0.4>*Dimmer
	fade_power 2
	fade_distance 2
	shadowless
	}
#break
#end

/*******************************************************************/

/*
* back light
*/
light_source {
	<0,200,200>
	color rgb 0.5*Dimmer
	shadowless
	parallel
}

//////////// Fog //////////////////////

  /*fog {
    distance 1.5
    color rgbft<1, 1, 1, 0, .8>
    turbulence .9
    turb_depth .9
  }*/

/*
#if (clock < 2) 
	#declare time = clock / 2;
	#declare delta_t = clock_delta / 2;
	#declare ang = 15;
	#declare grain_size	= 0.09;
#end
#if (clock >=2)
	#declare time = 1 + (clock - 2) / 4;
	#declare delta_t = clock_delta / 4;
	#declare ang = 5;
	#declare grain_size	= 0.03;
#end
*/

//#include "sand.inc"

camera {
	location <0, 0.196, -1.70>    /// changed location to look at <0,0.196,-1.70>
	look_at <0, 0.196, 0>         /// new center of hourglass                
	up <0, 1, 0>
	right <16/9, 0, 0>
	
	translate <0.01 * 4/3,-0.01,0>
	
	#switch (clock09)
	#range (0,5)
	
	  angle 5
	
	#break
	#range(5,7)
	
	  angle (5+10*(clock09-5)/2)
	
	#break
	#range (7,11)
	
	  angle 15
	
	#break
	#end
	//#local cl = (6-clock07)/6;
	//translate <-0.60*cl*cl,0,0>
	//translate <-1,0,0>
       }

/*
* key light
*/
light_source {
	<-0.35, 0.45, -2.00>          /// changed location to give better light spot on back wall with new hourglass center
	color rgb <1.8, 1.7, 1.6>*0.6
	spotlight
	#local r1 = (10.3 - time) * 2;
	#if (r1 < 0)
		#local r1 = 0;
	#end
	radius r1 falloff r1*2 
	point_at <0, 0.196, 0>  /// changed look at for new hourglass center
}

#declare r = seed(0);
#declare sl = pow((10.2-time),1/3)*0.01;
#if (time > 10.2)
	#declare sl = 0;
#end#


/*************spline for moving hourglass*******************/ 
	
#declare hg_move= spline{
                        cubic_spline
    
                        -1, <-0.1, -0.01, 0.01>
                        0, <0, 0, 0>,
                        0.67, <0,  0.08, -0.3>,
                        1.5, < 0.1,  -0.3, -0.4>,
                        2.5, < 0.11,  -0.4, -0.41>,
                        }
                        
/************************************************************/

//#declare preview = false;   
/*
* the ONE clock
*/
#declare hourglass_texture=T_Wood8;
 union{
 object{
	#local half_height = 0.16;
	#local glass_radius = 0.4*half_height;
	#local cone_height = 0.4*half_height;
	#local round = half_height/20;
	#local hole_radius = 0.003;
	#local glass_thickness = 0.001;
	                
	#if (clock09>5)
	  #local sl = 0;
	#end

	#local sand_level_1 = sl;
	#local sand_level_2 = half_height*0.5;
	#local time_end = 10.2;
	#local level_of_detail = 3;     
	hourglass(half_height,glass_radius,cone_height,round,hole_radius,glass_thickness,sand_level_1,sand_level_2,preview,grain_size,time,deltaT,time_end,level_of_detail)
        translate <0,half_height + glass_thickness+0.035,0>
        }

        #declare hourglass_base_style = 1;
        #declare hourglass_rods_style = 1;
        #declare name_number=100;


        object {hourglass_holder() rotate y*120  translate <0, 0.01, 0> }
        
/*********************************************moving hand****************************/

        #switch (clock09)
        #range (5.5,7)
        #declare P_Finger2=10+20*(clock09-5.5)/1.5;
        #declare R_Finger2=25+30*(clock09-5.5)/1.5;
        #declare M_Finger2=15+35*(clock09-5.5)/1.5;
        #declare I_Finger2=15+22*(clock09-5.5)/1.5;
        #declare Thumb3=40*(clock09-5.5)/1.5;
        #break
        #end
        
        #switch (clock09)
        #range (5,6)
        
        #declare wrist_angle_rot=30*(clock09-5);
        #declare wrist_angle_twist=20*(clock09-5);
        #declare wrist_angle_pivot=0;
        #declare P_Finger2=10*(clock09-5);
        #declare R_Finger2=25*(clock09-5);
        #declare M_Finger2=15*(clock09-5);
        #declare I_Finger2=15*(clock09-5);

        
        object {Skeleton_hand()  rotate <-60, 160, -80> scale 0.35 translate <(-0.25+0.185*(clock09-5)), half_height-0.02, (-0.85+0.69*(clock09-5))>}
        
        #break
        #end
        
        #switch (clock09)
        #range (6,7)
        
        #declare wrist_angle_rot=30;
        #declare wrist_angle_twist=20;
        #declare wrist_angle_pivot=0;
        #declare P_Finger1=10+16*(clock09-6);
        //#declare P_Finger2=10+20*(clock09-6);
        #declare P_Finger3=10;
        #declare R_Finger1=10+10*(clock09-6);
        //#declare R_Finger2=25+30*(clock09-6);
        #declare R_Finger3=10+40*(clock09-6);
        #declare M_Finger1=10+5*(clock09-6);
        //#declare M_Finger2=15+35*(clock09-6);
        #declare M_Finger3=10+30*(clock09-6);
        #declare I_Finger1=10+5*(clock09-6);
        //#declare I_Finger2=15+22*(clock09-6);
        #declare I_Finger3=10+40*(clock09-6);
        #declare Thumb1=40+10*(clock09-6);
        #declare Thumb1a=70-20*(clock09-6);
        #declare Thumb2=0+7*(clock09-6);
        //#declare Thumb3=40*(clock09-6);

        

        
        object {Skeleton_hand()  rotate<-60, 160, -80> scale 0.35 translate <-0.065, half_height-0.02, -0.16>}
        
        
        #break
        #end
                
        #switch (clock09)
        #range (7,11)
        
        #declare wrist_angle_rot=30;
        #declare wrist_angle_twist=20;
        #declare wrist_angle_pivot=0;
        #declare P_Finger1=26;
        #declare P_Finger2=30;
        #declare P_Finger3=10;
        #declare R_Finger1=20;
        #declare R_Finger2=55;
        #declare R_Finger3=50;
        #declare M_Finger1=15;
        #declare M_Finger2=50;
        #declare M_Finger3=40;
        #declare I_Finger1=15;
        #declare I_Finger2=37;
        #declare I_Finger3=50;
        #declare Thumb1=50;
        #declare Thumb1a=50;
        #declare Thumb2=7;
        #declare Thumb3=40;
        object {Skeleton_hand()  rotate <-60, 160, -80> scale 0.35 translate <-0.065, half_height-0.02, -0.16>}
        
        #break
        #end  
        
/**************************************************************************************************/

/***********************moving hourglass & hand****************************************************/

        #switch (clock09)
        #range (7,11)
        
         Spline_Trans(hg_move,( (clock09-7)/1), y, 0, 0.0)

        #break
        #end  
/***************************************************************************************************/
        
        }
        
#declare web_text=texture{pigment{rgbt<1.5, 1.5, 1.0, 0.4>}}
#declare web_spokes=7;
#declare web_x=0.3;
#declare web_y=0.5;
#declare web_spiral=0.0008;
#declare web_thickness=0.0003;
#declare web_rot=0; 
#declare web_trans_y=0; 
#declare web_trans_z=-0.28; 
#declare webx_locate=-0.705-0.25+0.78+.3;        
        
        object{web(web_spokes,web_x,web_y,web_thickness,web_spiral,123,web_text)  
           translate <web_trans_z-3.41+3.55, web_trans_y+ 0.59-0.10, webx_locate>}        
        
        

        

        
 

        




