/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot10.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Closing Shot
 Date        : 20031108
 Created by  : Sascha Ledinsky
 Modified by : Dennis Borree 20031225 (trulayne - at - new - dot - rr - dot - com) 
 Copyright   : Released into the Public Domain
 
===========================================================
*/

//
//   6 seconds
//

/*
#include "include/colors.inc"
#include "include/textures.inc"
#include "include/shapes.inc"
#include "include/metals.inc"
#include "include/glass.inc"
#include "include/woods.inc"
*/

#declare clock_room=clock10 + 1000;
#declare camera_location = <0,0.4,-5>;

#local c = (clock10 + 1)/2;
#declare door_open = 60 - 60 * c * c;

#if (door_open < 0) #declare door_open = 0; #end

#include "include/colors.inc"
#include "include/woods.inc"
#include "scenes/room/room.inc"
#include "scenes/room/skeleton_hand_presets.inc"
#include "scenes/room/skeleton_hand.inc"
#include "scenes/room/reaper.inc"
#include "scenes/room/sythe.inc"
#include "include/transforms.inc"    

camera {
	right <16/9,0,0>
	up <0,1,0>
	location camera_location
	look_at <0,0.8,0> 
	angle 50
}

/*#include "scenes/splines/splines2D.inc"

#local death_outline_1 = array[12 * 5] {
	-1.0,	 6.0,	0.0,	0.0,	 0.0,
	 0.3,	 6.1,	1.0,	1.0,	 0.0,
	 1.3,	 5.0,	1.0,	1.0,	 0.0,
	 1.2,	 3.0,	1.0,	1.0,	 0.0,
	 1.3,	 2.5,	1.0,	1.0,	 0.0,
	 2.6,	 1.2,	1.0,	1.0,	 0.0,
	 4.0,	-4.5,	0.0,	0.0,	 0.0,
	-2.5,	-4.5,	0.0,	0.0,	 0.0,
	-2.0,	 0.9,	1.0,	1.0,	 0.0,
	-0.8,	 2.0,	1.0,	1.0,	 0.0,
	-0.8,	 2.7,	1.0,	1.0,	 0.0,
	-1.3,	 4.0,	1.0,	1.0,	 0.0,
}

#local death_outline_2 = array[12 * 5] {
	-1.0,	 6.1,	0.0,	0.0,	 0.0,
	 0.3,	 6.1,	1.0,	1.0,	 0.0,
	 1.5,	 5.0,	1.0,	1.0,	 0.0,
	 1.2,	 3.0,	1.0,	1.0,	 0.0,
	 1.4,	 2.5,	1.0,	1.0,	 0.0,
	 2.8,	 1.2,	1.0,	1.0,	 0.0,
	 5.0,	-4.5,	0.0,	0.0,	 0.0,
	-2.5,	-4.5,	0.0,	0.0,	 0.0,
	-2.0,	 0.9,	1.0,	1.0,	 0.0,
	-0.8,	 2.0,	1.0,	1.0,	 0.0,
	-0.8,	 2.7,	1.0,	1.0,	 0.0,
	-1.3,	 4.0,	1.0,	1.0,	 0.0,
}

#local scythe_outline_1 = array[13 * 5] {
	-0.3,	 1.6,	0.0,	0.0,	 0.0,
	 2.7,	 4.2,	0.0,	0.0,	 0.0,
	 2.3,	 4.3,	0.0,	0.0,	 0.0,
	 //1.2,	 3.0,	0.0,	0.0,	 0.0,
	 3.2,	 5.0,	0.0,	0.0,	 0.0,
	 3.3,	 4.6,	0.0,	0.0,	 0.0,
	 3.6,	 4.9,	0.0,	0.0,	 0.0,
	 4.0,	 4.5,	0.0,	0.0,	 0.0,
	 3.6,	 4.3,	0.0,	0.0,	 15.0,
	 4.4,	 3.0,	1.0,	1.0,	 0.0,
	 4.5,	 1.0,	0.0,	0.0,	 0.0,
	 4.0,	 2.8,	1.0,	1.0,	 0.0,
	 3.2,	 3.9,	0.0,	0.0,	 0.0,
	 0.0,	 1.2,	0.0,	0.0,	 0.0,
}

#local cycle = clock_room * 2 * pi;

union {
	object {
		drawPrism(scythe_outline_1,0,0.01)
		translate <0,-1.3,0>
		rotate <0,0,sin(cycle) * 10>
		translate <0.5,0.5,0>
	}
	drawPrism(interpolateShape(death_outline_1,death_outline_2,sin(cycle / 2)),0,1)
	translate <0,cos(cycle) * 0.2,0>
	translate <8.2 - clock_room * 4.5,0,0>
	scale 0.1
	translate <-1.1,1.1,1>
}*/ 



//// bat  //////////////////////////////////////

#declare bat_move3= spline{
                        cubic_spline
    
                       -0.2,  <-2.0, 1.4, 0.9>
                        0.0,  <-1.9, 1.5, 1>,
                        0.1,  <-1.7, 1.3, 1.3>,
                        0.25, <-1.9, 1.4, 1.2>,
                        0.3,  <-1.7, 1.6, 1.3>,
                        0.4,  <-1.6, 1.4, 1.5>,
                        0.55, <-1.4, 1.6, 2.0>,
                        0.6,  <-1.6, 1.7, 2.3>,
                        0.7,  <-1.5, 1.8, 2.9>,
                        0.85, <-1.7, 1.7, 3.1>,
                        0.9,  <-1.5, 1.9, 3.6>,
                        1.0,  <-1.4, 2.0, 4.0>,
                        1.1,  <-1.3, 2.1, 3.1>,
                        }

#declare bat_color=rgb 1;
#declare bat_time=clock10;
#include "scenes/room/bat.inc"

object {bat scale 0.01 Spline_Trans(bat_move3,(bat_time/10), y, 0.01, 0.05) pigment{rgb bat_color}}

///////////////////////////////////////////////////



// material definitions for reaper

#declare Kolor=<.5,.7,.7>;

#declare robe_norm = normal {
    bump_map {
      jpeg "image/cloth_robe2.jpg"
       
      bump_size  0.01
    }
     no_bump_scale
  rotate 45}

  
#declare reaper_finish= finish{reflection .3*Dimmer diffuse 0.4*Dimmer ambient .1*Dimmer}  

#declare reaper_texture = texture{pigment { color rgb Kolor } 
                                  finish{reaper_finish}
                                  normal{robe_norm}
                                  }
                                  
                                  
/////////////////  Hand & Reaper settings

        #declare wrist_angle_rot=0;
        #declare wrist_angle_twist=0;
        #declare wrist_angle_pivot=0;
        #declare P_Finger1=30;
        #declare P_Finger2=10;
        #declare P_Finger3=20;
        #declare R_Finger1=30;
        #declare R_Finger2=10;
        #declare R_Finger3=20;
        #declare M_Finger1=30;
        #declare M_Finger2=10;
        #declare M_Finger3=20;
        #declare I_Finger1=30;
        #declare I_Finger2=10;
        #declare I_Finger3=20;
        #declare Thumb1=30;
        #declare Thumb1a=50;
        #declare Thumb2=5;
        #declare Thumb3=10;                                  
                                  
                                  
#declare LA_U_Rot=<-5*sind(clock10*180*1.5), 0, 0>;
#declare RA_U_Rot=<0, 0, 0>;

#if(LA_U_Rot.x>0)
#declare LA_L_Rot=<10*sind((clock10*180*1.5+180)+0), 0, 0>;
#else
#declare LA_L_Rot=<0, 0, 0>;
#end

#declare RA_L_Rot=<0, 0, 0>;

#local LA_U_joint=<0, 68, 0>;
#local LA_L_joint=<0, 58, 1>;
#local RA_U_joint=<0, 68, 0>;
#local RA_L_joint=<0, 58, 0>;

#local LA_L_joint_location=vrotate(LA_L_joint-LA_U_joint, LA_U_Rot);
#local RA_L_joint_location=vrotate(RA_L_joint-RA_U_joint, RA_U_Rot);                                  
                                  
/////// reaper figure ///////////                                   

#declare reaper_hood_etc = union{object {reaper_hood texture { reaper_texture }}
                                 object {reaper_eyes pigment {rgb<0, 0, 1>}finish{ambient 1}}
                                 object {reaper_head pigment {rgb<1, 1, 0.8>}}
                                 }                                 

#declare Reaper=merge{object { reaper_LL texture { reaper_texture } rotate x* (5*sind(clock10*180*1.5)) translate y*41 } 
                      object { reaper_RL texture { reaper_texture } rotate x* (-5*sind(clock10*180*1.5)) translate y*41 }                       
                      object { reaper_LA_U texture { reaper_texture }rotate LA_U_Rot  translate LA_U_joint } //LA_U
                union{
                      object { reaper_LA_L texture { reaper_texture }}
                      object {Skeleton_hand() rotate <0,0,165> scale <-10,10,10> rotate <-30,90,-30>translate<15,-21,-3>}
                      rotate (LA_L_Rot+LA_U_Rot)  translate LA_L_joint_location translate LA_U_joint } //LA_L
                      object { reaper_RA_U texture { reaper_texture }rotate RA_U_Rot  translate RA_U_joint } //RA_U
                union{
                      object { reaper_RA_L texture { reaper_texture }}
                      object {Skeleton_hand() rotate <0,0,165> scale <10,10,10> rotate <0,-90,0>translate<-12,-21,-3>}
                      rotate (RA_L_Rot+RA_U_Rot)  translate RA_L_joint_location translate RA_U_joint } //RA_L                          
                      object { reaper_robe texture { reaper_texture } translate y*72 } 
                      object { reaper_hood_etc translate y*72 translate z*-2}

                      scale 0.02 rotate y*90 
                      } 


#declare Reaper_plus=union{object{Reaper}
                           object {sythe  translate y*-0.9 
                                          rotate z*(120-5*sin(clock10*pi*1.5)) //1.5
                                          translate y*0.9 
                                          scale .6 
                                          translate <-0.3, 0.8, 0.1>}  
                          }
                          
#local w=2;
#switch (clock10)
#range (0, 0.5)
#declare Reaper_loc= <0.4, 0, 0.6>;
#break
#range (0.5, 10)                          
#declare Reaper_loc=  <0.4-0.36*(clock10-0.5), -0.0125*sin((clock10-0.5)*pi*1.5), 0.6+0.4*(clock10-0.5)/w>;
#break
#end

object {Reaper_plus rotate y*(asin(1.11/w)*pi) translate Reaper_loc}




 


