/*

===========================================================

     ATTENTION!!!!



     This file is in the Public Domain.

     Provided by the Internet Movie Project (www.imp.org)

===========================================================



 File        : splines2D.inc

 Project     : IRTC Entry for "The end of..." round

 cvs module  : theendof

 POV Version : 3.5

 Description : some macros to create and morph 2d outlines

 Date        : 20031117

 Created by  : Sascha Ledinsky

 Edited by   :  

 Copyright   : Released into the Public Domain

 

===========================================================

*/



/*

* outline array: 5 elements per control-point:

*

* x_pos, y_pos, in_magnitude, out_magnitude, rotation (clockwise in degrees),

* ...

* ...

*

*/

#macro getBezierSplines(outline)

	#local iControlPoints = dimension_size(outline,1) / 5;

	//#debug concat("iControlPoints = ",str(iControlPoints,1,1),"\n")

	#local iIndex = 0;

	#local bezier = array[iControlPoints * 4];

	#while (iIndex < iControlPoints)

		//#debug concat("iIndex = ",str(iIndex,1,1),"\n")

		#local iPrev = iIndex - 1;

		#if (iPrev < 0) #local iPrev = iControlPoints - 1; #end

		#local iNext = iIndex + 1;

		#if (iNext >= iControlPoints) #local iNext = 0; #end

		#local vCp = <outline[iIndex * 5],outline[iIndex * 5 + 1]>;

		#local fInMagnitude = outline[iIndex * 5 + 2];

		#local fOutMagnitude = outline[iIndex * 5 + 3];

		#local fAngle = outline[iIndex * 5 + 4];

		#local vCpPrev = <outline[iPrev * 5],outline[iPrev * 5 + 1]>;

		#local vCpNext = <outline[iNext * 5],outline[iNext * 5 + 1]>;

		#local vTangent = vnormalize(vCpNext - vCpPrev);

		#local vTangent = vrotate(vTangent,<0,0,fAngle>);

		#local fInLength = vlength(vCp - vCpPrev);

		#local fOutLength = vlength(vCpNext - vCp);

		#local vCpIn = vCp - vTangent * fInLength * fInMagnitude / 3;

		#local vCpOut = vCp + vTangent * fOutLength * fOutMagnitude / 3;

		#local bezierA = iIndex * 4;

		#local bezierB = bezierA + 1;

		#local bezierC = bezierA - 2;

		#local bezierD = bezierA - 1;

		#if (bezierC < 0) #local bezierC = bezierC + iControlPoints * 4; #end

		#if (bezierD < 0) #local bezierD = bezierD + iControlPoints * 4; #end

		#local bezier[bezierA] = vCp;

		#local bezier[bezierB] = <vCpOut.x,vCpOut.y>;

		#local bezier[bezierC] = <vCpIn.x,vCpIn.y>;

		#local bezier[bezierD] = vCp;

		//#debug concat("bezier = ",str(bezierA,1,1)," ",str(bezierB,1,1)," ",str(bezierC,1,1)," ",str(bezierD,1,1),"\n")

		#local iIndex = iIndex + 1;

	#end

	bezier

#end



#macro interpolateShape(outlineA,outlineB,fAmount)

	#if (dimension_size(outlineA,1) != dimension_size(outlineB,1))

		#error "Error in interpolateShape: array size not equal!\n"

	#end

	#local index = 0;

	#local outline = array[dimension_size(outlineA,1)];

	#while (index < dimension_size(outlineA,1))

		#local outline[index] = outlineA[index] * (1 - fAmount) + outlineB[index] * fAmount;

		#local index = index + 1;

	#end

	outline

		

#end



#macro drawPrism(outline,height0,height1)

	prism {

		#local bezier = getBezierSplines(outline)

		bezier_spline height0,height1,dimension_size(bezier,1)

		#local index = 0;

		#while (index < dimension_size(bezier,1) - 1)

			//#debug concat(str(index,1,1),"\n")

			bezier[index],

			#local index = index + 1;

		#end

		bezier[index]

		rotate <-90,0,0>

	}

#end



#macro drawControlPoints(outline,dotSize,dotColor,lineColor)

	#local dotTexture = texture { pigment { color dotColor } finish { ambient 1 diffuse 0 } }

	#local lineTexture = texture { pigment { color lineColor } finish { ambient 1 diffuse 0 } }

	#local bezier = getBezierSplines(outline)

	#local index = 0;

	union {

		#while (index < dimension_size(bezier,1))

			#local A = <bezier[index].x,0,bezier[index].y>;

			#local B = <bezier[index + 1].x,0,bezier[index + 1].y>;

			#local C = <bezier[index + 2].x,0,bezier[index + 2].y>;

			#local D = <bezier[index + 3].x,0,bezier[index + 3].y>;

			sphere { A,dotSize * 2 texture {dotTexture} }

			sphere { B,dotSize texture {dotTexture} }

			sphere { C,dotSize texture {dotTexture} }

			sphere { D,dotSize * 2 texture {dotTexture} }

			#if (vlength(A - B) != 0) cylinder { A,B,dotSize / 2 texture {lineTexture} } #end

			#if (vlength(C - D) != 0) cylinder { C,D,dotSize / 2 texture {lineTexture} } #end

			#local index = index + 4;

		#end

		rotate <-90,0,0>

	}

#end



