// Persistence of Vision Ray Tracer Scene Description File
// File: units.inc
// Vers: 3.02
// Desc: Predefined units of measurement to use in creating scenes
// Date: December 3, 1997
// Auth: Sonya Roberts
// Modified: Bill Bohan
// Note: To use, multiply the number of units by the unit size, for example:
//                   <4*feet, 3*cm, 2.5*inch>
//                   <1*in, 1*dm, 1*km>
//
//       "mile" is contracted "mi" for this file.


// ==== BASE UNITS ====
// To change the scale of units, change only these two units.
//  All other units are calculated based on them.

#ifdef(Units_Inc_Temp)
// do nothing
#else
#declare Units_Inc_Temp = version;
#version 3.02

#ifdef(View_POV_Include_Stack)
#   debug "including units.inc\n"
#end

#declare ft=12/39.36
#declare cm=1/100


// ---- Metric Measurements ----
#declare um=(100*cm)*.000001
#declare micrometre=um
#declare micrometres=um
#declare micrometer=um
#declare micrometers=um

#declare mm=cm/10
#declare millimetre=mm
#declare millimetres=mm
#declare millimeter=mm
#declare millimeters=mm

#declare centimetre=cm
#declare centimetres=cm
#declare centimeter=cm
#declare centimeters=cm

#declare dm=cm*10
#declare decimetre=dm
#declare decimetres=dm
#declare decimeter=dm
#declare decimeters=dm

#declare m=100*cm
#declare metre=m
#declare metres=m
#declare meter=m
#declare meters=m

#declare dam=10*metres
#declare dk=dam
#declare dekametre=dam
#declare dekametres=dam
#declare dekameter=dam
#declare dekameters=dam

#declare hm=100*metres
#declare hectometre=hm
#declare hectometres=hm
#declare hectometer=hm
#declare hectometers=hm

#declare km=1000*metre
#declare kilometre=km
#declare kilometres=km
#declare kilometer=km
#declare kilometers=km


// ---- Imperial Measurements ----
#declare foot=ft
#declare feet=ft

#declare in=ft/12
#declare inch=in
#declare inches=in

#declare yd=3*ft
#declare yard=yd
#declare yards=yd

#declare mi=5280*ft
#declare mile=mi
#declare miles=mi


// ---- Miscellaneous Measurements ----
#declare furlong=220*yards
#declare furlongs=furlong

#declare hand=4*inches
#declare hands=hand

#declare rd=16.5*ft
#declare rod=rd
#declare rods=rd

#declare ell=45*inches
#declare ells=ell

//#declare au=93000000*miles
//#declare AstronomicalUnit=au
//#declare AstronomicalUnits=au
//#declare astronomicalunit=au
//#declare astronomicalunits=au
//#declare astronomical_unit=au
//#declare astronomical_units=au
//#declare astronomical-unit=au
//#declare astronomical-units=au

//#declare ly=9460000000000*km
//#declare lightyear=ly
//#declare lightyears=ly
//#declare light_year=ly
//#declare light_years=ly
//#declare light-year=ly
//#declare light-years=ly

#version Units_Inc_Temp;
#end
