#version 3.6 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "metals.inc"
#include "woods.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------

#declare pi2=2*pi/360;
#declare rclock=clock-1000;
#declare tclock=clock-1000;

#declare place = <0,4,-12>;

/*
light_source { place + <-2,2,0> color <1,1,1>*.2 shadowless}
light_source { place + <2,2,0> color <1,1,1>*.2 shadowless}
light_source{place color<1,1,1>*.6 shadowless}
*/

light_source{
<0,4,-12> //place +<0,0,0>
//<-1000,1000,-1000> 
color<1,1,1>}

camera {location place//-4 
//camera {location <-15,12,4>
right 16/9*x
look_at <0,4,0>
angle 79
sky <0,1,0>
up <0,1,0> // -1 flips left to right
}

#declare stage = union{

#declare screen = object{
mesh{
triangle {<-1,-1,0>,<-1,1,0>,<1,1,0>}
triangle {<-1,-1,0>,<1,1,0>,<1,-1,0>}
texture {pigment {image_map{
tga "oz3.tga" 
once map_type 0}}}
finish {ambient .6}
translate<-.5,-.5,0>
}//mesh

}//screen

object{screen finish {ambient .6} scale <16,9,1>*.335 
scale <9, 5 ,1> 
translate 6*y
translate 15*z }


//sphere{0,1 pigment{Green}}

//#declare stage = union{
box {<-30,-2,-1>,<30,20,1> scale <1,1,1> translate 10*y pigment{color <1,0,0>} finish{ambient .0} }//top

box {<-100,0,-1>,<100,-20,20> pigment{color <1,0,0>} finish{ambient .0} }//floor
box {<-100,0,-1>,<100,-20,20> translate <0,.01,.01> 
texture{
pigment{White}
finish{ambient .6 roughness .01
//irid{ .85 thickness .5 turbulence .5}
irid{ .85 thickness .5  turbulence .75+.25*sin(pi*2/24*rclock) }
}//finish

//normal{dents -1}

}//texture

}//floor

box {<-100,-2,-1>,<0,10,1> translate -10.5*x pigment{color <1,0,0>} finish{ambient .0} }//left

box {<0,-2,-1>,<100,10,1> translate 10.5*x pigment{color <1,0,0>} finish{ambient .0} }//right
}//stage

object{stage }

#if(clock>999)
#if(clock<1097)

#declare dancers = union{

#include "rob0.inc"
#include "robot.inc"

object{roba rotate 0*y translate z*12*tclock/96}

#include "rob4.inc"
#include "robot.inc"

object{roba rotate 0*y translate -4*x translate z*9*tclock/96 }
object{roba rotate 0*y translate 4*x translate z*9*tclock/96 }

#include "rob8.inc"
#include "robot.inc"

object{roba rotate 0*y translate -8*x translate z*6*tclock/96}
object{roba rotate 0*y translate 8*x translate z*6*tclock/96}

#include "rob12.inc"
#include "robot.inc"

object{roba rotate 0*y translate -12*x translate z*3*tclock/96}
object{roba rotate 0*y translate 12*x translate z*3*tclock/96}

}//

object {dancers scale .75 translate 2*z}

#end
#end

#if (clock>1096)
#if (clock<1121)

#declare dancers = union{

#include "rob0.inc"
#include "robot.inc"

object{roba rotate y*180*(clock-1096)/24 translate z*12}

#include "rob4.inc"
#include "robot.inc"

object{roba rotate y*(-90*(clock-1096)/24) translate -4*x translate z*9 }
object{roba rotate y*(90*(clock-1096)/24) translate 4*x translate z*9 }

#include "rob8.inc"
#include "robot.inc"

object{roba rotate y*(-90*(clock-1096)/24) translate -8*x translate z*6}
object{roba rotate y*(90*(clock-1096)/24) translate 8*x translate z*6}

#include "rob12.inc"
#include "robot.inc"

object{roba rotate y*(-90*(clock-1096)/24) translate -12*x translate z*3}
object{roba rotate y*(90*(clock-1096)/24) translate 12*x translate z*3}

}//

object {dancers scale .75 translate 2*z}

#end
#end

#if (clock>1120)
#if (clock<1127)
#declare dancers = union{

#include "rob0.inc"
#include "robot.inc"

object{roba rotate y*180 translate z*12 translate z*2*(clock-1120)/6 }

#include "rob4.inc"
#include "robot.inc"

object{roba rotate y*(-90) translate -4*x translate z*9 }
object{roba rotate y*(90) translate 4*x translate z*9 }

#include "rob8.inc"
#include "robot.inc"

object{roba rotate y*(-90) translate -8*x translate z*6}
object{roba rotate y*(90) translate 8*x translate z*6}

#include "rob12.inc"
#include "robot.inc"

object{roba rotate y*(-90) translate -12*x translate z*3}
object{roba rotate y*(90) translate 12*x translate z*3}

}//

object {dancers scale .75 translate 2*z}

#end
#end

#if (clock>1126)
#if (clock<1152)

#declare dancers = union{

#include "rob0.inc"
#include "robot.inc"

object{roba scale (1-.01*(clock-1127)) 
rotate y*180 translate z*14 
translate y*.05*(clock-1127) }

#include "rob4.inc"
#include "robot.inc"

object{roba rotate y*(-90-90*(clock-1126)/24 ) translate -4*x translate z*(9)
translate z*(5*(clock-1127)/24) 
}
object{roba rotate y*(90+90*(clock-1126)/24) translate 4*x translate z*(9) 
translate z*(5*(clock-1127)/24)
}

#include "rob8.inc"
#include "robot.inc"

object{roba rotate y*(-90-90*(clock-1126)/24) translate -8*x translate z*6
translate z*(5*(clock-1127)/24) translate x*4*(clock-1127)/24
}
object{roba rotate y*(90+90*(clock-1126)/24) translate 8*x translate z*6
translate z*(5*(clock-1127)/24) translate -x*4*(clock-1127)/24
}

#include "rob12.inc"
#include "robot.inc"

object{roba rotate y*(-90-90*(clock-1126)/24) translate -12*x translate z*3
translate z*(5*(clock-1127)/24) translate x*4*(clock-1127)/24
}
object{roba rotate y*(90+90*(clock-1126)/24) translate 12*x translate z*3
translate z*(5*(clock-1127)/24) translate -x*4*(clock-1127)/24
}

}//

object {dancers scale .75 translate 2*z}

#end
#end

#if (clock>1151)
#if (clock<1177)

#declare dancers = union{

#include "rob0.inc"
#include "robot.inc"

object{roba scale (1-.01*(clock-1127)) 
rotate y*180 translate z*14 
translate y*.05*(clock-1127) }

#include "rob4.inc"
#include "robot.inc"

object{roba scale (1-.01*(clock-1151))
rotate y*(-180) translate -4*x translate z*(9)
translate z*5 translate y*.05*(clock-1151)
}
object{roba scale (1-.01*(clock-1151))
rotate y*(180) translate 4*x translate z*(9) 
translate z*5 translate y*.05*(clock-1151)
}

#include "rob8.inc"
#include "robot.inc"

object{roba rotate y*(-180) translate -8*x translate z*6
translate z*(4.5*(clock-1127)/24) translate x*4
}
object{roba rotate y*(180) translate 8*x translate z*6
translate z*(4.5*(clock-1127)/24) translate -x*4
}

#include "rob12.inc"
#include "robot.inc"

object{roba rotate y*(-180) translate -12*x translate z*3
translate z*(5*(clock-1127)/24) translate x*4*(clock-1127)/24
}
object{roba rotate y*(180) translate 12*x translate z*3
translate z*(5*(clock-1127)/24) translate -x*4*(clock-1127)/24
}

}//

object {dancers scale .75 translate 2*z}

#end
#end

#if (clock>1176)

#declare dancers = union{

#include "rob0.inc"
#include "robot.inc"

object{roba scale (1-.01*(clock-1127)) 
rotate y*180 translate z*14 
translate y*.05*(clock-1127) }

#include "rob4.inc"
#include "robot.inc"

object{roba scale (1-.01*(clock-1151))
rotate y*(-180) translate -4*x translate z*(9)
translate z*5 translate y*.05*(clock-1151)
}
object{roba scale (1-.01*(clock-1151))
rotate y*(180) translate 4*x translate z*(9) 
translate z*5 translate y*.05*(clock-1151)
}

#include "rob8.inc"
#include "robot.inc"

object{roba scale (1-.01*(clock-1176))
rotate y*(-180) translate -8*x translate z*6
//translate z*(4.5*(clock-1127)/24) translate x*4
translate z*(4.5*(1176-1127)/24) translate x*4 translate y*.05*(clock-1176)
}
object{roba scale (1-.01*(clock-1176))
rotate y*(180) translate 8*x translate z*6
//translate z*(5*(clock-1127)/24) translate -x*4
translate z*(5*(1176-1127)/24) translate -x*4 translate y*.05*(clock-1176)
}

#include "rob12.inc"
#include "robot.inc"

object{roba rotate y*(-180) translate -12*x translate z*3
translate z*(4*(clock-1127)/24) translate x*4 translate x*4*(clock-1127)/24
}
object{roba rotate y*(180) translate 12*x translate z*3
translate z*(4*(clock-1127)/24) translate -x*4 translate -x*4*(clock-1127)/24
}

}//

object {dancers scale .75 translate 2*z}


#end


#include "audien.inc"

object{audi translate 12*z rotate 180*y translate -1.5*y}
