// Persistence of Vision Ray Tracer Scene Description File
// File: booms.inc
// Vers: 3.5
// Desc: Explosion-Presets for IRTC-Duel
// Date: 20.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 30.09.04 (dd.mm.yy)

//Required Files

//Description

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE
/*
//General Settings required for "booms.inc"
#declare Camera_Location = <0,0,0>;
#declare Animation_Time = 0;

//Settings for the Fire-Explosion
#declare ExpFire_Normal = <0,1,0>;
#declare ExpFire_Timer = 0;
#declare ExpFire_Location = <0,0,0>;
#declare ExpFire_Scale = 1;
#declare ExpFire_Gravity = 1;
#declare ExpFire_Trails = 15;
#declare ExpFire_TrailForce = 1;
#declare ExpFire_TrailFrames = 2;

//Settings for the Plasma-Explosion
#declare ExpPlasma_Normal = <0,1,0>;
#declare ExpPlasma_Timer = 0;
#declare ExpPlasma_Location = <0,0,0>;
#declare ExpPlasma_Scale = 1;
#declare ExpPlasma_Clouds = 15;

Generate_ExpFire()
//Parsys_Run()
//Show_ExpFire()
//Show_ExpPlasma()
*/

#ifndef (_look_at_inc_tnw) #include "look_at.inc" #end
#ifndef (_parsys_inc_tnw) #include "parsys.inc" #end

#declare ExpFire_Seed = seed(2);
#declare ExpPlasma_Rand=seed(4);
#declare BoomsRand = seed(frame_number); //Frame-Dependant-Rand
#declare SmokeRand=seed(frame_number+1);
#declare PlasmaRand=seed(frame_number+2);

#ifndef (Preview_Booms) #declare Preview_Booms = off; #end

//=================
//Missile Explosion
//=================

#ifndef (ExpFire_Normal) #declare ExpFire_Normal = <0,1,0>; #end
#ifndef (ExpFire_Timer) #declare ExpFire_Timer = 0; #end
#ifndef (ExpFire_Location) #declare ExpFire_Location = <0,0,0>; #end
#ifndef (ExpFire_Scale) #declare ExpFire_Scale = 1; #end
#ifndef (ExpFire_Gravity) #declare ExpFire_Gravity = 1; #end
#ifndef (ExpFire_Trails) #declare ExpFire_Trails = 15; #end
#ifndef (ExpFire_TrailForce) #declare ExpFire_TrailForce = 1; #end
#ifndef (ExpFire_TrailFrames) #declare ExpFire_TrailFrames = 2; #end

//Macro that returns 0 - 1 when first parameter is within the range
#macro Stretch2Interval(_Val,_Min,_Max) ((_Val-_Min)/(_Max-_Min)) #end

//Particle for the Fire-Explosion
#macro ExpFire_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;

  #local _Pos = Data[2]+Data[5]*min(Stretch2Interval(Age,0,1),1);
  #local _CamPos = Camera_Location;
  #local _Rot = Look_At(_CamPos-_Pos);

  //Fire-Type
  #if (Data[7].x=1 & Stretch2Interval(Ager,0,1)<1)
    sphere{0,1 hollow
      pigment{rgbt <0,0,0,1>}
      #if (Preview_Booms)
        pigment{rgb <1,1,0>}
      #end
      interior{
        media{
          emission 1.25-1.25*Stretch2Interval(Ager,0,1)
          absorption 1-Stretch2Interval(Ager,0,1)
          method 2 intervals 3 samples 1,1
          density{
            spherical color_map{[0 rgb 0][.1 rgb x*.1][.8 rgb <.6,.3,.01>][1 rgb 1]}
            translate Data[4]*(10+2*Age)
            warp{turbulence .6}
            translate Data[4]*-(10+2*Age)
            scale .8
          }
        }
      }
      scale ExpFire_Scale*.8*(Data[1].y+min(Stretch2Interval(Age,0,.25),1)*3)
      translate _Pos
      no_shadow
    }
  #end
  //Smoke-Type
  #if (Data[7].x=2)
    intersection{
      sphere{0,1 hollow
        pigment{
          cylindrical
          color_map{[0 rgbt <0,0,0,1>][1 rgb Data[4].y*.5+Data[6] transmit .5+.5*Ager]}
          translate Data[4]*(10+2*Age)
          warp{turbulence .6}
          translate Data[4]*-(10+2*Age)
          scale .65
          rotate y*Data[4].y*360
        }
      #if (Preview_Booms)
        pigment{rgb <.1,.1,.1>}
      #end
      }
      box{<-1.1,0,-1.1>,1.1 hollow pigment{rgbt 1}}
      rotate x*-90
      rotate _Rot
      scale ExpFire_Scale*.7*(Data[1].y+1.5*min(Data[0].x,1)+.3*min(Data[0].x*10,1))
      translate _Pos
      no_shadow
    }
  #end
#end

//Media-Sphere for glowing debris-trails
#macro ExpFire_GlowDebris(_Position,_Clock,_Scale)
    sphere{0,1 hollow
      pigment{rgbt 1}
      #if (Preview_Booms)
        pigment{rgb <1,.5,0>}
      #end
      interior{
        media{
          emission 1.25*(1-_Clock)
          absorption
          method 2 intervals 6 samples 1,1
          density{spherical color_map{[0 rgb 0][.3 rgb x*.2][.6 rgb <1,.4,0>][1 rgb 20]}}
        }
      }
      scale (.5-.4*_Clock)*_Scale
      translate _Position
      no_shadow
    }  
#end

//Fire-Group
ParticleGroup_Begin("particles/expfire",<1/25,1/25,0>)
ParticleGroup_TurbWind(
  2,.6,9,.1, //Turbulence Settings
  <0,10,0>*clock, //Modifies position of field
  5, //Multiplier for the speeds generated by turbulence
  .1)
//ParticleGroup_LinearWind(<0,1,0>,5,.2)
ParticleGroup_End()

#macro Generate_ExpFire()

#if (clock*Animation_Time >= ExpFire_Timer & clock*Animation_Time < ExpFire_Timer+.5)
//Explosion-Particles
  #local A=0;
  #while (A<6)

    #if (vlength(ExpFire_Normal)=0)
      //Undirected Explosion
      #local Position =vnormalize(<rand(BoomsRand),rand(BoomsRand),rand(BoomsRand)>*2-1)*(.2+.1*rand(BoomsRand));
      #local Position = Position*ExpFire_Scale+ExpFire_Location;
      #local Direction=vnormalize(<rand(BoomsRand),rand(BoomsRand),rand(BoomsRand)>*2-1)*2*ExpFire_Scale; 
    #else
      //Directed Explosion
      #local Position = vnormalize(<rand(BoomsRand),rand(BoomsRand),rand(BoomsRand)>*2-1);
      #if (Position.z > 0)
        #local Position = Position*<1,1,-1>;
      #end
      #local Position = Position*(.2+.1*rand(BoomsRand))*<1,1,2>;
      #local Direction = vnormalize(<rand(BoomsRand),rand(BoomsRand),rand(BoomsRand)>*2-1)*<1,1,2>*2;
      #if (Direction.z > 0)
        #declare Direction = Direction*<1,1,-1>;
      #end
      #local RotNormal = Look_At(ExpFire_Normal);
      #local Position = vrotate(Position,RotNormal)*ExpFire_Scale+ExpFire_Location;
      #local Direction = vrotate(Direction,RotNormal)*ExpFire_Scale;
      
    #end
     
    //Fire particle
    #if (frame_number-ExpFire_Timer*25 < 5)
      Particle_Add("particles/expfire",
        array[8]{
          <0,1,Animation_Time*(clock+clock_delta*rand(BoomsRand))>,
          <0,.1,0>,
          Position,
          Direction,
          <rand(BoomsRand),rand(BoomsRand),rand(BoomsRand)>,
          <0,0,0>,
          <0,0,0>,
          <1,0,0>})
    #end
    //Smoke on fire
    #if (frame_number-ExpFire_Timer*25 > 1 & frame_number-ExpFire_Timer*25 < 5)
      Particle_Add("particles/expfire",
        array[8]{
          <0,2,Animation_Time*(clock+clock_delta*rand(BoomsRand))>,
          <0,1.5,0>,
          Position,
          <0,0,0>,
          <rand(BoomsRand),rand(BoomsRand),rand(BoomsRand)>,
          Direction*1.5,
          <.3,.3,.3>,
          <2,0,0>,
          })
    #end 
    //General smoke   
    #if (frame_number-ExpFire_Timer*25 > 5 & A < 2)
      Particle_Add("particles/expfire",
        array[8]{
          <0,3,Animation_Time*(clock+clock_delta*rand(BoomsRand))>,
          <0,1.5,0>,
          Position,
          <0,0,0>,
          <rand(BoomsRand),rand(BoomsRand),rand(BoomsRand)>,
          Direction,
          <.6,.6,.6>,
          <2,0,0>
          })
    #end 
    
    
    #local A=A+1;
  #end
#end

//Debris/Trails
#if (clock*Animation_Time >= ExpFire_Timer & clock*Animation_Time < ExpFire_Timer+3)
  #declare A=0;
  #while (A<ExpFire_Trails)
    #local DebrisMax = 1+2*rand(ExpFire_Seed);
    #local DebrisClock = Stretch2Interval(clock*Animation_Time,ExpFire_Timer,ExpFire_Timer+DebrisMax);
    #if (vlength(ExpFire_Normal)=0)
      //Undirected Explosion
      #local Position =vnormalize(<rand(ExpFire_Seed),rand(ExpFire_Seed),rand(ExpFire_Seed)>*2-1)*(.2+.1*rand(ExpFire_Seed));
      #local Position = Position*ExpFire_Scale+ExpFire_Location;
      #local Direction=vnormalize(<rand(ExpFire_Seed),rand(ExpFire_Seed),rand(ExpFire_Seed)>*2-1)*15*ExpFire_Scale*ExpFire_TrailForce; 
    #else
      //Directed Explosion
      #local Position = vnormalize(<rand(ExpFire_Seed),rand(ExpFire_Seed),rand(ExpFire_Seed)>*2-1);
      #if (Position.z > 0)
        #local Position = Position*<1,1,-1>;
      #end
      #local Position = Position*(.2+.1*rand(ExpFire_Seed))*<1,1,2>;
      #local Direction = vnormalize(<rand(ExpFire_Seed),rand(ExpFire_Seed),rand(ExpFire_Seed)>*2-1)*(10+5*rand(ExpFire_Seed))*ExpFire_Scale;
      #if (Direction.z > 0)
        #local Direction = Direction*<1,1,-1>;
      #end
      #local RotNormal = Look_At(ExpFire_Normal);
      #local Position = vrotate(Position,RotNormal)*ExpFire_Scale+ExpFire_Location;
      #local Direction = vrotate(Direction,RotNormal)*ExpFire_Scale*ExpFire_TrailForce;
    #end
    #declare Position = Position+Direction*DebrisMax/3*DebrisClock-y*pow(DebrisClock*DebrisMax,2)*ExpFire_Gravity;
    #local _Scale = (rand(ExpFire_Seed)*.6+.4);
    #local DG_True = rand(ExpFire_Seed);
    #if (DebrisClock<=1)
      #if (clock*Animation_Time-ExpFire_Timer > .4/ExpFire_TrailForce & mod(frame_number,ExpFire_TrailFrames)=0)
        Particle_Add("particles/expfire",
          array[8]{
            <0,1.5,clock*Animation_Time>,
            <0,(.02+.08*_Scale)*ExpFire_Scale,0>,
            Position,
            <0,0,0>,
            <rand(BoomsRand),rand(BoomsRand),rand(BoomsRand)>,
            <0,0,0>,
            <.8,.8,.8>,
            <2,0,0>
          })
      #end 
      #if (DG_True > .4)
        ExpFire_GlowDebris(Position,DebrisClock,_Scale*ExpFire_Scale)
      #end
    #end
    #declare A=A+1;
  #end
#end

#end

#macro Show_ExpFire()
  Show_Particles("particles/expfire","ExpFire_Particle")
#end

//================
//Plasma Explosion
//================
#ifndef (ExpPlasma_Normal) #declare ExpPlasma_Normal = <0,1,0>; #end
#ifndef (ExpPlasma_Timer) #declare ExpPlasma_Timer = 0; #end
#ifndef (ExpPlasma_Location) #declare ExpPlasma_Location = <0,0,0>; #end
#ifndef (ExpPlasma_Scale) #declare ExpPlasma_Scale = 1; #end
#ifndef (ExpPlasma_Clouds) #declare ExpPlasma_Clouds = 15; #end


#macro Show_ExpPlasma()

  #if (clock*Animation_Time >= ExpPlasma_Timer & clock*Animation_Time < ExpPlasma_Timer+1.5)
  
  #local PlasmaClock = Stretch2Interval(clock*Animation_Time,ExpPlasma_Timer,ExpPlasma_Timer+1.5);
  #if (vlength(ExpPlasma_Normal)=0)
    #local _Rot = <0,0,0>;
  #else
    #local _Rot = Look_At(ExpPlasma_Normal);
  #end
  #local Plasma_Transform =
    transform{
      rotate _Rot
      scale (.25+.75*min(PlasmaClock*4,1))*ExpPlasma_Scale
      translate ExpPlasma_Location
    }

  #local A=0;
  #while (A<ExpPlasma_Clouds)

    #if (vlength(ExpPlasma_Normal)=0)
      #local Direction = vnormalize(<rand(ExpPlasma_Rand),rand(ExpPlasma_Rand),rand(ExpPlasma_Rand)>*2-1)*2*ExpPlasma_Scale;
    #else
      #local Direction = vnormalize(<rand(ExpPlasma_Rand),rand(ExpPlasma_Rand),rand(ExpPlasma_Rand)>*2-1)*<1,1,3>*(.5+.5*rand(ExpPlasma_Rand));
      #if (Direction.z>0)
        #local Direction=Direction*<1,1,-1>;
      #end
    #end

    sphere{
      0,1-.4*PlasmaClock hollow
      pigment{rgbt 1}
      interior{
        media{
          emission (1-PlasmaClock)
          absorption .5*(1-PlasmaClock)
          method 2 intervals 3 samples 1,1
          density{spherical color_map{[0 rgb 0][.4 rgb <.1,.6,.2>*.5][.5 rgb .1][.6 rgb <.2,.1,.6>][1 rgb 1]}
            translate Direction*5
            warp{turbulence 1.6*PlasmaClock omega .6}
            translate -Direction*5
            scale 1-.8*sqrt(PlasmaClock)
          }
          density{bozo color_map{[0 rgb 1-PlasmaClock][1 rgb 1]}scale .3}
        }   
      }
      #if (Preview_Booms)
        pigment{rgb <0,.5,1>}
      #end
      scale .5+sqrt(PlasmaClock)*5
      translate Direction*(.15+(3+1.5*rand(ExpPlasma_Rand))*PlasmaClock)
      transform{Plasma_Transform}
      no_shadow
    }

    #local A=A+1;
  #end  

  #if (vlength(ExpPlasma_Normal)!=0)
    union{
      disc{0,y,1 hollow
        pigment{spherical color_map{[0 rgbt <1,1,1,sqrt(PlasmaClock)>][.6-.4*clock rgbt 1][1 rgbt 1]}}
        scale .2+8*sqrt(PlasmaClock)
        finish{ambient 1 diffuse 0}
      }
      torus{.25+8*sqrt(PlasmaClock),.05 pigment{rgb 1 transmit sqrt(PlasmaClock)} finish{ambient 1 diffuse 0}}
      rotate x*90
      transform{Plasma_Transform}
      no_shadow
    }
  #end
  #end
#end

//=======
// Smoke
//=======
#macro Smoke_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;

  #local _Pos = Data[2];
  #local _CamPos = Camera_Location;
  #local _LightPos = Desert_SunPos;
  #local _Rot = Look_At(_CamPos-_Pos);
  #local _SRot = Look_At(_LightPos-_Pos);
  
  #if (!Preview_Booms)
  sphere{0,1 hollow
    pigment{
      cylindrical
      color_map{[0 rgbt <0,0,0,1>][1 rgb Data[4].y*.5 transmit .6+.4*Ager]}
      translate Data[4]*(10+2*Age)
      warp{turbulence .6}
      translate Data[4]*-(10+2*Age)
      scale .65
      rotate y*Data[4].y*360
    }
    rotate x*-90
    scale <1,1,.1>
    rotate _SRot
    scale 1/1.8*(Data[1].y+1.5*min(Data[0].x,1)+.3*min(Data[0].x*10,1))
    translate Data[2]
    no_image
    no_reflection
  }
  #end
  
  sphere{0,1 hollow
    pigment{
      cylindrical
      color_map{[0 rgbt <0,0,0,1>][1 rgb Data[4].y*.5+.5 transmit .6+.4*Ager]}
      translate Data[4]*(10+2*Age)
      warp{turbulence .6}
      translate Data[4]*-(10+2*Age)
      scale .65
      rotate y*Data[4].y*360
    }
    #if (Preview_Booms)
      pigment{rgb <.2,.2,.2>}
    #end
    clipped_by{box{<-1.1,0,-1.1>,1.1}}
    rotate x*-90
    scale <1,1,.5>
    rotate _Rot
    scale 1/1.8*(Data[1].y+1.5*min(Data[0].x,1)+.3*min(Data[0].x*10,1))
    translate Data[2]
    no_shadow
  }
      
#end

//Smoke-Column - Group
ParticleGroup_Begin("particles/smoke",<1/25,1/25,0>)
/*
ParticleGroup_TurbWind(
  2,.6,9,.1, //Turbulence Settings
  <0,10,0>*clock, //Modifies position of field
  20, //Multiplier for the speeds generated by turbulence
  .1)
*/
ParticleGroup_End()

#macro Add_Smoke(Pos,Dir,Size,Age)
  Particle_Add("particles/smoke",
    array[5]{
    <0,Age,clock*Animation_Time+clock_delta*Animation_Time*rand(SmokeRand)>,
    <0,Size,0>,
    Pos,
    Dir,
    <rand(SmokeRand),rand(SmokeRand),rand(SmokeRand)>
    })

#end

#macro Show_Smoke()
  Show_Particles("particles/smoke","Smoke_Particle")
#end

//=============
// Plasma-Bomb
//=============
#macro Prepare_Plasma(_Object,_Direction)

ParticleGroup_Begin("particles/plasma",<1/25,1/25,0>)
ParticleGroup_LinearWind (vnormalize(_Direction),vlength(_Direction),.875)
#if (strcmp("",_Object)!=0)
  ParticleGroup_Object(_Object,.35,1,0,"none","none")
#end

ParticleGroup_End()

#end

#macro Plasma_Bomb(_Position,_Scale,_Rotation,_Direction)
  sphere{0,1 hollow
    pigment{rgbt 1}
    interior{
      media{
        emission 1
        absorption .75
        method 2 samples 1,1 intervals 25
        density{onion scale .62 phase -Animation_Time*clock*2
          color_map{[0 rgb 1][.4 rgb <0,.5,1>][.7 rgb 0][1 rgb 1]}
          translate _Position          
          warp{turbulence .1 lambda 2.5 omega .5 octaves 6}
          translate -_Position
        }
        density{bozo color_map{[0 rgb .3][1 rgb 1]} scale .2 translate _Direction*Animation_Time*clock}
        density{spherical color_map{[0 rgb 0][.2 rgb .5][.4 rgb 1][1 rgb 1]}}
      }
      media{
        emission 1
        method 2 samples 1,1 intervals 10
        density{spherical poly_wave 5 color_map{[0 rgb 0][1 rgb 3]}}
      }
    }
    scale _Scale
    rotate _Rotation
    translate _Position
    no_shadow
  }
#end

#macro Plasma_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  #local _Pos = Data[2];
  sphere{0,1 hollow
    pigment{rgbt 1}
    #if (Preview_Booms)
      pigment{rgb <0,.5,1>}
    #end
    interior{
      media{
        emission 1-Ager
        method 2 samples 1,1 intervals 5
        density{spherical color_map{[0 rgb 0][1 rgb vnormalize(.25+<0,.5,1>*Data[4].x)]}}
      }
    }
    scale <1,1,1>*Data[1].y
    translate _Pos
    no_shadow
  }
#end


#macro Plasma_Sparks(_Position,_Scale,_Rotation,_Direction,_Size,_Amount,_Speed)
  #local A=0;
  #while (A<_Amount)
    #local _Dir = vrotate(vnormalize(<rand(PlasmaRand),rand(PlasmaRand),rand(PlasmaRand)>*2-1)*_Scale,_Rotation);
    #local _Pos = _Dir*.5;
      Particle_Add("particles/plasma",
        array[5]{
        <0,1,clock*Animation_Time+clock_delta*Animation_Time*rand(PlasmaRand)>,
        <0,_Size,0>,
        _Pos+_Position,
        _Dir*(1+(_Speed-1)*rand(PlasmaRand))-_Direction,
        <rand(PlasmaRand),rand(PlasmaRand),rand(PlasmaRand)>
        }
      )
    #local A=A+1;
  #end
#end

#macro Plasma_Load(_Start,_End,_Amount,_Position,_Scale,_Rotation)
  #if (Animation_Time*clock > _Start & Animation_Time*clock < _End)
  #local _T = (Animation_Time*clock-_Start)/(_End-_Start);
  #local _R=seed(abs(_Amount*_Start-_End)*1000);
  #local A=0;
  #while (A<_Amount)
    #local _Pos = vrotate(vnormalize(<rand(_R),rand(_R),rand(_R)>*2-1)*_Scale*(1+2*rand(_R)),_Rotation);
    #local _Pos = _Pos*(.1+.9*(1-_T));

  sphere{0,1 hollow
    pigment{rgbt 1}
    #if (Preview_Booms)
      pigment{rgb <0,.5,1>}
    #end
    interior{
      media{
        #if (_T<.9)
          emission sqrt(_T)
        #else
          emission sqrt(_T)*(1-(_T-.9)/.1)
        #end
        method 2 samples 1,1 intervals 5
        density{spherical color_map{[0 rgb 0][1 rgb vnormalize(.25+<0,.5,1>*rand(_R))]}}
      }
    }
    scale .2
    translate _Position+_Pos
    no_shadow
  }
    
    
    #local A=A+1;
  #end 
  #end
#end


#macro Show_Plasma()
  Show_Particles("particles/plasma","Plasma_Particle")
#end


//Missile
#declare Jet_Missile =
  union{
    //Main Missile-Body
    sphere{0,.075 scale <1,1,3>
      pigment{rgb x}
      finish{
        specular .2 roughness .02
        brilliance 2
      }
    }
    cylinder{0,z,.075}
    cone{z,.075,z*1.25,.04 open hollow}
    cone{z*1.25,.02,z,0 open hollow
      pigment{rgb 0}
    }
    torus{.03,.01 rotate x*90 translate z*1.25}
    #declare Missile_Fins=
    mesh{
      //Tiny front Fins
      triangle{<0,0,.1>,< .05,0,.25>,<0,.175,.2>}
      triangle{<0,0,.1>,<-.05,0,.25>,<0,.175,.2>}
      triangle{<.05,0,.25>,<-.05,0,.25>,<0,.175,.2>}
      //Large Fins
      triangle{<0,0,.5>,< .05,0,.95>,<0,.2,.85>}
      triangle{<0,0,.5>,<-.05,0,.95>,<0,.2,.85>}
      triangle{<.05,0,.95>,<-.05,0,.95>,<0,.2,.85>}
      //Smaller rear Fins
      triangle{<0,0,.9>,< .05,0,1.1>,<0,.2,1.1>}
      triangle{<0,0,.9>,<-.05,0,1.1>,<0,.2,1.1>}
      triangle{<.05,0,1.1>,<-.05,0,1.1>,<0,.2,1.1>}
    }
    union{
      object{Missile_Fins}
      object{Missile_Fins rotate z*90}
      object{Missile_Fins rotate z*180}
      object{Missile_Fins rotate z*270}
      pigment{rgb .2}
      finish{
        specular .2 roughness .03
        brilliance 3
      }
    }
    sphere{0,.025 scale <.5,1,8> translate <.075,0,.45> rotate z*45}        
    sphere{0,.025 scale <.5,1,8> translate <.075,0,.45> rotate z*135}        
    sphere{0,.025 scale <.5,1,8> translate <.075,0,.45> rotate z*225}        
    sphere{0,.025 scale <.5,1,8> translate <.075,0,.45> rotate z*315}        

    pigment{rgb 1}
    finish{
      specular .4 roughness .01
      brilliance 3
      diffuse .8
    }
    rotate z*45
    translate z*-.5
  }
//Jet-Missile Macro for controlled afterburn
#macro Missile(_Afterburn)
  union{
    object{Jet_Missile}
    sphere{0,1 hollow
      pigment{rgbt 1}
      interior{
        media{
          emission _Afterburn*15
          method 2 samples 1,1 intervals 10
          density{spherical color_map{[0 rgb 0][1 rgb <1,1,0>]}}
        }
      }
      no_shadow
      scale <1,1,1+15*_Afterburn>*.04
      translate z*.75
    }
  }
#end