// Persistence of Vision Ray Tracer Scene Description File
// File: credits_.pov
// Vers: 3.6.1
// Desc: Credits of Duel-Entry
// Date: 08.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 09.10.04 (dd.mm.yy)

//Description
// Credits roll by, during which a small flyby of Jet and UFO are shown.
// At the end, my website stays for 3 seconds to lure people to my
// website. :-)

/* Commandline
+KFI1 +KFF400 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 16;

#include "duel.inc"
#include "timers.inc"

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 256
}


#declare Camera_Location = <0,5,-10>;
#declare Camera_Look_At = <0,0,0>;
camera{
  location Camera_Location*(1-.005*Clock_Cubic(12,2))
  look_at Camera_Look_At
}

//Parameters:
// 1. Pigment with default image-map (<0,0,0> to <1,1,0>)
// 2. POV-Units distance of Layer to camera
// 3. <Exponent for color-map, Ambient brightness, transparency>
// 4. true=ambient, false=diffuse
//Returns:
// 1. Text layer in front of camera, black=transparent
#macro Credits_Layer(_ImagePigment,_DistanceToCamera,_ExpBright,_Light)
  #local _Ratio =1400/640*.75;
  #local _I=function{pigment{_ImagePigment}}
  #local _Image=
    texture{
      pigment{function{_I(x,y,z).gray} color_map{[0 rgbt <1,1,1,1>][1 rgbt <1,1,1,_ExpBright.z>]} poly_wave _ExpBright.x}
      #if (_Light)
        finish{ambient _ExpBright.y diffuse 0}
      #else
        finish{ambient 0 diffuse _ExpBright.y}
      #end
      }
 #local _Size1 = -.5+_Ratio*2.5*Clock_Linear(-1,14);
 #local _Size2 = -.5-_Ratio*2+_Ratio*2.5*Clock_Linear(-1,14);
 #local _UL=Glare_Transform(<-.5, _Size1,_DistanceToCamera>);
 #local _LL=Glare_Transform(<-.5, _Size2,_DistanceToCamera>);
 #local _UR=Glare_Transform(< .5, _Size1,_DistanceToCamera>);
 #local _LR=Glare_Transform(< .5, _Size2,_DistanceToCamera>);
 mesh{
  triangle{_UL,_LL,_UR uv_vectors <0,1>,<0,0>,<1,1>}
  triangle{_UR,_LR,_LL uv_vectors <1,1>,<1,0>,<0,0>}
  texture{uv_mapping _Image}
  hollow
  no_shadow no_reflection
  photons{refraction off reflection off collect off pass_through}
  }
#end

#declare Credit_Clock = Duration(0,292/25);
#if (Credit_Clock)
  #declare Credit_Pigment = pigment{image_map{tga "texts\credits.tga"}}
  Credits_Layer(Credit_Pigment,.3,<2,1,0>,1)
#end

#declare Credit_Clock = Duration_Faded(12,3,<.5,.5>);
#if (Credit_Clock)
  #declare Credit_Pigment = pigment{image_map{tga "texts\cr_url.tga"}}
  Text_Layer(Credit_Pigment,.3,<2,1,1-Credit_Clock>,1)
#end

// Jet
//=====
#declare Jet_Clock = Clock_Linear(2,3.5);
#if (Jet_Clock!=0 & Jet_Clock !=1)
  #declare Jet_Condition = 0;
  #declare Jet_Textured = 1;
  #declare Jet_Rockets = <1,1,1,1>;
  #declare Jet_Exhaust = 0;
  #include "jet.inc"
  #declare Jet_Trans = 
    transform{
      rotate y*(-70+140*Jet_Clock)
      rotate x*(90*Jet_Clock)
    }
  object{Jet
    scale .8
    transform Jet_Trans
    translate <3,1,0>
  }
  #declare Light_Clock = Duration_Faded(2,3.5,<.5,.5>);
  light_source{
    < 200, 200,-200> rgb 1*Light_Clock
    transform Jet_Trans
    area_light x*60,y*60,25,25 orient circular adaptive 2
  }
  light_source{
    <-200, 200, 200> rgb .4*<.5,.5,1>*Light_Clock
    transform Jet_Trans
    area_light x*60,y*60,25,25 orient circular adaptive 2
  }
  light_source{<-200,-200,-200>
    rgb .4*<1,.5,.5>*Light_Clock
    transform Jet_Trans
    area_light x*60,y*60,25,25 orient circular adaptive 2
  }
#end

// UFO
//=====
#declare UFO_Clock = Clock_Linear(6,3.5);
#if (UFO_Clock!=0 & UFO_Clock!=1)
  #declare Light_Clock = Duration_Faded(6,3.5,<.5,.5>);
  #declare UFO_Condition = 0;
  #declare UFO_Textured = 1;
  #declare UFO_Lights = Light_Clock;
  #declare UFO_LightClock = clock*Animation_Time+.32;
  #include "ufo.inc"
  #declare UFO_Trans =
    transform{
      rotate y*(70-140*UFO_Clock)
      rotate x*(90*UFO_Clock)
    }
  object{UFO
    scale .55
    transform UFO_Trans
    translate <-3,0,0>
  }
  light_source{
    < 200, 200,-200> rgb 1*Light_Clock
    transform UFO_Trans
    area_light x*60,y*60,25,25 orient circular adaptive 2
  }
  light_source{
    <-200, 200, 200> rgb .4*<.5,.5,1>*Light_Clock
    transform UFO_Trans
    area_light x*60,y*60,25,25 orient circular adaptive 2
  }
  light_source{<-200,-200,-200>
    rgb .4*<1,.5,.5>*Light_Clock
    transform UFO_Trans
    area_light x*60,y*60,25,25 orient circular adaptive 2
  }
#end
