// Persistence of Vision Ray Tracer Scene Description File
// File: jet_mesh.inc
// Vers: 3.5
// Desc: Generates the Meshes required for the Jet of the IRTC-Entry Duel 
// Date: 16.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 14.10.04 (dd.mm.yy)

//Required Files

//Description

//Homepage:
// www.nolights.de
//Email:
// Tim.Nikias(@)nolights.de

#ifndef (_mmm_inc_tnw) #include "mmm.inc" #end
#ifndef (_x_over_inc_tnw) #include "x_over.inc" #end
#ifndef (_io_macs_inc_tnw) #include "io_macs.inc" #end
#ifndef (_bsplines_inc_tnw) #include "bsplines.inc" #end

#declare Jet_WingDetail = <50,2>;
#declare Jet_CockpitBorders = <.02,.2>;
#declare Jet_CockpitDetail = <30,40,10>;

#debug "\nCalculating Jet-meshes...\n"

//==========
// Jet Wings
//==========
#declare Jet_WingFront_BSpline = array[6]
  {
    <-.15,0,-.75,0>,<.25,0,.5,0>,
    <1,-.025,0,0>,<.5,0,0,2>,
    <3,-.5,1.75,0>,<.25,0,.5,0>,
  }
#declare Jet_WingRear_BSpline = array[6]
  {
    <0,0,2,0>,<0,0,0,0>,
    <1,0,2,0>,<1,0,0,0>,
    <3,-.5,2.5,0>,<0,0,0,0>,
  }

Save_Array(Jet_WingFront_BSpline,"jet/jet_wngf.spl")
Save_Array(Jet_WingRear_BSpline,"jet/jet_wngr.spl")

#declare Jet_WingNodes_Top = array[Jet_WingDetail.u][Jet_WingDetail.v];
#declare Jet_WingNodes_Base = array[Jet_WingDetail.u][Jet_WingDetail.v];

#declare A=0;
#while (A<Jet_WingDetail.u)
  #declare LoopClock = A/(Jet_WingDetail.u-1);
  
  #local _JFront = BSpline_Pos(Jet_WingFront_BSpline,LoopClock);
  #local _JRear = BSpline_Pos(Jet_WingRear_BSpline,LoopClock);

  #declare B=0;
  #while (B<Jet_WingDetail.v)
    #local LoopClock_B = B/(Jet_WingDetail.v-1);
    
    #declare Jet_WingNodes_Top[A][B] = _JFront+(_JRear-_JFront)*LoopClock_B+(y*(.1*(1-LoopClock)+.025))*(1-LoopClock_B);
    #declare Jet_WingNodes_Base[A][B] = _JFront+(_JRear-_JFront)*LoopClock_B-(y*(.1*(1-LoopClock)+.025))*(1-LoopClock_B);
    
    #declare B=B+1;
  #end
  #declare A=A+1;
#end

#declare Jet_WingNormals_Top = Make_Normals(Jet_WingNodes_Top);
#declare Jet_WingNormals_Base = Make_Normals(Jet_WingNodes_Base);

#debug " -Completed Wing-Meshes...\n"
Write_Smooth_Mesh(Jet_WingNodes_Top,Jet_WingNormals_Top,"jet/jet_wngt.msh")
Write_Smooth_Mesh(Jet_WingNodes_Base,Jet_WingNormals_Base,"jet/jet_wngb.msh")
#debug " -Saved Wing-Meshes...\n"

//Generating Positions for the Missiles
#declare Jet_WingTrace = #include "jet/jet_wngb.msh";

#declare Jet_MissilePos1 = <.5,0,.5>;
#declare Jet_Missile1HandleBase = trace(Jet_WingTrace,Jet_MissilePos1-y*1,y);
Save_Value(Jet_Missile1HandleBase,"jet/jet_m1.vec")

#declare Jet_MissilePos2 = <1.2,0,.7>;
#declare Jet_Missile2HandleBase = trace(Jet_WingTrace,Jet_MissilePos2-y*1,y);
Save_Value(Jet_Missile2HandleBase,"jet/jet_m2.vec")
#debug " -Generated and saved missile-base positions...\n"


//============
// Jet Cockpit
//============
#declare Jet_CockpitNodes = array[Jet_CockpitDetail.x][Jet_CockpitDetail.y+Jet_CockpitDetail.z-1];

#declare Jet_CockpitRadius_Mid = .3;
#declare Jet_CockpitRadius_End = 0;

#macro Stretch2Interval(_Val,_Min,_Max)
  ((_Val-_Min)/(_Max-_Min))
#end

//Top-Cockpit-Mesh
#declare A=0;
#while (A<Jet_CockpitDetail.x)
  #declare LoopClock = A/(Jet_CockpitDetail.x-1);
  #declare B=0;
  #while (B<Jet_CockpitDetail.y)
    #declare LoopClock_B = B/(Jet_CockpitDetail.y-1);
    //First Straight Section
    #if (LoopClock >= 0 & LoopClock < Jet_CockpitBorders.u)
      #declare _Cur = <-.5,0,0>+y*.375*Stretch2Interval(LoopClock,0,Jet_CockpitBorders.u);
      #declare _Goal = vrotate(<-Jet_CockpitRadius_Mid,0,0>,z*-90*LoopClock);
      #declare Jet_CockpitNodes[A][B] = (_Cur+(_Goal-_Cur)*LoopClock_B)*<1,1-.5*LoopClock_B,1>+<0,0,-1.5>*LoopClock_B;
    #end
    //Curved Section
    #if (LoopClock >= Jet_CockpitBorders.u & LoopClock < Jet_CockpitBorders.v)
      #declare _Cur = <-.45,.375,0>+vrotate(<-.05,0,0>,z*-90*Stretch2Interval(LoopClock,Jet_CockpitBorders.u,Jet_CockpitBorders.v));
      #declare _Goal = vrotate(<-Jet_CockpitRadius_Mid,0,0>,z*-90*LoopClock);
      #declare Jet_CockpitNodes[A][B] = (_Cur+(_Goal-_Cur)*LoopClock_B)*<1,1-.5*LoopClock_B,1>+<0,0,-1.5>*LoopClock_B;
    #end
    //Middle Straight Section
    #if (LoopClock >= Jet_CockpitBorders.v & LoopClock <= 1)
      #declare _Cur = <-.45,.425,0>+x*.45*Stretch2Interval(LoopClock,Jet_CockpitBorders.v,1);
      #declare _Goal = vrotate(<-Jet_CockpitRadius_Mid,0,0>,z*-90*LoopClock);
      #declare Jet_CockpitNodes[A][B] = (_Cur+(_Goal-_Cur)*LoopClock_B)*<1,1-.5*LoopClock_B,1>+<0,0,-1.5>*LoopClock_B;
    #end
    #declare B=B+1;
  #end
  //Tip
  #declare B=1;
  #while (B<Jet_CockpitDetail.z)
    #declare LoopClock_B = B/(Jet_CockpitDetail.z-1);
    #declare _Cur = vrotate(<-Jet_CockpitRadius_Mid,0,0>,z*-90*LoopClock);
    #declare _Goal = vrotate(<-Jet_CockpitRadius_End,0,0>,z*-90*LoopClock);
    #declare Jet_CockpitNodes[A][B+Jet_CockpitDetail.y-1] = (_Cur+(_Goal-_Cur)*pow(LoopClock_B,2))*<1,.5,1>-z*(1.5+.25*LoopClock_B);
    #declare B=B+1;
  #end
  #declare A=A+1;
#end

//Mirror for full mesh
Mirror_Mesh_Dat(Jet_CockpitNodes,x,1)
//Cockpit-Depression
#declare A=0;
#while (A<Jet_CockpitDetail.x*2-1)
  #declare B=0;
  #while (B<Jet_CockpitDetail.y+Jet_CockpitDetail.z-1)
    #declare _Distance = vlength(Jet_CockpitNodes[A][B]*<1,1,.4>-<0,.1,-.2>);
    #if (_Distance < .3)
      #declare Jet_CockpitNodes[A][B] = Jet_CockpitNodes[A][B]-y*.2*sqrt(1-(_Distance/.3));
    #end
    #declare B=B+1;
  #end
  #declare A=A+1;
#end


#declare Jet_CockpitNormals=Make_Normals(Jet_CockpitNodes);
//Straightening the edge where mesh meets main CSG-jet
#declare A=0;
#while (A<Jet_CockpitDetail.x*2-1)
  #declare Jet_CockpitNormals[A][0] = vnormalize(Jet_CockpitNormals[A][0]*<1,1,0>);
  #declare A=A+1;
#end

Translate_Mesh_Dat(Jet_CockpitNodes,<0,-.25,-.75>)

#debug " -Completed Top-Cockpit-Mesh...\n"
Write_Smooth_Mesh(Jet_CockpitNodes,Jet_CockpitNormals,"jet/jet_cpit.msh")
#debug " -Saved Top-Cockpit-Mesh...\n"

//====================
// Jet Base of Cockpit
//====================
#declare Jet_CockpitBaseNodes = array[Jet_CockpitDetail.x][Jet_CockpitDetail.y+Jet_CockpitDetail.z-1];
//Base-Cockpit-Mesh
#declare A=0;
#while (A<Jet_CockpitDetail.x)
  #declare LoopClock = A/(Jet_CockpitDetail.x-1);
  #declare B=0;
  #while (B<Jet_CockpitDetail.y)
    #declare LoopClock_B = B/(Jet_CockpitDetail.y-1);
    #declare _Cur = vrotate(<.5,0,0>,z*-90*LoopClock);
    #declare _Goal = vrotate(<Jet_CockpitRadius_Mid,0,-1.5>,z*-90*LoopClock);
    #declare Jet_CockpitBaseNodes[A][B] = (_Cur+(_Goal-_Cur)*LoopClock_B)*<1,.5,1>;
    #declare B=B+1;
  #end
  //Tip
  #declare B=1;
  #while (B<Jet_CockpitDetail.z)
    #declare LoopClock_B = B/(Jet_CockpitDetail.z-1);
    #declare _Cur = vrotate(<Jet_CockpitRadius_Mid,0,0>,z*-90*LoopClock);
    #declare _Goal = vrotate(<Jet_CockpitRadius_End,0,0>,z*-90*LoopClock);
    #declare Jet_CockpitBaseNodes[A][B+Jet_CockpitDetail.y-1] = (_Cur+(_Goal-_Cur)*pow(LoopClock_B,2))*<1,.5,1>-z*(1.5+.25*LoopClock_B);
    #declare B=B+1;
  #end
  
  #declare A=A+1;
#end

//Fit both sides
Mirror_Mesh_Dat(Jet_CockpitBaseNodes,x,1)
#declare Jet_CockpitBaseNormals=Make_Normals(Jet_CockpitBaseNodes);

//Straightening the edge where mesh meets main CSG-jet
#declare A=0;
#while (A<Jet_CockpitDetail.x*2-1)
  #declare Jet_CockpitBaseNormals[A][0] = vnormalize(Jet_CockpitBaseNormals[A][0]*<1,1,0>);
  #declare A=A+1;
#end

Translate_Mesh_Dat(Jet_CockpitBaseNodes,<0,-.25,-.75>)
#debug " -Completed Base-Cockpit-Mesh...\n"
Write_Smooth_Mesh(Jet_CockpitBaseNodes,Jet_CockpitBaseNormals,"jet/jet_cptb.msh")
#debug " -Saved Base-Cockpit-Mesh...\n"

//==========
//Jet Engine
//==========
#declare Jet_EngineDetail = <5,50>;
#declare Jet_Engine_BSpline = array[4]
  {
    <.3,0,0,0>,<.05,.25,0,0>,
    <.2,1.25,0,0>,<0,.5,0,0>,
  }

#declare Jet_EngineNodes=BSpline_Lathe(Jet_Engine_BSpline,Jet_EngineDetail.u,Jet_EngineDetail.v);

#declare A=0;
#while (A<Jet_EngineDetail.u)
  #declare LoopClock = A/(Jet_EngineDetail.u-1);
  #declare B=0;
  #while (B<Jet_EngineDetail.v)
  
    #declare Jet_EngineNodes[A][B] = Jet_EngineNodes[A][B]*<1.5-.5*LoopClock,1,1>+z*.1*LoopClock;

    #declare B=B+1;
  #end
  #declare A=A+1;
#end

#declare Jet_EngineNormals=Make_Normals(Jet_EngineNodes);
Invert_Normals(Jet_EngineNormals)

#declare A=0;
#while (A<Jet_EngineDetail.v)
  #declare Jet_EngineNormals[Jet_EngineDetail.u-1][A] = vnormalize(Jet_EngineNormals[Jet_EngineDetail.u-1][A]*<1,0,1>);
  #declare A=A+1;
#end

Rotate_Mesh_Dat(Jet_EngineNodes,x*90)
Rotate_Mesh_Dat(Jet_EngineNormals,x*90)
#debug " -Completed Engine-Mesh...\n"
Write_Smooth_Mesh(Jet_EngineNodes,Jet_EngineNormals,"jet/jet_engn.msh")
#debug " -Saved Engine-Mesh...\n"

