// Persistence of Vision Ray Tracer Scene Description File
// File: scene13_.pov
// Vers: 3.6.1
// Desc: Scene 13 of Duel-Entry : UFO shoots first, shot from beneath
// Date: 03.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 03.10.04 (dd.mm.yy)

//Description
// Scene 13 of Duel-Entry
// UFO shoots, shot from beneath.

/*Commandline
+KFI1 +KFF75 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 3;

global_settings{
  assumed_gamma 1
  max_trace_level 256
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

//Various Shakes for various objects
Create_Shake(4,.075,62,"splines/sc13_ufo.spl","UFO_Hover")
Create_Shake(6,.02,85,"splines/sc13_cam.spl","Cam_Focal")
Create_Shake(10,1,34,"splines/sc13_flar.spl","Flare_Size")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,6,5> rgb Desert_BaseColor*.3 shadowless}

// UFO
//=====
#declare UFO_Condition = 0;
#declare UFO_Textured = 1;
#declare UFO_Lights = on;
#declare UFO_LightClock = Animation_Time*clock+.83;

#include "ufo.inc"

#declare UFO_Object=
object{UFO
  rotate y*90
  translate <0,25,0>+Linear_Pos(UFO_Hover,clock)
  }

object{UFO_Object}

// Plasma-Shot
//=============
#declare PlGrow_Clock = Clock_Cubic(.5,.5);
#declare PlFire_Clock = Clock_Cubic(1,6);
#declare PlBlast_Clock = Duration_Faded(.75,.5,<.1,.1>);
#declare PlBlastFlare_Clock = Duration_Faded(.875,.25,<.1,.1>);
#declare PlSparks_Clock = Clock_Cubic(1,1);

#declare Plasma_Location = <-6.5-PlGrow_Clock*.5-80*PlFire_Clock,25,0>;

#if (PlGrow_Clock)
  Prepare_Plasma("UFO_Object",<15,0,0>)
  Plasma_Load(.5,1,70,Plasma_Location,<1,1,1>,<0,0,0>)
  Plasma_Bomb(Plasma_Location,<1,1,1>*(.01+.99*PlGrow_Clock),<0,0,0>,<-10,0,0>)
  #if (PlFire_Clock | PlBlast_Clock | PlSparks_Clock!=1)
    Plasma_Sparks(Plasma_Location,<1,1,1>,<0,0,0>,<0,0,0>,.2,10*(1-PlSparks_Clock)+30*PlBlast_Clock,2+4*PlBlast_Clock)
  #end
  Parsys_Run()
  Show_Plasma()
#end

// Camera
//========
#declare Camera_Location = <-12,21,-6>;
#declare Camera_Focal = <-7,23.5,0>;

#declare Camera_FocalLength = vlength(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Focal-Camera_Location)+Linear_Pos(Cam_Focal,clock);

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Flare from Plasma
//===================
#declare Flare_Clock = PlGrow_Clock;

#declare Flare_Nor = vnormalize(Plasma_Location-Camera_Location);
#declare Flare_Loc = Camera_Location+Flare_Nor;

disc{0,z,1 hollow
  pigment{
    spherical poly_wave 3
    color_map{
      [0 rgbt 1]
      [.7 rgbt <.8,.9,1,(1-Flare_Clock)*.7+.3>]
      [1 rgbt <1,1,1,1-Flare_Clock>]
    }
  }
  finish{ambient 1 diffuse 0}
  scale <12,1,1>*(.1+1/Camera_FocalLength+.2*PlBlastFlare_Clock+.3*Linear_Pos(Flare_Size,clock).x)
  rotate Look_At(Camera_Look_At-Camera_Location)
  translate Flare_Loc
  no_shadow no_reflection
}


// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate x*.5*Animation_Time*clock}

light_group{
  light_source{Desert_SunPos rgb Desert_SunColor shadowless}
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<0,6,5> rgb Desert_BaseColor*.3 shadowless}
  disc{
    y*10,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }
  global_lights off
}
