// Persistence of Vision Ray Tracer Scene Description File
// File: scene24_.pov
// Vers: 3.6.1
// Desc: Scene 24 of Duel-Entry : UFO is tracked by Missile
// Date: 06.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 06.10.04 (dd.mm.yy)

//Description
// Scene 24 of Duel-Entry
// Dynamic shot of camera zooming in on UFO and missile until they touch.

/*Commandline
+KFI1 +KFF75 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 3;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 25
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(23,1,34,"splines/sc24_fire.spl","Missile_Burner")
Create_Shake(14,1,28,"splines/sc24_cam1.spl","Cam_Focal")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0; //25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time+<4,2,1>}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 4;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.2 shadowless}

// UFO
//=====
#declare UFO_Pos = <0,200,0>+<0,80,0>*Animation_Time*clock;
#declare Missile_Pos = <-5+4.15*Clock_Cubic(0,3),-10,-2.3>+<0,150,0>*Animation_Time*clock; 

#declare UFO_Condition = 0;
#declare UFO_Textured = 1;
#declare UFO_Lights = on;
#declare UFO_LightClock = Animation_Time*clock+.18;

#include "ufo.inc"

object{UFO
  rotate y*90
  rotate z*-90
  translate UFO_Pos
}

// Missile
//=========
object{
  Missile(.9+.1*Linear_Pos(Missile_Burner,clock).y)
  scale 2
  rotate <90-8*Clock_Cubic(1.5,1.5),-90,0>
  translate Missile_Pos
}

// Camera
//========
#declare Cam2Missile = Clock_Cubic(1.25,1);

#declare Camera_Location = <-50,20,-150>+<0,60,0>*Animation_Time*clock;
#declare Camera_Look_At = (UFO_Pos+Missile_Pos)/2+<0,-2,0>+<-.25,4,0>*Clock_Cubic(2,1);
#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Look_At-Camera_Location);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,clock)*.1*(1-Clock_Cubic(0,3));

camera{
  location Camera_Location
  angle 66-65.15*pow(Clock_Cubic(0,3),2)
  look_at Camera_Look_At
}

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5>}

light_group{
  light_source{Desert_SunPos rgb 1 shadowless}
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.2 shadowless}
  disc{
    y*5,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }
  global_lights off
}
