// Persistence of Vision Ray Tracer Scene Description File
// File: scene25_.pov
// Vers: 3.6.1
// Desc: Scene 25 of Duel-Entry : UFO's ascends and tries to outrun Missile
// Date: 06.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 06.10.04 (dd.mm.yy)

//Description
// Scene 25 of Duel-Entry
// The initial phase of the UFO's downfall. In the former scene, the missile reached the
// UFO, in this scene, we see the explosion from a greater distance and above the ship. It's momentum
// suffices to rise to camera level, but (as the flickering lights tell) the power seems interrupted and
// it tumbles back towards the earth. It failed to outrun the missile.

/*Commandline
+KFI1 +KFF125 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 5;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 256 //<- Lots of transparent particles require high trace_level
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_ns.inc" //<- Modified version of "bkdrp_desert.inc", receives no shadows

// Shakes
//========
Create_Shake(23,1,38,"splines/sc25_ufo.spl","UFO_Blink")
Create_Shake(13,1,28,"splines/sc25_cam.spl","Cam_Focal")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 10;

//Three-point lighting on the ground is integrated into modified version
// of the background. It still only places the sunlight, hence the other
// two lightsources for other in-scene objects still need to be placed.
Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4>*2 shadowless}
light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.4 shadowless}

// UFO
//=====
#declare UFO_Pos = <0,80,0>+y*200*sqrt(Clock_Cubic(0,3))-y*250*Clock_Cubic(3,4);
//Relative-Position of damage on UFO
#declare Mis_Impact = Load_Value("ufo/ufo_hit.vec");
#declare Mis_Impact = vrotate(vrotate(Mis_Impact,<0,90,-90>),x*-360*Clock_Cubic(3,4))+UFO_Pos+y-y*Clock_Cubic(2,.5)+y*Clock_Cubic(3.5,.5);

//The lights of "UFO.inc" were updated during this scene to respond to
// a float for UFO_Lights instead of just using it as an on/off-switch.
// This way, I could make the lights flicker in a much more plausible
// manner than just plain on/off.
#declare UFO_Condition = 1;
#declare UFO_Textured = 1;
#declare UFO_Lights = max(Duration(0,2)+Linear_Pos(UFO_Blink,Clock_Linear(2,1.5)).x,0)*Duration(0,3.35);
#declare UFO_LightClock = Animation_Time*clock+.65;

#include "ufo.inc"

object{UFO
  rotate y*90
  rotate z*-90
  rotate x*-360*Clock_Cubic(3,4)
  translate UFO_Pos+x*1.5*(1-Clock_Cubic(0,.25))
}

// Camera
//========
#declare Camera_Location = vrotate(<15+15*Clock_Cubic(0,3),280,0>,y*180*Clock_Cubic(0,3));

#declare Camera_Focal = y*80+(UFO_Pos-y*80)*(.8+.2*Clock_Cubic(1.5,1));
#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,clock)*(.01+.02*Clock_Cubic(2,1));

camera{
  location Camera_Location
  //Zooming out of explosion
  angle 32+35*Clock_Cubic(0,1)
  look_at Camera_Look_At
}

// Smoke-Trail and Explosion
//===========================
ParticleGroup_Begin("particles/smoke25",<1/25,1/25,0>)
ParticleGroup_TurbWind(3,.65,12,.05,y*50*clock,50,.05)
ParticleGroup_LinearWind(-z,5,.1)
ParticleGroup_End()

//Particle for Smoke-Trail
#macro SmokeTrail_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  #local _Pos = Data[2];
  #local _CamPos = Camera_Location;
  #local _Rot = Look_At(_CamPos-_Pos);
  #local _Data4 = Data[4];
  sphere{0,1 hollow
    pigment{
      cylindrical
      color_map{[0 rgbt <0,0,0,1>][1 rgb _Data4.y*.3 transmit .3+.7*pow(Ager,3)]}
      translate _Data4*(10+2*Age)
      warp{turbulence .6}
      translate _Data4*-(10+2*Age)
      scale .65
      rotate y*_Data4.y*360
    }
    #if (Preview_Booms)
      pigment{rgb <.2,.2,.2>}
    #end
    clipped_by{box{<-1.1,0,-1.1>,1.1}}
    rotate x*-90
    scale <1,1,.5>
    rotate _Rot
    scale 1/1.8*(Data[1].y+1.5*min(Age,1)+.3*min(Age*10,1))*3
    translate _Pos
    no_shadow
  }
#end

//Placing Macro
#macro Add_Smoke(Pos,Dir,Size,Age)
  Particle_Add("particles/smoke25",
    array[5]{
    <0,Age,clock*Animation_Time+clock_delta*Animation_Time*rand(SmokeRand)>,
    <0,Size,0>,
    Pos,
    Dir,
    <rand(SmokeRand),rand(SmokeRand),rand(SmokeRand)>
    })

#end

//Settings for the Fire-Explosion
#declare ExpFire_Normal = <0,0,0>;
#declare ExpFire_Timer = 0;
#declare ExpFire_Location = <0,80,0>;
#declare ExpFire_Scale = 4;
#declare ExpFire_Gravity = 1;
#declare ExpFire_Trails = 25;
#declare ExpFire_TrailForce = 2;

//Add smoke and explosion
Add_Smoke(Mis_Impact,<0,0,0>,2,2.5)
Generate_ExpFire()
//Calculate particle-movement
Parsys_Run()
//Show the effects
Show_ExpFire()
Show_Particles("particles/smoke25","SmokeTrail_Particle")

// Ground
//========
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4>}

light_group{
  light_source{Desert_SunPos rgb 1 shadowless}
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.2 shadowless}
  disc{
    y*5,y,320 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 320
    }
    no_shadow
  }
  global_lights off
}
