// Persistence of Vision Ray Tracer Scene Description File
// File: scene30_.pov
// Vers: 3.6.1
// Desc: Scene 30 of Duel-Entry : Two missiles fly and hit the wrecked UFO
// Date: 13.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 13.10.04 (dd.mm.yy)

//Description
// Scene 30 of Duel-Entry
// Rockets shoot towards UFO and end just on it. During flight, the jet
// continues its sentence from the former scene: ...just have to...

/*Commandline
+KFI1 +KFF150 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 6;
#declare _FR = seed(frame_number);

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 200
}

//Switch to 1 for low-res meshes and simpler particles
#declare Preview = 0;

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bsplines.inc"
#include "bkdrp_cr.inc" //<- modified backdrop with hole in ground for the crater

// Shakes
//========
//Effect the sparks and liquid-leak
Create_Shake(35,1,65,"splines/sc30_sprk.spl","Sparks_Shake")
Create_Shake(15,1,28,"splines/sc30_oil.spl","Oil_Shake")
//Hovering and Shaking of Missiles/Camera
Create_Shake(6,1,73,"splines/sc30_m1h.spl","Mis1_Hover")
Create_Shake(5,1,48,"splines/sc30_m2h.spl","Mis2_Hover")
Create_Shake(16,1,64,"splines/sc30_foc.spl","Cam_Shake")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 10;
Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos-x*1000 rgb <.2,.2,.4>*.35 shadowless}
light_source{<-1,1, 1>*Desert_SunPos-x*1000 rgb <.2,.2,.4>*.35 shadowless}
light_source{<1000,2,0> rgb Desert_BaseColor*.3 shadowless}

#declare Missile_Velocity = 2*100*pi/4;

// Camera
//======== 
//Camera's path
#declare Cam_Path = array[4]
  {
    <Missile_Velocity*4+200+5,200,0>,<-400,0,0>,
    <0,-4,0>,<0,-55,0>
  }
#if (!file_exists("splines/sc30_cam.spl"))
  BSpline2Linear_Ext(Cam_Path,9000,500,"splines/sc30_cam.spl","Cam_Path","Cam_PathLin")
#end
#include "splines/sc30_cam.spl"

#declare Camera_Location = Linear_Pos(Cam_PathLin,clock*.99)+vrotate(x*1,z*45*pow(clock,3))-y*6*clock+y*2*(Clock_Cubic(2,1)-Clock_Cubic(3,1));
#declare Camera_Focal = Linear_Pos(Cam_PathLin,clock+.01)-y*4*clock;

#declare Camera_Focal = Camera_Location+vnormalize(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Focal;
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Shake,clock)*.04;
#declare Camera_Sky = vrotate(y,x*Linear_Pos(Cam_Shake,clock)*25);

camera{
  location Camera_Location+x*.01
  sky Camera_Sky
  look_at Camera_Look_At
}

// Subtitle
//==========
#declare txtJet_Clock = Duration(.5,3);
#if (txtJet_Clock)
  #declare txt_Jet = pigment{image_map{tga "texts\sc30_j.tga"}}
  Text_Layer(txt_Jet,1,<2,1,0>,1)
#end

// Missiles
//==========
//Missile #1
#declare Mis1_Path = array[4]
  {
    <Missile_Velocity*4+200,200,0>,<-400,0,0>,
    <1,-8,0>,<0,-50,0>
  }

#if (!file_exists("splines/sc30_m1.spl"))
  BSpline2Linear_Ext(Mis1_Path,9000,500,"splines/sc30_m1.spl","Mis1_Path","Mis1_PathLin")
#end
#include "splines/sc30_m1.spl"

#declare Mis1_Orientation = Look_At(BSpline_Dir(Mis1_Path,Linear_Mover(Mis1_PathLin,clock)*.98));
#declare Mis1_Position = Linear_Pos(Mis1_PathLin,clock);
#declare Mis1_Position = Mis1_Position+<0,.4,.95>+Linear_Pos(Mis1_Hover,clock);
#declare Mis1_Twist = 120*Linear_Pos(Mis1_Hover,clock);

object{
  Missile(1)
  scale 2
  rotate z*Mis1_Twist
  rotate Mis1_Orientation
  translate Mis1_Position
}

//Missile #2
#declare Mis2_Path = array[4]
  {
    <Missile_Velocity*4+200,200,0>,<-400,0,0>,
    <1.5,-7,0>,<0,-50,0>
  }

#if (!file_exists("splines/sc30_m2.spl"))
  BSpline2Linear_Ext(Mis2_Path,9000,500,"splines/sc30_m2.spl","Mis2_Path","Mis2_PathLin")
#end
#include "splines/sc30_m2.spl"

#declare Mis2_Orientation = Look_At(BSpline_Dir(Mis2_Path,Linear_Mover(Mis2_PathLin,clock)*.98));
#declare Mis2_Position = Linear_Pos(Mis2_PathLin,clock);
#declare Mis2_Position = Mis2_Position+<0,-.3,-1.2>+Linear_Pos(Mis2_Hover,clock);
#declare Mis2_Twist = 160*Linear_Pos(Mis2_Hover,clock);

object{
  Missile(1)
  scale 2
  rotate z*Mis2_Twist
  rotate Mis2_Orientation
  translate Mis2_Position
}

// UFO
//=====
#declare UFO_Pos = <0,-9,-2>;

//UFO switch to higher poly-versions the
// closer we get.
#if (Clock_Linear(2.5,1))
  #declare UFO_Condition = 2;
#else
  #if (Clock_Linear(2,1))
    #declare UFO_Condition = 1;
  #else
    #declare UFO_Condition = -1;
  #end
#end

#declare UFO_Textured = 1;
#declare UFO_Lights = 0;
#declare UFO_LightClock = 0;

#declare UFO=sphere{0,1 scale <3.5,1,5> pigment{rgb x}}
#include "ufo.inc"

#declare UFO_Transform =
  transform{
    rotate y*90
    rotate z*-90
    rotate x*87
    rotate z*35
    translate UFO_Pos
  }
#declare UFO_TrFunction = function{transform{UFO_Transform}}

#declare UFO_Object=object{UFO transform UFO_Transform}
object{UFO_Object pigment{rgb x}}

//Spark preparations
#declare Spark_Origin = vrotate(<1.1,0,0>,y*35)+y*1.1;
#declare _Sx = Spark_Origin.x;
#declare _Sy = Spark_Origin.y;
#declare _Sz = Spark_Origin.z;

#declare Spark_Origin = UFO_TrFunction(_Sx,_Sy,_Sz);
#declare Cockpit_Center = UFO_TrFunction(0,1,0);

// Crater
//========
#declare Crater_MainTex = texture{pigment{rgb Desert_BaseColor}}
#declare Crater_CenterTex =
  texture{
    pigment{
      bozo
      color_map{
        [0 rgb Desert_BaseColor]
        [1 rgb Desert_BaseColor*.9]
      }
      scale 1.5
      warp{black_hole <0,-6,0>,19 falloff 2 strength 6}
      warp{black_hole <0,-6,0>,13 falloff 2 strength 4}
      warp{black_hole <0,-6,0>,8 falloff 2 strength 2}
    }
    normal{
      bozo .1 no_bump_scale poly_wave 2 scale .8
      warp{black_hole <0,-6,0>,19 falloff 2 strength 6}
      warp{black_hole <0,-6,0>,13 falloff 2 strength 4}
      warp{black_hole <0,-6,0>,8 falloff 2 strength 2}
      turbulence .2 omega .65 octaves 11 lambda 2.5
    }
  }


#declare Crater_Object=
object{
  #if (!Preview)
    #include "crater.msh"
  #else
    #include "crater_l.msh"
  #end
  texture{
    spherical
    texture_map{
      [0 Crater_MainTex scale 1/20]
      [.2 Crater_CenterTex scale 1/20]
      [1 Crater_CenterTex scale 1/20]
    }
    scale 20
  }
  scale 1.5
}

object{Crater_Object}

// Particles
//===========
//Generates Normal for the Particles' orientation
#declare Particle_Rotation = Look_At(Camera_Location-Camera_Focal);

//Smoke-Trail from UFO
ParticleGroup_Begin("particles/smoke28",<1/25,1/25,0>)
ParticleGroup_TurbWind(3,.65,12,.05,y*50*Animation_Time*clock,30,.05)
ParticleGroup_End()
//Sparks
ParticleGroup_Begin("particles/sparks28",<1/25,1/25,0>)
ParticleGroup_Object("UFO_Object", 1, 1, 0, "none", "none")
ParticleGroup_Object("Crater_Object", 1, 1, 0, "none", "none")
ParticleGroup_Gravity(8,-y)
ParticleGroup_End()
//Leakage
ParticleGroup_Begin("particles/oil28",<1/25,1/25,0>)
ParticleGroup_Object("UFO_Object", .01, .9, 0, "none", "none")
ParticleGroup_Object("Crater_Object", .01, .9, 0, "none", "none")
ParticleGroup_Gravity(12,-y)
ParticleGroup_End()

// Smoke-Particle-Macro
//======================
#macro SmokeTrail_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  #local _Pos = Data[2];
  #local _CamPos = Camera_Location;
  #local _Rot = Particle_Rotation;
  #local _Data4 = Data[4];
  //Visible Particle
  intersection{
    sphere{0,1 hollow
      pigment{
        cylindrical
        color_map{[0 rgbt <0,0,0,1>][1 rgb _Data4.y*.1 transmit .4+.6*pow(Ager,3)]}
        translate _Data4*(10+2*Age)
        warp{turbulence .6 omega .45 lambda 2.5 octaves 9}
        translate _Data4*-(10+2*Age)
        scale .6
        rotate y*_Data4.y*360
      }
      #if (Preview)
        pigment{rgb .2}
      #end
    }
    box{<-1.1,0,-1.1>,1.1 pigment{rgbt 1}}
    rotate x*-90
    scale <1,1,.5>
    rotate _Rot
    scale 1/1.8*(Data[1].y+1.5*min(Age,1)+.3*min(Age*10,1))*3
    translate _Pos
    #if (!Preview)
      no_shadow no_reflection
    #end
  }
  #if (!Preview)
  //Shadow-Particle
  #local Shadow_Rotation = Look_At(vnormalize(Desert_SunPos)*1750-_Pos);
  intersection{
    sphere{0,1 hollow
      pigment{
        cylindrical
        color_map{[0 rgbt <0,0,0,1>][1 rgb _Data4.y*.2+.3 transmit .8]}
        translate _Data4*(10+2*Age)
        warp{turbulence .6 omega .45 lambda 2.5 octaves 9}
        translate _Data4*-(10+2*Age)
        scale .6
        rotate y*_Data4.y*360
      }
    }
    box{<-1.1,0,-1.1>,1.1 pigment{rgbt 1}}
    rotate x*-90
    scale <1,1,.5>
    rotate Shadow_Rotation
    scale 1/1.8*(Data[1].y+1.5*min(Age,1)+.3*min(Age*10,1))*3
    translate _Pos
    no_image no_reflection
  }
  //Reflection-Particle
  #local Reflection_Rotation = Look_At(Cockpit_Center-_Pos);
  intersection{
    sphere{0,1 hollow
      pigment{
        cylindrical
        color_map{[0 rgbt <0,0,0,1>][1 rgb _Data4.y*.1 transmit .4+.6*pow(Ager,3)]}
        translate _Data4*(10+2*Age)
        warp{turbulence .6 omega .45 lambda 2.5 octaves 9}
        translate _Data4*-(10+2*Age)
        scale .6
        rotate y*_Data4.y*360
      }
      #if (Preview)
        pigment{rgb .2}
      #end
    }
    box{<-1.1,0,-1.1>,1.1 pigment{rgbt 1}}
    rotate x*-90
    scale <1,1,.5>
    rotate Reflection_Rotation
    scale 1/1.8*(Data[1].y+1.5*min(Age,1)+.3*min(Age*10,1))*3
    translate _Pos
    no_shadow no_image
  }
  #end
#end

// Spark-Particle-Macro
//======================
#macro Spark_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  #local _Pos = Data[2];
  sphere{0,1 hollow
    pigment{rgbt 1}
    #if (Preview)
      pigment{rgb <1,1,0>}
    #end
    interior{
      media{
        emission 8
        method 2 intervals 5 samples 1,1
        density{spherical poly_wave 2 color_map{[0 rgb 0][.5 rgb <.7,.2,0>][1 rgb <1,.8,.3>]}}
      }
    }
    scale <1,1,1>*Data[1].y
    scale <1,1,3>
    rotate Look_At(Data[3])
    translate _Pos
    no_shadow
  }
#end

// Oil-Particle-Macro
//====================
#macro Oil_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  sphere{0,2,1-Ager*.95
    scale <1,1,1.75>*Data[1].y
    rotate Look_At(Data[3])
    translate Data[2]
  }
#end

#declare Spark_Size = Linear_Pos(Sparks_Shake,mod(Animation_Time*clock,2)/2);

#if (Spark_Size.x > .2)

sphere{0,1 hollow
  pigment{rgbt 1}
  interior{
    media{
      emission 8
      method 2 intervals 5 samples 1,1
      density{spherical poly_wave 2 color_map{[0 rgb 0][.5 rgb <.7,.2,0>][1 rgb <1,.8,.3>]}}
    }
  }
  scale .4+.1*Spark_Size
  translate Spark_Origin
}
#end

//This only generates sparks/liquid for the very last bit
#if (Clock_Linear(2.5,1))
  #if (Spark_Size.x > .4)
    #declare A=0;
    #while (A<5+max(Spark_Size.y*10,0))
      #declare Dir = vnormalize(<rand(_FR),rand(_FR),rand(_FR)>*2-1)*(3+3*rand(_FR))+y*max(Spark_Size.z,0);
      Particle_Add("particles/sparks28",
        array[4]{
          <0,.75,clock*Animation_Time+clock_delta*Animation_Time*rand(SmokeRand)>,
          <10,.1,0>,
          Spark_Origin,
          Dir}
        )
      #declare A=A+1;
    #end
  #end
  #declare Oily = trace(UFO_Object,<-.2,-4,.4>,-y);
  #declare A=0;
  #while (A<3+7*Clock_Linear(2,1))
    #declare Dir = vnormalize(Linear_Pos(Oil_Shake,clock)*.4+vnormalize(<rand(_FR),rand(_FR),rand(_FR)>*2-1)*.2+y*.3)*1.5;
    Particle_Add("particles/oil28",
      array[4]{
        <0,2.5,clock*Animation_Time+clock_delta*Animation_Time*rand(_FR)>,
        <10,.03,0>,
        Oily+y*.1,
        Dir}
      )
    #declare A=A+1;
  #end
#end

//Placing Macro for smoke
#macro Add_AgedSmoke(Pos,Dir,Size,Age,Born)
  Particle_Add("particles/smoke28",
    array[5]{
    <0,Age,Born+clock*Animation_Time>,
    <20,Size,0>,
    Pos,
    Dir,
    <rand(SmokeRand),rand(SmokeRand),rand(SmokeRand)>
    })
#end

#declare SmallSmokeTrails = 5;
#declare SmSmoke = Load_Array("ufo/smoke.arr");

//Creates "aged" Smoke to have smoke when the scene starts
#if (frame_number=1)
  #declare A=0;
  #while (A<63)
    //Main Smoke-Column by UFO
    Add_AgedSmoke(UFO_Pos+<-4,-1,0>,<0,35,0>,1.5,2.5,-A/25)
    Add_AgedSmoke(UFO_Pos+<-4,-1,0>,<0,35,0>,1.5,2.5,-A/25-clock_delta*Animation_Time/2)
    //Small Smoke-Trails
    #declare B=0;
    #while (B<SmallSmokeTrails)
      Add_AgedSmoke(SmSmoke[B+9],<0,15,0>,.1,1,-A/25)
      #declare B=B+1;
    #end
    #declare A=A+1;
  #end
#end

//Generated per frame:
#declare A=0;
#while (A<1)
  //Main Smoke-Column by UFO
  Add_AgedSmoke(UFO_Pos+<-4,-1,0>,<0,35,0>,1.5,2.5,0)
  Add_AgedSmoke(UFO_Pos+<-4,-1,0>,<0,35,0>,1.5,2.5,-clock_delta*Animation_Time/2)
  //Small Smoke-Trails
  #declare B=0;
  #while (B<SmallSmokeTrails)
    Add_AgedSmoke(SmSmoke[B+9],<0,15,0>,.1,1,0)
    #declare B=B+1;
  #end
  #declare A=A+1;
#end

//Run the particle-simulation
Parsys_Run()
//The visible part of the smoke is lit via a lightgroup, as the lighting
// calculations for the particles skyrocket when the shadow-part throws
// shadows onto the visible part.
light_group{
  light_source{vnormalize(Desert_SunPos)*1750 rgb 1 shadowless}
  union{
    Show_Particles("particles/smoke28","SmokeTrail_Particle")
    pigment{rgb x}
  }
  global_lights off
}

Show_Particles("particles/sparks28","Spark_Particle")
blob{threshold .2 
  Show_Particles("particles/oil28","Oil_Particle")
  sphere{0,1,1 translate -20}
  hollow
  pigment{rgbt 0 transmit .85}
  pigment{rgbft <.2,1,.3,.4,.6>}
  #if (Preview)
    pigment{rgb 1}
  #end
  interior{
    ior 1.65
    fade_power 2 fade_distance .15 fade_color <.2,1,.3>*.25
  }
  finish{
    specular 1 roughness .005
  }
}
