// Persistence of Vision Ray Tracer Scene Description File
// File: ufo_mesh.inc
// Vers: 3.5
// Desc: Basic UFO-Object 
// Date: 14.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 08.10.04 (dd.mm.yy)

//Homepage:
// www.nolights.de
//Email:
// Tim.Nikias(@)nolights.de

#ifndef (_mmm_inc_tnw) #include "mmm.inc" #end
#ifndef (_x_over_inc_tnw) #include "x_over.inc" #end
#ifndef (_io_macs_inc_tnw) #include "io_macs.inc" #end
#ifndef (_bsplines_inc_tnw) #include "bsplines.inc" #end

global_settings{
  assumed_gamma 1
}

#macro Cubisize(_Current)
  #local _Return = 3*(1-_Current)*pow(_Current,2)+pow(_Current,3);
  max(min(_Return,1),0)
#end

#debug "\nCalculating UFO-meshes...\n"

//============================
// UFO-Meshes (good condition)
//============================
// Top-Section
#declare UFO_Surface_BSpline = array[4]
  {
    <0,.75,-1>,<0,1,0>,
    <0,0,-3.5>,<0,0,2>,
  }

//Rear hump
#declare UFO_Surface_Displacement=array[8]
  {
    <0,0,0>,<0,0,0>,
    <.0005,1,0>,<0,0,0>,
    <.001,0,0>,<0,0,0>,
    <1,0,0>,<0,0,0>,
  }
#macro _Uneven_Calc_Macro(X,Z,Val)
  #declare Val=0;
  #local D=BSpline_Pos(UFO_Surface_Displacement,X);
  #local M=(.1-abs(Z-.5))/.1;
  #if (Z>.4 & Z<.6)
    #declare Val=sqrt(M)*M*D.y;
  #end
#end

#declare UFO_Surface_Nodes = BSpline_Lathe(UFO_Surface_BSpline,60,80);
Uneven_Translate_Mesh_Dat(UFO_Surface_Nodes,<0,.8,-.65>)
//Scaling to an egg-shape, but keeping cockpit region spherical
#declare A=0;
#while (A<dimension_size(UFO_Surface_Nodes,1))
  #declare B=0;
  #while (B<dimension_size(UFO_Surface_Nodes,2))
    #declare _CurrentNode=UFO_Surface_Nodes[A][B];
    #if (_CurrentNode.z<0)
      //Check the cylindrical axis
      #declare _CurrentNode=_CurrentNode*<1,0,1>;
      #if (vlength(_CurrentNode)>1 & vlength(_CurrentNode)<1.3)
        #declare _Intensity=(vlength(_CurrentNode)-1)/.3;
      #end      
      #if (vlength(_CurrentNode)<=1)
        #declare _Intensity=0;
      #end
      #if (vlength(_CurrentNode)>=1.3)
        #declare _Intensity=1;
      #end
      #declare UFO_Surface_Nodes[A][B]=UFO_Surface_Nodes[A][B]*<1,1,1+_Intensity*.5>;
    #end
    #declare B=B+1;
  #end
  #declare A=A+1;
#end
#declare UFO_Surface_Normals = Make_Normals(UFO_Surface_Nodes);
Average_Rim_Normals(UFO_Surface_Normals,z)
#debug " -Completed Top-Mesh/Good...\n"
Write_Smooth_Mesh(UFO_Surface_Nodes,UFO_Surface_Normals,"ufo/ufo_top.msh")
#debug " -Saved Top-Mesh/Good...\n"

#declare UFO_Surface_Nodes_Low = BSpline_Lathe(UFO_Surface_BSpline,20,10);
Uneven_Translate_Mesh_Dat(UFO_Surface_Nodes_Low,<0,.8,-.65>)
//Scaling to an egg-shape, but keeping cockpit region spherical (Low-Poly)
#declare A=0;
#while (A<dimension_size(UFO_Surface_Nodes_Low,1))
  #declare B=0;
  #while (B<dimension_size(UFO_Surface_Nodes_Low,2))
    #declare _CurrentNode=UFO_Surface_Nodes_Low[A][B];
    #if (_CurrentNode.z<0)
      //Check the cylindrical axis
      #declare _CurrentNode=_CurrentNode*<1,0,1>;
      #if (vlength(_CurrentNode)>1 & vlength(_CurrentNode)<1.3)
        #declare _Intensity=(vlength(_CurrentNode)-1)/.3;
      #end      
      #if (vlength(_CurrentNode)<=1)
        #declare _Intensity=0;
      #end
      #if (vlength(_CurrentNode)>=1.3)
        #declare _Intensity=1;
      #end
      #declare UFO_Surface_Nodes_Low[A][B]=UFO_Surface_Nodes_Low[A][B]*<1,1,1+_Intensity*.5>;
    #end
    #declare B=B+1;
  #end
  #declare A=A+1;
#end
#declare UFO_Surface_Normals_Low = Make_Normals(UFO_Surface_Nodes_Low);
Average_Rim_Normals(UFO_Surface_Normals_Low,z)
#debug " -Completed Top-Mesh/Low-Poly...\n"
Write_Smooth_Mesh(UFO_Surface_Nodes_Low,UFO_Surface_Normals_Low,"ufo/ufo_tlow.msh")
#debug " -Saved Top-Mesh/Low-Poly...\n"

#debug " -Started destroyed Top (takes some time...)\n"

//Destroyed Condition
#declare UFO_Surface_Nodes_High = BSpline_Lathe(UFO_Surface_BSpline,140,200);
Uneven_Translate_Mesh_Dat(UFO_Surface_Nodes_High,<0,.8,-.65>)
//Scaling to an egg-shape, but keeping cockpit region spherical (High Poly for destroyed hull)
#declare A=0;
#while (A<dimension_size(UFO_Surface_Nodes_High,1))
  #declare B=0;
  #while (B<dimension_size(UFO_Surface_Nodes_High,2))
    #declare _CurrentNode=UFO_Surface_Nodes_High[A][B];
    #if (_CurrentNode.z<0)
      //Check the cylindrical axis
      #declare _CurrentNode=_CurrentNode*<1,0,1>;
      #if (vlength(_CurrentNode)>1 & vlength(_CurrentNode)<1.3)
        #declare _Intensity=(vlength(_CurrentNode)-1)/.3;
      #end      
      #if (vlength(_CurrentNode)<=1)
        #declare _Intensity=0;
      #end
      #if (vlength(_CurrentNode)>=1.3)
        #declare _Intensity=1;
      #end
      #declare UFO_Surface_Nodes_High[A][B]=UFO_Surface_Nodes_High[A][B]*<1,1,1+_Intensity*.5>;
    #end
    #declare B=B+1;
  #end
  #declare A=A+1;
#end


#declare None = pigment{rgb 0}
#declare Much = pigment{bozo color_map{[0 rgb .5][1 rgb 1]}scale .2}

#declare Broken_Pigment =
  pigment{
    planar
    //color_map{[0 rgb 0][1 rgb 1]}
    pigment_map{[0 None][1 Much]}
    poly_wave 1.5
    turbulence .7 omega .5 lambda 2.5 octaves 8
    //scale .2
    rotate z*90 scale <6,2,2> translate -x*3.75 
  }

#declare Broken_Function = function{pigment{Broken_Pigment}}


#declare Red_Pigment =
  pigment{
    bozo color_map{[0 rgb 0][1 rgb x]} scale .2
  }
#declare Green_Pigment =
  pigment{
    bozo color_map{[0 rgb 0][1 rgb y]} scale .2 translate <23,64,21>
  }
#declare Blue_Pigment =
  pigment{
    bozo color_map{[0 rgb 0][1 rgb z]} scale .2 translate <86,23,85>
  }

#declare Red_Function = function{pigment{Red_Pigment}}
#declare Green_Function = function{pigment{Green_Pigment}}
#declare Blue_Function = function{pigment{Blue_Pigment}}

//Create destroyed top-surface
#declare A=0;
#while (A<dimension_size(UFO_Surface_Nodes_High,1))
  #declare B=0;
  #while (B<dimension_size(UFO_Surface_Nodes_High,2))
    
    //#declare UFO_Surface_Nodes
    #declare _Cur = UFO_Surface_Nodes_High[A][B];
    #declare _Cx = _Cur.x;
    #declare _Cy = _Cur.y;
    #declare _Cz = _Cur.z;
    
    #declare BegLine=20/90*dimension_size(UFO_Surface_Nodes_High,1);
    #declare EndLine=40/90*dimension_size(UFO_Surface_Nodes_High,1);

    #if (A<=BegLine)
      #declare UFO_Surface_Nodes_High[A][B] = _Cur-y*.8*Broken_Function(_Cx,_Cy,_Cz).gray*Cubisize(A/BegLine);
    #end
    #if (A>BegLine & A<EndLine)
      #declare UFO_Surface_Nodes_High[A][B] = _Cur-y*.8*Broken_Function(_Cx,_Cy,_Cz).gray;
    #end
    #if (A>=EndLine & A<=EndLine+25/90*dimension_size(UFO_Surface_Nodes_High,1))
      #declare UFO_Surface_Nodes_High[A][B] = _Cur-y*.8*Broken_Function(_Cx,_Cy,_Cz).gray*(1-Cubisize( (A-EndLine)/(25/90*dimension_size(UFO_Surface_Nodes_High,1)) ));
    #end

    #declare B=B+1;
  #end
  #declare A=A+1;
#end
#declare UFO_Surface_Normals_High = Make_Normals(UFO_Surface_Nodes_High);
Average_Rim_Normals(UFO_Surface_Normals_High,z)

#debug " -Completed Top-Mesh/Destroyed...\n"
Write_Smooth_Mesh(UFO_Surface_Nodes_High,UFO_Surface_Normals_High,"ufo/ufo_tdst.msh")
#debug " -Saved Top-Mesh/Destroyed...\n"

// Base/Floor (good condition)
//=============================
#declare UFO_Base_BSpline = array[6]
  {
    <0,0,-3.35>,<0,0,-2>,
    <0,-.7,-1.8>,<0,-.125,.5>
    <0,-1.25,0>,<0,0,1>,
  }
//Saves position for the lights
#declare UFO_BaseLight_Pos = BSpline_Pos(UFO_Base_BSpline,.3);
Save_Value(UFO_BaseLight_Pos,"ufo/ufo_lite.vec")

#declare UFO_Base_Nodes = BSpline_Lathe(UFO_Base_BSpline,60,60);
#declare UFO_Base_Nodes_Low = BSpline_Lathe(UFO_Base_BSpline,20,10);

//Scaling the front-half of the base
#local A=0;
#while (A<dimension_size(UFO_Base_Nodes,1))
  #local B=0;
  #while (B<dimension_size(UFO_Base_Nodes,2))
    #if (UFO_Base_Nodes[A][B].z<0)
      #declare UFO_Base_Nodes[A][B]=UFO_Base_Nodes[A][B]*<1,1,1.5>;
    #end
    #local B=B+1;
  #end
  #local A=A+1;
#end

//Scaling the front-half of the base (Low-Poly)
#declare A=0;
#while (A<dimension_size(UFO_Base_Nodes_Low,1))
  #declare B=0;
  #while (B<dimension_size(UFO_Base_Nodes_Low,2))
    #if (UFO_Base_Nodes_Low[A][B].z<0)
      #declare UFO_Base_Nodes_Low[A][B]=UFO_Base_Nodes_Low[A][B]*<1,1,1.5>;
    #end
    #declare B=B+1;
  #end
  #declare A=A+1;
#end

#declare UFO_Base_Normals = Make_Normals(UFO_Base_Nodes);
#declare UFO_Base_Normals_Low = Make_Normals(UFO_Base_Nodes_Low);
Average_Rim_Normals(UFO_Base_Normals,z)
Average_Rim_Normals(UFO_Base_Normals_Low,z)

#debug " -Completed Base-Mesh/Good & Low-Poly...\n"
Write_Smooth_Mesh(UFO_Base_Nodes,UFO_Base_Normals,"ufo/ufo_base.msh")
Write_Smooth_Mesh(UFO_Base_Nodes_Low,UFO_Base_Normals_Low,"ufo/ufo_blow.msh")
#debug " -Saved Base-Mesh/Good & Low-Poly...\n"

//Destroying Base mesh for Missile Hit
#declare Destruction_Point = <1.5,-.7,-.3>;
Save_Value(Destruction_Point,"ufo/ufo_hit.vec")

#declare Noise_Pigment =
  pigment{
    bozo poly_wave 2 color_map{[0 rgb 0][1 rgb 1]}
    scale .5
    warp{
      black_hole Destruction_Point,1
      falloff 2
      strength 4
    }
  }

#declare Noise_Function = function{pigment{Noise_Pigment}}

#declare A=0;
#while (A<dimension_size(UFO_Base_Nodes,1))
  #declare B=0;
  #while (B<dimension_size(UFO_Base_Nodes,2))
    #local _Cur = UFO_Base_Nodes[A][B];
    #local _Random = _Cur+vturbulence(2.5,.6,7,_Cur)*.2;
    #local _Dist = vlength(_Random*<1,1,.75>-Destruction_Point);
    #local _Cx = _Random.x;
    #local _Cy = _Random.y;
    #local _Cz = _Random.z;
    #if (_Dist<2)
      #declare UFO_Base_Nodes[A][B] = _Cur+y*pow((2-_Dist)/2,2)*(.5+Noise_Function(_Cx,_Cy,_Cz).gray);
    #end

    #declare B=B+1;
  #end
  #declare A=A+1;
#end

#declare UFO_Base_Normals = Make_Normals(UFO_Base_Nodes);
Average_Rim_Normals(UFO_Base_Normals,z)
#debug " -Completed Base-Mesh/Hit...\n"
Write_Smooth_Mesh(UFO_Base_Nodes,UFO_Base_Normals,"ufo/ufo_bhit.msh")
#debug " -Saved Base-Mesh/Hit...\n"
