// clock: 0...max_clock
// frames: 15 * fps 

#include "colors.inc"  
#include "wagon.inc"
                             
#declare simple_sky = no;
#declare simple_mars = no;
                         
#declare max_clock = 20;
#declare n_wagons = 6;
#declare p0 = <-.8, .7, 0>;

camera {
  location p0
  look_at p0 + 100*z
}   

light_source {
  <-50, 10, -50>
  color White
}

// ----- sky -----
#if (!simple_sky)
  #declare galaxy_seed = 23339;
  #declare galaxy_colouration = 0.6;     
  #declare galaxy_bgstars = false;
  #declare star_count = 10000; 
  #declare star_scale = .5;
  #declare galaxy_intensity = .7; 
  #declare galaxy_pattern_scale = 2; 
  #declare galaxy_rotate = -60 * y;
  #include "Galaxy.inc"
#end  

// ----- mars -----
#if (simple_mars)
  #declare mars_tex =
  texture {
    pigment{Red}
  }
#else
  #declare mars_tex =
  texture {
    pigment {image_map {
      jpeg "../../include/planets/marsmap2k.jpg" 
      map_type 1 interpolate 4
    }} 
    normal {bump_map {
      jpeg "../../include/planets/marsbump2k.jpg" 
      map_type 1 interpolate 4
      bump_size 4
    }}
    finish {
      diffuse .8 
      ambient .1
    }
  }            
#end

sphere {
  0, 11
  texture {mars_tex} 
  rotate 290*y         
  rotate -20*z    
  translate <-12, 0, 100>
}  

// ----- wagons -----
#declare i = 0;
#while (i < n_wagons)                                   

  object {
    wagon       
    scale .04
    rotate -90*y
    translate z*(clock - i)
  }
  #declare i = i + 1;
#end     
