#include "colors.inc"
#include "rand.inc"     
#include "functions.inc"    
#include "wagon.inc"    

#declare max_clock = 20; 

#declare use_wagons = yes;                                   
#declare use_rock_field = yes;   
#declare use_ground = yes;       
#declare use_sky = yes; 

#declare simple_mars_tex = no;
#declare simple_rock_field = no;
#declare simple_ground = no; 
#declare simple_sky = no;           
                                       
#declare mars_color = <.8, .4, .2>*1.5;         
#declare mars_sky_color = <.38, .35, .32>*1.3;
 
#declare mars_tex =
texture {
  # if (simple_mars_tex)
    pigment {color rgb mars_color}
  #else
    pigment {
      bozo
      color_map {               
        [0.0 rgb mars_color*1.6]   
        [0.4 rgb mars_color]  
        [1.0 rgb mars_color/1.6]
      }   
      //scale .5
      turbulence 1
    }                    
    normal {
      wrinkles .2
      turbulence 5
      scale .05
    }
    finish {
      ambient .2
    }      
  #end
}    

#declare sky_tex =
texture {
  pigment {
    gradient y color_map{        
      [0.00 rgb mars_sky_color]
      [0.02 rgb mars_sky_color]
      [0.07 Clear]
      [1.00 Clear]
    } 
    scale 10000
  }
  finish {ambient 1}
  translate -50*y
}
// -------------------------------------------------

#declare fade_out = 0;

#declare fade_duration = 3;
#declare start_fade = max_clock - fade_duration;
#if (clock > start_fade)
  #declare fade_out = (clock-start_fade)/fade_duration;
#end

#declare CameraLocation =
spline {
  natural_spline
  0 <5, 2, -20>  
  2 <0, 3, -25> 
  4 <0, 5, -30>
  6 <0, 8, -35> 
  8 <0, 9, -40>
  10 <0, 10, -50>
}

#declare CameraLookAt =
spline {
  natural_spline     
  0 <0, 0, 0>  
  5 <0, 3, 0> 
  8 <0, 10, 0> 
  11 <0, 20, 0>
  14 <0, 35, 0>
  17 <0, 55, 0>
  20 <0, 80, 0>
}


// -------------------------------------------------

camera {             
  location CameraLocation(clock)    
  look_at CameraLookAt(clock)
  angle 35
}                         

light_source {
  <500, 100, -200>
  color (White+Orange)/1.2
} 

light_source {
  <-2000, 300, -500>
  color Violet/1.5
  shadowless
} 
        
// ----- sky -----
#if (use_sky)
  #if (simple_sky)
    background {
      color rgb mars_sky_color
    }
  #else               
    global_settings {
      ambient_light 1-fade_out
    }
             
    plane {
      -z, -1000  
      texture {sky_tex}
    }
    
    #declare galaxy_seed = 23339;
    #declare galaxy_colouration = 0.6;     
    #declare galaxy_bgstars = false;
    #declare star_count = 10000; 
    #declare star_scale = .5;
    #declare galaxy_intensity = (1-fade_out) * 0.7; 
    #declare galaxy_pattern_scale = 2; 
    #declare galaxy_rotate = -60 * y;
    #include "Galaxy.inc" 
  #end         
#end

// ----- ground -----                     
#if (simple_ground)             
  #declare ground =
  plane {
    y, 0
    texture {mars_tex}
  }         
#else                                          
  #declare hill_height = 4;                    
  #declare hill_distance = 30;
  #declare hill_wavelength = 8;
  
  #declare fHeaviside = function(xx) {.5 + .5*xx/(.000000001 + abs(xx))}
  #declare fExp = function (xx) {1-exp(-xx)}
  #declare fScale = function (xx) {hill_height*fHeaviside(xx)*fExp(xx)} 
  #declare hf = function {y - fScale(z)*f_noise3d(x, 0, z)}
                                
  #declare ground =
  isosurface {
    function { hf(x/hill_wavelength, y, (z-hill_distance)/hill_wavelength) }
    open
    contained_by { 
      box { -100, 100 }
    }                   
    texture {mars_tex}
  }
#end   

#if (use_ground)
  ground
#end  

// ----- rock field   
#if (use_rock_field)
  #declare rock_seed = seed(987345);
  #declare rock_density = 4;
  #declare a = 30;
  
  #declare i = 0; 
  #while (i < rock_density*a*a)                             
    #declare pos = VRand_In_Box(-a*<1,100,1>, a*<1,100,1>, rock_seed);
    #declare pos = trace(ground, pos, -y);
    #declare rot = VRand_In_Box(-180,180,rock_seed);
    #declare siz = <1,.7,1> * (.02 + .15*VRand_In_Box(0, 1, rock_seed));
    #declare col = mars_color/(1+rand(rock_seed))/2;
    
    #if (vlength(pos) != 0)
    object {         
      #if (simple_rock_field)
        sphere {0,1}
      #else
        isosurface {
          function {f_sphere(x, y, z, 1.0) - f_noise3d(x*2, y*2, z*2)/2}
          contained_by {sphere {0, 3}}
        }
      #end                          
      
      texture {
        pigment{color col}
        normal {bumps scale .01}
      } 
      
      transform {
        scale siz
        rotate rot
        translate pos
      }
    }             
    #end
    
    #declare i = i + 1;
  #end
#end  
       
// ----- wagons -----
#declare n_wagons = 6;  
#if (use_wagons)  
  #declare i = 0;
  #while (i < 1 - 1/n_wagons)
    
    #declare r = 5*n_wagons;      
    object {
      wagon        
      translate <3, 0, r>                  
      rotate (45 + i*360)*y
      scale .3
    } 
  
    #declare i = i + 1/n_wagons;
  #end  
#end