#macro do_sky(b)
sky_sphere
{
#declare b=b*1.2;
	pigment
	{
		gradient y
		pigment_map
		{
			[0.0 
				agate
				colour_map
				{
					[0.5 rgb <0.823,0.917,1.0>*b]
					[1.0 White*b]
				}
				scale <1,.3,1>
			]
			[0.5 
				agate
				colour_map
				{
					[0.5 rgb <0.611,0.780,0.980>*b]
					[0.95 rgb <0.780,0.827,0.929>*b]
				}
				scale <1,.3,1>
			]
			[1.0 
				agate
				colour_map
				{
					[0.0 rgb <0.396,0.498,0.643>*b]
					[1.0 rgb <0.498,0.513,0.525>*b]
				}
				scale <1,.3,1>
			]
		}
	}

}
#end

#declare ground_flat =
plane
{ <0,1,0>, -2
	pigment
	{
		function{0.5+(f_bozo(x,y,z)-0.5)/(f_r(x,y,z)/10+0.5)}
		colour_map
		{
			[0.0 rgb <0.1725,0.3333,0.1372>*1.5]
			[1.0 rgb <0.8352,0.9058,0.5137>]
		}
		scale 5
	}
}


#declare fmountain=
function (xx,yy,pat)
{
	clip(
		(1-
			(
				(xx*(2+f_bozo(xx*5,yy*5,xx+yy))-1)*(xx*2-1)+
				(yy*(2+f_bozo(xx*5,yy*5,xx+yy+20))-1)*(yy*2-1)
			)
		)*0.6
		+f_bozo(xx*5,yy*10,0)*0.25
#if( detail <1)
		+f_granite(xx*25,yy*50,0)*0.1
		+f_bozo(xx*125,yy*250,0)*0.05
#end
	,0,1)*0.8
}

#declare mountain=
height_field
{
#if (detail <1)
	function 128,256 {fmountain(x,y,0.0)}
	smooth
#else
	function 32,64 {fmountain(x,y,0.0)}
#end
	translate <-0.5,0,-0.5>
#if(detail<1)
	texture
	{
		T_Stone44
		scale <.2,.1,.1>
	}
#else
	pigment {Gray50}
#end
}

#declare ground =
union
{
#if(detail<1)
	plane{<0,1,0>, -1 texture {T_Stone44 scale 200}}
	height_field
	{
		function 256,256 {f_bozo(x*100,y*100,z)/(1+f_r(x,y,z)/20)}
		smooth
		translate <-0.5,-1,-0.5>
		scale <500,1,500>
		pigment
		{
			function{0.5+(f_bozo(x,y,z)-0.5)/(f_r(x,y,z)/10+0.5)}
			colour_map
			{
				[0.0 rgb <0.1725,0.3333,0.1372>*1.5]
				[1.0 rgb <0.8352,0.9058,0.5137>]
			}
			scale 5
		}
	}
#else
	object {ground_flat}
#end

	object{mountain scale <500,100,1000> translate <350,-40,0>}
	object{mountain scale <500,100,1000> translate <-350,-40,0>}
	object{mountain rotate <0,90,0> scale <1000,100,500> translate <0,-40,-350>}
	object{mountain rotate <0,90,0> scale <1000,100,500> translate <0,-40,350>}

}



#macro debris(dcount)
union
{
#local i=0;
#while(i<dcount)
#declare rx=f_snoise3d(i,0,10)*f_snoise3d(i,20,10)*750;
#declare rz=f_snoise3d(i,0,20)*f_snoise3d(i,30,5)*750;
#if(((rx*rx)>(18*18))|((rz*rz)>(18*18)))
#declare rp=clip(f_bozo(i,10,10)*12.5-6,1,6);
#declare rc=clip(f_bozo(i,20,10)*100-50,3,4);

#declare vec=trace(ground,<rx,5,rz>,<0,-1,0>);

object {peice(int(rp),int(rc),0) translate <0,-1.25,0> rotate <f_bozo(i,30,30)*120,f_bozo(i,30,60)*1360,f_bozo(i,30,90)> translate vec}

#end
#local i=i+1;
#end
}
#end

