// $Header: /home/bmh/irtc/RCS/sc002.pov,v 1.9 2005/03/22 14:32:16 bmh Exp $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=002;
#include "camera.inc"

#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

light_source { <-100,500,-300> color rgb 1.49 }

#declare moven=5;

object{ground}
do_sky(0.75)

object{board(0)}
object{debris(500)}

#declare bpos=ppos[moven-1];

#declare v1=posn(fromy[moven],fromx[moven]);
#declare v2=posn(toy[moven],tox[moven]);

#if(int(moved[moven])=3)
#declare vt=tpos2(v1,v2,<0,1.75,0>,0.1,0.5,clock)
#else
#declare vt=tpos(v1,v2,0.1,0.5,clock)
#end

#macro peice3(pn,cv,rv,tv)
object
{
		peice2(pn,0)
		translate -cv
		rotate rv
		translate cv
		translate tv
}
#end

#declare bpos[fromx[moven]][fromy[moven]]=0.0;

#if(capture[moven]>0.0)
#if(clock>0.382)
	#declare pn=bpos[tox[moven]][toy[moven]];
	#declare bpos[tox[moven]][toy[moven]]=0.0;
	#declare p1=posn(toy[moven],tox[moven]);
	#declare pclock=interval(clock,0.35,0.9);
#declare c2=<0,1.25,0>;
#declare r2=<-200*pclock,60*pclock,45*pclock>;
#declare p2=(p1-<1.5,3.5*pclock,-10>*pclock);
	peice3(pn,c2,r2,p2)

//	glow2(pn,c2,r2,p2)

	glow(p2*<1,0,1>+<0,0.001,0>,(pclock+0.1)*(1-pclock*1.1)*3,pclock)
#end
#end

object{peice2(moved[moven],0) translate vt}


disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
//#declare campos= tpos2(scamvec,ecamvec,mcamvec,0,1,clock)
//#declare lapos= tpos(svpvec,evpvec,0,1,clock)
#declare campos=camposspl(clock+sceneno);
#declare lapos=camlookspl(clock+sceneno);
	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=lpos(sapno,eapno,0,1,clock)
	aperture ap
#if(detail<1)
	blur_samples 128
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end


