// $Header: /home/bmh/irtc/RCS/sc013.pov,v 1.5 2005/03/17 17:43:33 bmh Exp $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=013;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"

global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

light_source { <-100,500,-300> color rgb 1.49 }


// TODO move sky sphere and plane to include file 

do_sky(0.75)

object {ground}

camera
{
	right <image_width/image_height,0,0>
//#declare campos= tpos2(scamvec,ecamvec,mcamvec,0,1,clock)
//#declare lapos= tpos(svpvec,evpvec,0,1,clock)
#declare campos=camposspl2(clock+sceneno);
#declare lapos=camlookspl2(clock+sceneno);
	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=lpos(sapno,eapno,0,1,clock)
	aperture ap
#if(detail<1)
	blur_samples 128
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

object{board(0)}
object{debris(500)}

#declare moven=27;
#declare mclock=clock;

#if(moven>0.0)

#declare v1=posn(fromy[moven],fromx[moven]);
#declare v2=posn(toy[moven],tox[moven]);
#if(int(moved[moven])=3)
#declare vt=tpos2(v1,v2,<0,1.75,0>,0.1,0.9,mclock)
#else
#declare vt=tpos(v1,v2,0.1,0.9,mclock)
#end

#declare bpos=ppos[moven-1];

#declare bpos[fromx[moven]][fromy[moven]]=0.0;

#if(capture[moven]>0.0)
#if(mclock>0.5)
#declare bpos[tox[moven]][toy[moven]]=0.0;
#end
#end

object{peice2(moved[moven],0) translate vt}

#else
#declare moven=0;
#declare bpos=ppos[moven];
#end

disp_board(bpos)

#if(detail>1)
object{thing translate lapos}
#end


