// $Header: /home/bmh/irtc/RCS/sc016.pov,v 1.7 2005/03/28 07:28:02 bmh Exp bmh $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=016;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

#declare la=interval(clock,0.0,0.05);

light_source { <-100,500,-300> color rgb 1.49*la }

#declare moven=30;

object{ground}
do_sky(0.75*la)

object{board(0)}
object{debris(500)}

#declare bpos=ppos[moven-1];

disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
//#declare campos= tpos2(scamvec,ecamvec,mcamvec,0,1,clock)
//#declare lapos= tpos(svpvec,evpvec,0,1,clock)
//#declare campos=camposspl2(clock+sceneno);
//#declare lapos=camlookspl2(clock+sceneno);
#declare campos=<11,5,25>+clock*<-6,0,-5>;

#declare lclock=interval(clock,0.1,1.0);
#declare lapos=<7,5,12>+<-10,0,-24>*ccurve(lclock);
#if(clock>0.5)
#declare lapos=lapos+<-1,-3,-4>*scurve((clock-0.5)*2);
#end
	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=2-1.25*scurve(clock);
	aperture ap
#if(detail<1)
	blur_samples 256*ap
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end



