#declare rttn = function(prval) { 360 * prval } 

#macro icecube(tx, ty, tz, rt)
  superellipsoid {
    <.25, .25>
    pigment {
      rgbf <1, 1, 1, 0.9>
    }
    normal {
      bozo 1
    }                 
    interior {
      ior 1.3
    }              
    scale .04
    translate <tx, ty, tz>
    rotate rt*y
    photons {
      target
      refraction on
    }
  }
#end

// Bottom Layer

#declare brt = 0;

#declare a = 1.853;
#declare b = 2.307;
#declare c = 2.546;
#declare d = 3.454;
#declare e = 3.692;
#declare f = 4.147;

#if (clock >= a & clock <= b)
#declare brt = rttn(clock-a);
#end

#if (clock >= b & clock <= c)
#declare brt = rttn(b-a);
#end

#if (clock >= c & clock <= d)
#declare brt = rttn(clock-c) + rttn(b-a);
#end

#if (clock >= d & clock <= e)
#declare brt = rttn(d-c) + rttn(b-a);
#end

#if (clock >= e & clock <= f)
#declare brt = rttn(clock-e) + rttn(d-c) + rttn(b-a);
#end

#if (clock >= f)
#declare brt = rttn(f-e) + rttn(d-c) + rttn(b-a);
#end

object {
  icecube(-0.05, 3.1, -0.01, brt)
}

object {
  icecube(0.05, 3.1, -0.01, brt)
}

// 1st Layer Up

#declare rt1 = 0;

#declare a = 1.822;
#declare b = 4.178;

#if (clock >= a & clock <= b)
#declare rt1 = rttn(clock-a);
#end

#if (clock >= b)
#declare rt1 = rttn(b-a);
#end

object {
  icecube(0.05, 3.18, 0.02, rt1)
}

object {
  icecube(-0.05, 3.18, 0.02, rt1)
}

object {
  icecube(0, 3.18, -0.06, rt1)
}

// 2nd Layer Up

#declare rt2 = 0;

#declare a = 1.797;
#declare b = 4.203;

#if (clock >= a & clock <= b)
#declare rt2 = rttn(clock-a);
#end

#if (clock >= b)
#declare rt2 = rttn(b-a);
#end

object {
  icecube(-0.07, 3.26, -0.01, rt2)
}

object {
  icecube(0.07, 3.26, -0.01, rt2)
}

object {
  icecube(-0.01, 3.26, -0.07, rt2)
}

object {
  icecube(-0.01, 3.26, 0.07, rt2)
}
