#include "quaternion.inc"

#declare NOHAIR=1;

#include "hair.inc"

#macro ANT_BODY_TEXTURES()
	texture {
		pigment {color rgb<0.1,0,1>}
		finish{ambient 0.5 diffuse 0.5}
	}
	texture {
		pigment {color rgbt<0.9,0.2,0.05,0.1>}
		finish{
			ambient 0.0
			diffuse 0.4
			specular 1
			roughness 0.02
			reflection {rgb<0.6,0.2,0.05>*0.1}
		}
		//normal { bumps .01 scale 0.2 }
		normal { bumps .2 scale 0.2 }
	}
#end

#declare R1=seed(100);

#declare ant_body_center_shape=isosurface{
	function{ pow( pow(abs(0.7*x),3)+pow(abs(y),2)+pow(abs(z),2),0.5)-1 }
	contained_by { box{-2, 2} }
}
#declare ant_body_center=union{
	object {ant_body_center_shape ANT_BODY_TEXTURES()}
	MAKE_HAIR_SPHERICAL(ant_body_center_shape, 200, <0,0,0>, 0.2)
}

#declare ant_body_upper_shape=isosurface{
	function{ pow( pow(abs(0.6*x),3)+pow(abs(0.9*y),2)+pow(abs(0.9*z),2),0.5)-1 }
	contained_by { box{-2, 2} }
	rotate z*15
}
#declare ant_body_upper=union{
	object {ant_body_upper_shape ANT_BODY_TEXTURES()}
	MAKE_HAIR_SPHERICAL(ant_body_upper_shape, 200, <0,0,0>, 0.2)
	translate<1/0.6,0.5,0>
}

#declare ant_body_connector=isosurface{
	function{ pow( pow(abs(1*x),2)+pow(abs(1*y),2)+pow(abs(1*z),2),0.5)-0.5 }
	contained_by {box{-1,1} }
	translate<-0.3,0,0>
	ANT_BODY_TEXTURES()
}

#declare ant_body_lower_shape=isosurface{
	function{
		sqrt(
			pow(abs(0.7*x),2)+pow(abs(y+0.1*x),2)+pow(abs(z),1.5)
		)
		-1.3
		-0.25*x
		-0.6*y
	}
	max_gradient 4
	contained_by {box{-8,8} }
}
#declare ant_body_lower=union{
	object {ant_body_lower_shape ANT_BODY_TEXTURES()}
	MAKE_HAIR_SPHERICAL(ant_body_lower_shape, 200, <0,0,0>, 0.2)
	translate<-3.6,-0.7,0>
}


#declare leg1_segment1=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 1,
	<0,-0.5,1>, 0.4
	ANT_BODY_TEXTURES()
}
#declare leg1_segment2_shape=sphere_sweep {
	cubic_spline 4,
	<0,-4.5,-5>, 0.1,
	<0,-0,0>, 0.15,
	<2,1.5,2>, 0.25,
	<3,1.5,3>, 0.1
	tolerance 0.1
}
#declare leg1_segment2=union{
	object {leg1_segment2_shape ANT_BODY_TEXTURES()}
	MAKE_HAIRY_LEG(leg1_segment2_shape, <0,0,0>, <2,1.5,2>)
}
#declare leg1_segment3_shape=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 0.15,
	<1,-3,1>, 0.25
}
#declare leg1_segment3=union{
	object {leg1_segment3_shape ANT_BODY_TEXTURES()}
	MAKE_HAIRY_LEG(leg1_segment3_shape, <0,0,0>,<1,-3,1>)
}
#declare leg1_segment4_shape=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 0.15,
	<2,-1,1>, 0.1
}
#declare leg1_segment4=union{
	object {leg1_segment4_shape ANT_BODY_TEXTURES()}
	MAKE_HAIRY_LEG(leg1_segment4_shape, <0,0,0>, <2,-1,1>)
}

#declare leg2_segment1=sphere_sweep {
	linear_spline 2,
	<0,0.05,0>, 0.95,
	<0.8,0.2,1>, 0.4
	ANT_BODY_TEXTURES()
}
#declare leg2_segment2_shape=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 0.15,
	<0.2,0.8,2.5>, 0.25
}
#declare leg2_segment2=union{
	object {leg2_segment2_shape ANT_BODY_TEXTURES()}
	MAKE_HAIRY_LEG(leg2_segment2_shape, <0,0,0>, <0.2,0.8,2.5>)
}
#declare leg2_segment3_shape=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 0.15,
	<0.5,-3.6,1>, 0.25
}
#declare leg2_segment3=union{
	object {leg2_segment3_shape ANT_BODY_TEXTURES()}
	MAKE_HAIRY_LEG(leg2_segment3_shape, <0,0,0>, <0.5,-3.6,1>)
}
#declare leg2_segment4_shape=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 0.15,
	<0.5,-0.4,1.5>, 0.1
}
#declare leg2_segment4=union{
	object {leg2_segment4_shape ANT_BODY_TEXTURES()}
	MAKE_HAIRY_LEG(leg2_segment4_shape, <0,0,0>, <0.5,-0.4,1.5>)
}

#declare leg3_segment1=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 0.95,
	<-0.8,-0.4,1>, 0.4
	ANT_BODY_TEXTURES()
}
#declare leg3_segment2_shape=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 0.15,
	<-1.2,1.4,2>, 0.25
}
#declare leg3_segment2=union{
	object {leg3_segment2_shape ANT_BODY_TEXTURES()}
	MAKE_HAIRY_LEG(leg3_segment2_shape, <0,0,0>, <-1.2,1.4,2>)
}
#declare leg3_segment3_shape=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 0.15,
	<-1,-3,1>, 0.25
}
#declare leg3_segment3=union{
	object {leg3_segment3_shape ANT_BODY_TEXTURES()}
	MAKE_HAIRY_LEG(leg3_segment3_shape, <0,0,0>, <-1,-3,1>)
}
#declare leg3_segment4_shape=sphere_sweep {
	linear_spline 2,
	<0,0,0>, 0.15,
	<-2,-1,2>, 0.1
}
#declare leg3_segment4=union{
	object {leg3_segment4_shape ANT_BODY_TEXTURES()}
	MAKE_HAIRY_LEG(leg3_segment4_shape, <0,0,0>, <-2,-1,2>)
}

#declare ant_mandible=sphere_sweep {
	cubic_spline 4,
	<-1,0,1>, 0.6,
	<0,0,1>, 0.6,
	<0.7,0,0.1>, 0.1,
	<0.9,0,-2>, 0.0
	tolerance 0.1
	
	scale<1,0.1,1>
	texture {
		pigment {color rgb<0.3,0.3,0.5>}
		finish{
			ambient 0.0
			diffuse 0.2
			specular 1
			roughness 0.05
			reflection {rgb<0.6,0.2,0.05>*0.1}
		}
	}
}

#declare ant_antenna_segment2_shape=sphere_sweep {
	linear_spline 2,
	<0.5,2,2>,0.2,
	<3,3,3>,0.1
}

#declare ant_antenna_segment2=union {
	object {ant_antenna_segment2_shape ANT_BODY_TEXTURES()}
	MAKE_HAIR_CYLINDRICAL(ant_antenna_segment2_shape, 500, <0.5,2,2>, <3,3,3>,
		<1,0.4,0.4>, 0.1)
}

#declare ant_antenna=union {
	sphere_sweep {
		linear_spline 2,
		<0,0.2,0.2>, 0.1,
		<0.5,2,2>,0.2
		ANT_BODY_TEXTURES()
	}
	object {ant_antenna_segment2}
}

#declare ant_head=union {
	// head
	blob {
		sphere{<0,0,-1>,1.5,1 scale<1,0.75,1>}
		sphere{<0,0,+1>,1.5,1 scale<1,0.75,1>}
		sphere{<0.5,0,0>,1.8,1 scale<1,0.75,1>}
		
		//sphere{<1.2,0,0>,2,-0.3}
		cylinder{<2.6,-2,0>,<2.6,-0.5,0>,1.5,-1}
		
		threshold 0.1
		
		ANT_BODY_TEXTURES()
	}
	// eyes
	union {
		sphere {<0.5,0.3,-1.8>,0.4}
		sphere {<0.5,0.3,+1.8>,0.4}
		texture {
			pigment {color rgb<0.1,0.1,0.1>}
			finish{
				ambient 0.0
				diffuse 0.1
				specular 1
				roughness 0.02
				reflection {rgb<0.6,0.2,0.05>*0.1}
			}
			normal { bumps .2 scale 0.2 }
		}
	}
	
	// mandibles
	object { ant_mandible translate<1.6,0,0>}
	object { ant_mandible translate<1.6,0,0> scale<1,1,-1>}
	
	// antenna
	object { ant_antenna translate<1.5,0,0>}
	object { ant_antenna translate<1.5,0,0> scale<1,1,-1>}
	
	rotate z*-45
}

#macro MAKE_ANT()
union {
	object {ant_body_center}
	union {
		union {
			object {ant_body_upper}
			object {
				ant_head
				transform {T_HEAD}
				translate<4,1,0>
			}
		}
		
		union {
			object {leg1_segment1}
			union {
				object {leg1_segment2}
				union {
					object {leg1_segment3}
					object {
						leg1_segment4
						transform { T_LL14 }
						translate <1,-3,1>
					}
					transform { T_LL13 }
					translate <2,1.5,2>
				}
				transform { T_LL12 }
				translate <0,-0.5,1>
			}
			translate <1,0,0>
		}
		union {
			object {leg1_segment1}
			union {
				object {leg1_segment2}
				union {
					object {leg1_segment3}
					object {
						leg1_segment4
						transform { T_RL14 }
						translate <1,-3,1>
					}
					transform { T_RL13 }
					translate <2,1.5,2>
				}
				transform { T_RL12 }
				translate <0,-0.5,1>
			}
			translate <1,0,0>
			scale<1,1,-1>
		}
		
		transform{ T_UPPER }
		translate<1.4,0,0>
	}
	/* two leg pairs protrude from the body center */
	union {
		object {leg2_segment1}
		union {
			object {leg2_segment2}
			union {
				object {leg2_segment3}
				object {
					leg2_segment4
					transform { T_LL24 }
					translate <0.5,-3.6,1>
				}
				transform { T_LL23 }
				translate <0.2,0.8,2.5>
			}
			transform { T_LL22 }
			translate <0.8,0.2,1>
		}
	}
	union {
		object {leg2_segment1}
		union {
			object {leg2_segment2}
			union {
				object {leg2_segment3}
				object {
					leg2_segment4 
					transform { T_RL24 }
					translate <0.5,-3.6,1>
				}
				transform { T_RL23 }
				translate <0.2,0.8,2.5>
			}
			transform { T_RL22 }
			translate <0.8,0.2,1>
		}
		scale<1,1,-1>
	}
	
	union {
		object {leg3_segment1}
		union {
			object {leg3_segment2}
			union {
				object {leg3_segment3}
				object {
					leg3_segment4
					transform { T_LL34}
					translate <-1,-3,1>
				}
				transform { T_LL33}
				translate <-1.2,1.4,2>
			}
			transform { T_LL32}
			translate <-0.8,-0.4,1>
		}
	}
	
	union {
		object {leg3_segment1}
		union {
			object {leg3_segment2}
			union {
				object {leg3_segment3}
				object {
					leg3_segment4 
					transform { T_RL34 }
					translate <-1,-3,1>
				}
				transform { T_RL33 }
				translate <-1.2,1.4,2>
			}
			transform { T_RL32 }
			translate <-0.8,-0.4,1>
			scale <1,1,-1>
		}
	}
	
	union {
		object {ant_body_connector}
		object {ant_body_lower translate<-0.3,0,0>}
		transform { T_LOWER }
		translate<-1/0.7,0,0>
	}
	
	translate y*3
	scale 1/8
}
#end