#ifdef (NOHAIR)

#macro MAKE_HAIR_CYLINDRICAL(obj, nhairs, a, b, c, length)
#end

#macro MAKE_HAIR_SPHERICAL(obj, nhairs, center, length)
#end

#macro MAKE_HAIRY_LEG(obj, a, b)
#end

#else

#macro MAKE_HAIR_CYLINDRICAL(obj, nhairs, a, b, c, length)
	#local d=a-b;
	
	#local v1=vnormalize(<d.x*(d.y-d.z), d.y*(d.z-d.x), d.z*(d.x-d.y)>);
	#local v2=vnormalize(vcross(v1, d));
	
	#while (nhairs>0)
		#local rot=rand(R1)*2*pi;
		#local weight=rand(R1);
		
		
		#local center=b+weight*d;
		#local vstart=center+v1*sin(rot)*100+v2*cos(rot)*100;
		
		#local vnorm=<0,0,0>;
		#local i=trace(obj, vstart, center-vstart, vnorm);
		
		#if (vlength(vnorm)>0)
			#local dir=length*vnormalize(vnorm+c)*rand(R1)*2;
			sphere_sweep{
				linear_spline 2,
				i,0.01,
				i+dir,0.0
				pigment{color rgbf<3,3,3,0.2>}
				finish{ambient 0.2 diffuse 0.8}
				no_shadow
			}
			#declare nhairs=nhairs-1;
		#end
	#end
#end

#macro MAKE_HAIR_SPHERICAL(obj, nhairs, center, length)
	#while (nhairs>0)
		#local rot=rand(R1)*2*pi;
		#local weight=rand(R1);
		
		
		#local vstart=vnormalize(<rand(R1)-0.5, rand(R1)-0.5, rand(R1)-0.5>)*100;
		#local vnorm=<0,0,0>;
		#local i=trace(obj, vstart, center-vstart, vnorm);
		
		#if (vlength(vnorm)>0)
			#local dir=length*vnorm*rand(R1)*2;
			sphere_sweep{
				linear_spline 2,
				i,0.01,
				i+dir,0.0
				pigment{color rgbf<3,3,3,0.2>}
				finish{ambient 0.2 diffuse 0.8}
				no_shadow
			}
			#declare nhairs=nhairs-1;
		#end
	#end
#end

#macro MAKE_HAIRY_LEG(obj, a, b)
	MAKE_HAIR_CYLINDRICAL(obj, 200, a, b, vnormalize(b-a), 0.2)
#end

#end