#include "parts.inc"
#include "tubes.inc"
#include "gears.inc"

union {
#local _u=0;
#while (_u<10)
	#local _v=0;
	#while (_v<10)
		cylinder{<_u*10,_v*10,0>,<_u*10,_v*10,100>,STRUT_RADIUS}
		cylinder{<_u*10,0,_v*10>,<_u*10,100,_v*10>,STRUT_RADIUS}
		cylinder{<0,_u*10,_v*10>,<100,_u*10,_v*10>,STRUT_RADIUS}
		#local _v=_v+1;
	#end
	#local _u=_u+1;
#end
	texture {PLASTIC_FRAME}
	translate<-5,-5,-5>
	no_shadow
}

difference {
	box{<-1000,-1000,94.5>,<1000,1000,96>}
	box{<0,58,94>,<90,62,97>}
	texture {PLASTIC_FRAME}
	//no_shadow
}

global_settings { max_trace_level 20 }

fog { rgb <0.75, 0.75, 0.75>*1.2 distance 50.0 }

light_source {
        <1,7,-8>*1000 color rgb 0.8
}

#declare frameno=clock;

#if (frameno>350)
	#if (frameno<360)
	#declare gate1=(frameno-350)/10;
	#else
	#declare gate1=1;
	#end
#else
	#declare gate1=0;
#end

#if (frameno>750)
	#if (frameno<760)
	#declare gate2=(frameno-750)/10;
	#else
	#declare gate2=1;
	#end
#else
	#declare gate2=0;
#end

object {
	MAKE_GATE(gate1, closed_gate)
	translate<30,60,60>
}

object {
	MAKE_GATE(gate2, open_gate)
	translate<60,60,60>
}

#declare residue=clock;
/*#while (residue>30)
	#declare residue=residue-30;
#end*/

#declare REFLECTION=0.3;
#if (clock>=950)
	#declare REFLECTION=0.3-(clock-950)/50*0.3;
#end

object {
	union {
		object {
			//MAKE_GEAR_PARTIAL(1000-90-1,1000-90+0.8, 2094, 0.05, 0.05, 1.5, 100)
			//rotate y*(180+360.0/2094*(residue/30.0+0.68))
			MAKE_GEAR_PARTIAL(1000-90-1,1000-90+0.8, 2000, 0.05, 0.05, 1.5, 100)
			rotate y*(180+360.0/2000*(residue/31.0+0.48))
		}
		cylinder{<0,0,0>,<0,1.5,0>, 1000-90-1}
	}
	pigment {color rgb<1,1,0.5>}
	finish {ambient 0.2 diffuse 0.2 reflection REFLECTION specular 0.9 roughness 0.1}
	translate<60,59.25,1000>
}

#macro smooth_interpolate(v1, v2, t1, t2, tn)
	(-2*pow((tn-t1)/(t2-t1),3)+3*pow((tn-t1)/(t2-t1),2))*v2+
	(-2*pow((t2-tn)/(t2-t1),3)+3*pow((t2-tn)/(t2-t1),2))*v1
#end

/* first camera position: ants walk up to closed door */
#if ((clock>=0) & (clock<300))
camera {
	location smooth_interpolate(<30,54,50>,<20,54,50>,0,300,clock)
	look_at<25,50,60>
}
#end

/* move camera to view trapdoor */
#if ((clock>=300) & (clock<=400))
camera {
	location smooth_interpolate(<20,54,50>,<22,66,48>,300,400,clock)
	look_at smooth_interpolate(<25,50,60>,<30,60,60>,300,400,clock)
}
#end

/* rest view and watch both columns of ants walk */
#if ((clock>=400) & (clock<=500))
camera {
	location <22,66,48>
	look_at <30,60,60>
}
#end

/* close-up of lower column walking */
#if ((clock>=500) & (clock<=600))
camera {
	location smooth_interpolate(<22,66,48>,<46,51.5,57.5>,500,600,clock)
	look_at smooth_interpolate(<30,60,60>,<40,50,60>,500,600,clock)
}
#end

/* continue close-up of lower column walking */
#if ((clock>=600) & (clock<=700))
camera {
	location smooth_interpolate(<46,51.5,57.5>,<50,52,63>,600,700,clock)
	look_at smooth_interpolate(<40,50,60>,<60,50,60>,600,700,clock)
}
#end

/* watch upper column closing gate */
#if ((clock>=700) & (clock<=750))
camera {
	location smooth_interpolate(<50,52,63>,<57,64,63>,700,750,clock)
	look_at smooth_interpolate(<60,50,60>,<60,55,60>,700,750,clock)
}
#end

/* rest view as gate closes */
#if ((clock>=750) & (clock<=800))
camera {
	location <57,64,63>
	look_at <60,55,60>
}
#end

/* turn around to watch ants turning wheel */
#if ((clock>=800) & (clock<=850))
camera {
	location smooth_interpolate(<57,64,63>,<50,65,78>,800,850,clock)
	look_at smooth_interpolate(<60,55,60>,<51,61,90>,800,850,clock)
}
#end

/* zoom in to ants turning wheel */
#if ((clock>=850) & (clock<=900))
camera {
	location smooth_interpolate(<50,65,78>,<50,61.5,91>,850,900,clock)
	look_at smooth_interpolate(<51,61,90>,<55,60,90>,850,900,clock)
}
#end

/* zoom out to only view wheel */
#if ((clock>=900) & (clock<=1000))
camera {
	location <50,61.5,91>+pow((clock-900)/100,2)*<0,0,10>
	look_at <55,60,90>+pow((clock-900)/100,4)*<-5,0,11>
}
#end

#if (clock=2000)
camera {
	location <50,61.5,101>
	look_at <50,60,101>
}
#end

/*
	Blick auf Zahnrad
camera {
	location<50, 65, 80>
	look_at<51, 61, 90>
}
*/
#if (clock>1000)
camera {
	location <57,53,63>
	look_at <60,50,60>
}
#end


#if ((clock>=400) & (clock<=500))
camera {
	location <22,66,48>
	look_at <30,60,60>
}
#end

/*camera {
	location<50, 90+100, 70>
	look_at<50, 60, 70>
}*/

/*camera {
	location<60, 65, 90>
	look_at<60, 60, 90>
}*/

