plane {
	y,0
	pigment { color rgb<0.5,0.25,0>*0.5 }
	normal { bumps scale 10}
	finish{ambient 0.2 diffuse 0.6}
}

#macro MAKE_BLADE(height, g_scale, para_start)
mesh {
#local _X=para_start;
#local w_start=0;

#local Y=height;
#local X=0;
#while (Y>0)
	#local w=(1-1/(w_start+1))*3;
	#local X2=X-1;
	#local Y=height-_X*_X;
	#declare _X=_X+g_scale;
	#local w_start=w_start+0.1;
	#local w2=(1-1/(w_start+1))*3;
	#local Y2=height-_X*_X;
	triangle{<X+0.5,Y,0>,<X,Y,w>,<X2+0.5,Y2,0>}
	triangle{<X,Y,w>,<X2,Y2,w2>,<X2+0.5,Y2,0>}
	
	triangle{<X+0.5,Y,0>,<X,Y,-w>,<X2+0.5,Y2,0>}
	triangle{<X,Y,-w>,<X2,Y2,-w2>,<X2+0.5,Y2,0>}
	#declare X=X2;
	#declare Y=Y2;
#end
		pigment{color rgb<0.2,1.0,0.1>}
		finish{ambient 0.2 diffuse 0.6}
}
#end

MAKE_BLADE(140, 0.1, -1)

#declare R_GRASS=seed(1);

#declare grass_patch=union {
	#local n_blades=200;
	#while (n_blades>0)
	object {
		#local h=50+rand(R_GRASS)*100;
		MAKE_BLADE(h, 0.1+rand(R_GRASS)*0.2, rand(R_GRASS)*2)
		rotate y*rand(R_GRASS)*360
		translate<rand(R_GRASS)-0.5, 0, rand(R_GRASS)-0.5>*200
	}
	#declare n_blades=n_blades-1;
	#end
}

#if (clock>10)
  #declare p_size=8;
#else
  #declare p_size=5;
#end

#local X=-p_size;
#while (X<=p_size)
	#local Y=-p_size;
	#while (Y<=p_size)
		object {grass_patch translate<200*X,0,200*Y>}
		#local Y=Y+1;
	#end
	#local X=X+1;
#end

#declare REFLECTION=0.3;
#if (clock<3)
  #declare REFLECTION=clock*0.1;
  #declare T_GEAR=transform{rotate x*((3-clock)/3)*60}
  #declare T_LL12=transform{rotate -x*((3-clock)/3)*30}
#end
#if ((clock>=8) & (clock<9))
  #declare T_GEAR=transform{rotate x*(clock-8)*60}
  #declare T_LL12=transform{rotate -x*(clock-8)*30}
#end
#if (clock>=9)
  #declare T_GEAR=transform{rotate x*60}
  #declare T_LL12=transform{rotate -x*30}
#end

#include "antmod.inc"

object {MAKE_ANT() rotate y*180  translate <-10,140,0>}

#if (clock>15)
fog { rgb <0.75, 0.75, 0.75>*1.2*0 distance 1000.0/(clock-15) }
#end

camera {
	location<2.4,2.4,0.55>/8+<-0.001/8,0,-0.183/8>
		+<-0.1,0,0>/8*clock
		+<-0.3,0.8,1>*(exp(clock*clock/36)-1)/4
	look_at <2.4,2.4,0.55>/8+<0,0,-0.180/8>
	
	rotate y*180
	translate <-10,140,0>
}

light_source {
	<-10,30,20>*1000 color rgb 1
}

