// lrspiral.pov
#declare effect_type = "Sparkle" 
//Morph the rolling circle radii
#declare splines = array[40];
#declare facs = array[256][4];
#declare elemct = 0;
#declare caaf = -5.0;//Largest circle radius factor
#declare cbaf = -33.0;//Second largest circle radius factor
#declare ccaf = 5.0;//Third largest circle radius factor
#declare cdaf = 13.0;//Smallest circle radius factor
#while (cdaf <= 30)//Produces twisting effect
   #declare facs[elemct][0] = caaf;
   #declare facs[elemct][1] = cbaf;
   #declare facs[elemct][2] = ccaf;
   #declare facs[elemct][3] = cdaf;
   #declare cdaf = cdaf + 1;
   #declare elemct = elemct + 1;
#end
#declare cdaf = 30;
#declare tempct = 0;
#while (tempct <= 2)//Leave the spiral alone for a bit
   #declare facs[elemct][0] = caaf;
   #declare facs[elemct][1] = cbaf;
   #declare facs[elemct][2] = ccaf;
   #declare facs[elemct][3] = cdaf;
   #declare elemct = elemct + 1;
   #declare tempct = tempct + 1;
#end
#while (caaf >= -9)//Produces spinning effect
   #declare facs[elemct][0] = caaf;
   #declare facs[elemct][1] = cbaf;
   #declare facs[elemct][2] = ccaf;
   #declare facs[elemct][3] = cdaf;
   #declare caaf = caaf - 0.5;
   #declare elemct = elemct + 1;
#end
#declare caaf = -9;
#declare tempct = 0;
#while (tempct <= 2)
   #declare facs[elemct][0] = caaf;
   #declare facs[elemct][1] = cbaf;
   #declare facs[elemct][2] = ccaf;
   #declare facs[elemct][3] = cdaf;
   #declare elemct = elemct + 1;
   #declare tempct = tempct + 1;
#end
#while (cbaf <= -26)//Produces gyrating effect
   #declare facs[elemct][0] = caaf;
   #declare facs[elemct][1] = cbaf;
   #declare facs[elemct][2] = ccaf;
   #declare facs[elemct][3] = cdaf;
   #declare cbaf = cbaf + 1;
   #declare elemct = elemct + 1;
#end
#declare cbaf = -26;
#declare tempct = 0;
#while (tempct <= 2)
   #declare facs[elemct][0] = caaf;
   #declare facs[elemct][1] = cbaf;
   #declare facs[elemct][2] = ccaf;
   #declare facs[elemct][3] = cdaf;
   #declare elemct = elemct + 1;
   #declare tempct = tempct + 1;
#end
#while (cdaf >= -31)//Animation ends right about here
   #declare facs[elemct][0] = caaf;
   #declare facs[elemct][1] = cbaf;
   #declare facs[elemct][2] = ccaf;
   #declare facs[elemct][3] = cdaf;
   #declare cdaf = cdaf - 1;
   #declare elemct = elemct + 1;
#end
#declare cdaf = -31;
#declare tempct = 0;
#while (tempct <= 2)
   #declare facs[elemct][0] = caaf;
   #declare facs[elemct][1] = cbaf;
   #declare facs[elemct][2] = ccaf;
   #declare facs[elemct][3] = cdaf;
   #declare elemct = elemct + 1;
   #declare tempct = tempct + 1;
#end
//Interpolate the radius factors for this frame. Separate factors for each spark in a trail make for lively movement of the trail.
#declare curslice = array[40][4];
#declare elemct = 0;
#declare curframe = (frame_number - 1) * 0.05;
#while (elemct < 40)
   #declare curspark = curframe - elemct * 0.05;
   #if (curspark < 0)
      #declare curspark = 0;
   #end
   #declare curslice[elemct][0] = facs[int (curspark)][0] + (facs[int (curspark) + 1][0] - facs[int (curspark)][0]) * (curspark - int (curspark));
   #declare curslice[elemct][1] = facs[int (curspark)][1] + (facs[int (curspark) + 1][1] - facs[int (curspark)][1]) * (curspark - int (curspark));
   #declare curslice[elemct][2] = facs[int (curspark)][2] + (facs[int (curspark) + 1][2] - facs[int (curspark)][2]) * (curspark - int (curspark));
   #declare curslice[elemct][3] = facs[int (curspark)][3] + (facs[int (curspark) + 1][3] - facs[int (curspark)][3]) * (curspark - int (curspark));
   #declare elemct = elemct + 1;
#end
   
  // CAMERA AND EFFECT OPTIONS
   #declare camera_location = <-25, -102, -25>;
   #declare camera_look_at = <0, 0, 0>;
   #declare effect_always_on_top=false;

global_settings{
	adc_bailout 0.0039
	assumed_gamma 1.000
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	radiosity{
		brightness 2.200
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.3
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	}    
}

#declare dens_atten=0.2;
   media  
   {
      intervals 10
      samples 1, 10
      confidence 0.9999
      variance 0.001
      ratio 0.9
      absorption rgb 0.1
      scattering
      {
         1 ,  rgb <0.807, 0.710, 0.420>*0.3 // isotropic scattering
         extinction 1.0
      }
      density
      {
         spherical
         density_map
         {
            [ 0.0    rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
            [ 0.815  rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
            [ 0.815  rgbft <0.004, 0.004, 0.004, 0.0, 0.0>*dens_atten]
            [ 0.860  rgbft <0.015, 0.015, 0.015, 0.0, 0.0>*dens_atten]
            [ 0.905  rgbft <0.062, 0.062, 0.062, 0.0, 0.0>*dens_atten]
            [ 0.950  rgbft <0.25, 0.25, 0.25, 0.0, 0.0>*dens_atten]
            [ 0.995  rgbft <1.0, 1.0, 1.0, 0.0, 0.0>*dens_atten]
            [ 1.0    rgbft <1.0, 1.0, 1.0, 0.0, 0.0>*dens_atten]
         }
         scale <300, 300, 300>
      }
   }
   
//Make separate spline for each spark within a trail.  No need for separate splines for the different trails.
   #declare scalefac = 30;
   #declare spark= 0;
   #while (spark < 40)   
      #declare caf = curslice[spark][0];
      #declare cbf = curslice[spark][1];
      #declare ccf = curslice[spark][2];
      #declare cdf = curslice[spark][3];
      #declare r = 0.7;
      #declare r2 = r / 2;
      #declare r3 = r / 3;
      #declare r4 = r / 4;
      #declare pos = array[1000];
      #declare circa = caf;
      #declare circb = cbf;
      #declare circc = ccf;
      #declare circd = cdf;
      #declare pos[0] = scalefac*<r*sin(circa)+r2*sin(circb)+r3*sin(circc)+r4*sin(circd), r*sin(circc), r*cos(circa)+r2*cos(circb)+r3*cos(circc)+r4*cos(circd)>;
      #declare i = 1;
      #while (i < 100)
   		#declare circa = circa + 0.1137 * caf;
   		#declare circb = circb + 0.1137 * cbf;
   		#declare circc = circc + 0.1137 * ccf;
   		#declare circd = circd + 0.1137 * cdf;
         #declare pos[i] = scalefac*<r*sin(circa)+r2*sin(circb)+r3*sin(circc)+r4*sin(circd), r*sin(circc), r*cos(circa)+r2*cos(circb)+r3*cos(circc)+r4*cos(circd)>;
         #declare i = i + 1;
      #end
      #declare i = 0;
      #declare splines[spark] =
         spline {
            cubic_spline
            #while (i < 100)
               i, pos[i]
               #declare i = i + 1;
            #end
         }
      #declare spark = spark + 1;
   #end
   #if (frame_number < 40)
      text {
         ttf "C:\\Windows\\System32\\tt0628m_.ttf" "Spiral"
         0.2, 0
         pigment { rgb 0.8 }
         finish { ambient 1.2 diffuse 0.2 }
         no_shadow
         scale <16, 16, 1>
         rotate <-40, 45, 22>
         translate <-62, 0, 15>
      }
      text {
         ttf "C:\\Windows\\System32\\tt0628m_.ttf" "Follies"
         0.2, 0
         pigment { rgb 0.8 }
         finish { ambient 1.2 diffuse 0.2 }
         no_shadow
         scale <16, 16, 1>
         rotate <-40, 40, 20>
         translate <-10, 0, -38>
      }
   #end
   #if (frame_number > 39 & frame_number < 49)
      text {
         ttf "C:\\Windows\\System32\\tt0628m_.ttf" "Spiral"
         0.2, 0
         pigment { rgb 0.8 }
         finish { ambient 0.12 * (49 - frame_number) diffuse 0.2 }
         no_shadow
         scale <16, 16, 1>
         rotate <-40, 45, 22>
         translate <-62, 0, 15>
      }
      text {
         ttf "C:\\Windows\\System32\\tt0628m_.ttf" "Follies"
         0.2, 0
         pigment { rgb 0.8 }
         finish { ambient 0.12 * (49 - frame_number) diffuse 0.2 }
         no_shadow
         scale <16, 16, 1>
         rotate <-40, 40, 20>
         translate <-10, 0, -38>
      }
   #end
   #declare end_frame = 3408;//Arbitrary but high enough to ensure the camera doesn't jump like the trails sometimes do.
   #if (frame_number > 80 & frame_number < 100)
      #declare camera_location = <-25, -102, -25> - 0.05 * (frame_number - 80) * (<-25, -102, -25> - splines[0](1 + frame_number / end_frame * 0.5 * 9.5 * 17.2));
   #end 
   #if (frame_number > 99)
      #declare camera_location = splines[0](1 + frame_number / end_frame * 0.5 * 9.5 * 17.2);
   #end 
   #if (frame_number < 881)//Head spark of each trail.  Gets extinguished first at end of animation.
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[0](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5); 
         #declare effect_scale = (1 - 0.0) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 882)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[1](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 0.95); 
         #declare effect_scale = (1 - 0.025) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 883)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[2](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 1.90); 
         #declare effect_scale = (1 - 0.05) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 884)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[3](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 2.85); 
         #declare effect_scale = (1 - 0.075) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 885)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[4](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 3.80); 
         #declare effect_scale = (1 - 0.1) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 886)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[5](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 4.75); 
         #declare effect_scale = (1 - 0.125) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 887)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[6](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 5.70); 
         #declare effect_scale = (1 - 0.15) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 888)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[7](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 6.65); 
         #declare effect_scale = (1 - 0.175) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 889)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[8](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 7.60); 
         #declare effect_scale = (1 - 0.2) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 890)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[9](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 8.55); 
         #declare effect_scale = (1 - 0.225) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 891)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[10](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 9.50); 
         #declare effect_scale = (1 - 0.250) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 892)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[11](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 10.45); 
         #declare effect_scale = (1 - 0.275) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 893)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[12](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 11.40); 
         #declare effect_scale = (1 - 0.3) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 894)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[13](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 12.35); 
         #declare effect_scale = (1 - 0.325) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 895)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[14](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 13.30); 
         #declare effect_scale = (1 - 0.35) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 896)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[15](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 14.25); 
         #declare effect_scale = (1 - 0.375) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 897)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[16](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 15.20); 
         #declare effect_scale = (1 - 0.4) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 898)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[17](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 16.15); 
         #declare effect_scale = (1 - 0.425) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 899)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[18](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 17.10); 
         #declare effect_scale = (1 - 0.45) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 900)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[19](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 18.05); 
         #declare effect_scale = (1 - 0.475) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 901)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[20](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 19.00); 
         #declare effect_scale = (1 - 0.50) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 902)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[21](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 19.95); 
         #declare effect_scale = (1 - 0.525) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 903)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[22](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 20.90); 
         #declare effect_scale = (1 - 0.55) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 904)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[23](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 21.85); 
         #declare effect_scale = (1 - 0.575) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 905)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[24](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 22.80); 
         #declare effect_scale = (1 - 0.6) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 906)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[25](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 23.75); 
         #declare effect_scale = (1 - 0.625) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 907)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[26](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 24.70); 
         #declare effect_scale = (1 - 0.65) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 908)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[27](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 25.65); 
         #declare effect_scale = (1 - 0.675) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 909)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[28](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 26.60); 
         #declare effect_scale = (1 - 0.7) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 910)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[29](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 27.55); 
         #declare effect_scale = (1 - 0.725) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 911)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[30](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 28.50); 
         #declare effect_scale = (1 - 0.750) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 912)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[31](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 29.45); 
         #declare effect_scale = (1 - 0.775) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 913)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[32](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 30.40); 
         #declare effect_scale = (1 - 0.8) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 914)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[33](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 31.35); 
         #declare effect_scale = (1 - 0.825) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 915)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[34](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 32.30); 
         #declare effect_scale = (1 - 0.85) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 916)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[35](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 33.25); 
         #declare effect_scale = (1 - 0.875) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 917)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[36](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 34.20); 
         #declare effect_scale = (1 - 0.9) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 918)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[37](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 35.15); 
         #declare effect_scale = (1 - 0.925) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 919)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[38](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 36.10); 
         #declare effect_scale = (1 - 0.95) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   #if (frame_number < 920)
      #declare ctr = 1;
      #while (ctr < 96)
         #declare effect_location = splines[39](ctr + mod (frame_number, 80) / 80 * 0.5 * 9.5 - 0.035 * 37.05); 
         #declare effect_scale = (1 - 0.975) * 0.21; 
         #include "LENS.INC"
         #declare ctr = ctr + 0.5 * 9.5;
      #end
   #end 
   
#debug concat("Rendering Frame ", str(frame_number, 1, 0), "\n")
    
