package com.firestick.file;

import java.io.File;
import java.io.FileFilter;

public class FileList {
	
	private File[] files;
	
	public FileList (String dirName, FileFilter filter) {
		File dir = new File(dirName);
		if (!dir.isDirectory()) {
			throw new RuntimeException ("'" + dirName + "' is not a directory");
		}
		files = dir.listFiles(filter);
	}
	
	public File get(int idx) {
		return files[idx];
	}
	
	public int size() {
		return files.length; 
	}
	
	public String getFileNameNoExtension(int idx) {
		File file = get(idx);
		return file.getName().split("\\.")[0];
	}
	
}
