package com.firestick.graphics.format;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

import com.firestick.debug.Debug;
import com.firestick.stream.DelimitedStreamLineReader;
import com.firestick.stream.IDelimitedStreamLineEventListener;

public abstract class AbstractFormatFile implements IDelimitedStreamLineEventListener {
	private File file;
	private boolean fileIsRead = false;
	
	public AbstractFormatFile (File file) {
		this.file = file;
	}
	
	protected void readFile() throws IOException {
		if (!fileIsRead) {
			fileIsRead = true;
			Reader reader = null;
			try{
				reader = new FileReader (file);
				DelimitedStreamLineReader lineReader = new DelimitedStreamLineReader (reader, this, getDelimiters(), true);
				lineReader.start();
			} finally {
				if (reader != null) {
					reader.close();
				}
			}
		}
	}
	
	protected String getDirName() {
		return file.getPath();
	}
	
	protected String getFileName() {
		return file.getAbsolutePath();
	}
	
	protected abstract String getDelimiters();
	
	public abstract void lineEvent(List<String> line, long lineNumber);

}
