package com.firestick.graphics.format.bvh;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import com.firestick.graphics.format.AbstractFormatFile;

public class BvhMotionDeltaedFile extends AbstractFormatFile {

	private Set<Integer> deltaes = new TreeSet<Integer>();
	
	public BvhMotionDeltaedFile(File file) throws IOException {
		super (file);
		readFile();
	}

	@Override
	protected String getDelimiters() {
		return ",";
	}

	@Override
	public void lineEvent(List<String> line, long lineNumber) {
		if (!line.get(0).startsWith("#")) {
			for (int idx=0;idx<line.size();idx++) {
				deltaes.add(new Integer(line.get(idx)));
			}
		}
	}
	
	public Iterator <Integer>getDeltaes() {
		return deltaes.iterator();
	}
	
}
