package com.firestick.graphics.format.bvh;

import java.io.File;
import java.io.IOException;
import java.util.List;

import com.firestick.debug.Debug;


public class BvhMotionFile extends BvhMotionFileBase {

	public Action action = new Action();

	public BvhMotionFile(File file) throws IOException {
		super(file);
		debug();
	}

	

	
	public class Action {

		public void correctiveInterpolation (BvhMotionFile toThis, int from, int to, boolean reverse) throws IOException {
			extend(to);
			
			MotionLine startLine = getMotionLine(from);
			MotionLine endLine = null;
			if (reverse) {
				endLine = toThis.getMotionLine(toThis.getMotionSize()-1);
			} else {
				endLine = toThis.getMotionLine(0);
			}
			MotionLine incrementWithThis = startLine.calculateInterpolationIncrements(endLine, from, to);
			
			MotionLine replaceWith = (MotionLine) startLine.clone();
			
			MotionLine beingReplaced = null;
			for (int idx=from+1;idx<to;idx++) {
				replaceWith.addSpecificElements(incrementWithThis,toThis.getDeltaedElements());
				beingReplaced = getMotionLine(idx);
				beingReplaced.replaceElements(replaceWith, toThis.getDeltaedElements());
			}
			
			// fix in last toThis - suspended since this is corrective interpolation in preparation for a move
//			for (int idx=to;idx<getMotionSize();idx++) {
//				getMotionLine (idx).replaceElements(endLine, toThis.getDeltaedElements());
//			}
		}
		
		
		public void extend (int extendTo) {
			MotionLine extendWithThis = getMotionLine(getMotionSize()-1);
			int startFrom = getMotionSize();
			for (int idx=startFrom; idx < extendTo; idx++) {
				addMotionLine  ((MotionLine)extendWithThis.clone());
			}
		}
		
		/**
		 * Take a motion file and for only the elements in that motion file
		 * replace the elements in the target motion file. So for a limb in the
		 * targetted file that is moving up if that limb is moving down in the 
		 * incoming motion file then the limb will be moving down after the merge
		 * such that the limb will be in the exact same position as it is in
		 * the incoming file. 
		 * @throws IOException 
		 * 
		 * @numberOfFrames if 0 then the number of frames n the incoming BVH file is used if anything else
		 * then this parameter describes the number of frames the merge should take place in
		 */
		public void merge(BvhMotionFile withThis, int from, int numberOfFrames) throws IOException {
			extendToRequest(withThis, from, numberOfFrames);
			for (int idx = 0; idx < withThis.getMotionSize(numberOfFrames); idx++) {
				getMotionLine(idx + from).replaceElements(withThis.getMotionLine(idx, numberOfFrames), withThis.getDeltaedElements());
			}
			// fix in last position
			for (int idx=from+withThis.getMotionSize();idx<getMotionSize();idx++) {
				getMotionLine (idx).replaceElements(withThis.getMotionLine(withThis.getMotionSize()-1), withThis.getDeltaedElements());
			}
		}
		
		public void mergeReverse(BvhMotionFile withThis, int from, int numberOfFrames) throws IOException {
			extendToRequest(withThis, from, numberOfFrames);
			int idxBase = from;
			for (int idx = withThis.getMotionSize(numberOfFrames)-1; idx >=0; idx--) {
				getMotionLine(idxBase).replaceElements(withThis.getMotionLine(idx, numberOfFrames), withThis.getDeltaedElements());
				idxBase++;
			}
			// fix in last position
			for (int idx=from+withThis.getMotionSize();idx<getMotionSize();idx++) {
				getMotionLine (idx).replaceElements(withThis.getMotionLine(0), withThis.getDeltaedElements());
			}
		}
				

		/**
		 * Take a motion file and for only the elements that change inside it
		 * add the difference between each successive line. So for a limb
		 * that is allready moving this method will compound that movement
		 * with movement of the incoming bvh (but only if that limb is moving
		 * in the incoming bvh.  
		 */
		public void  mergeRelative(BvhMotionFile addThis, int addFrom, int numberOfFrames) {
			extendToRequest(addThis, addFrom, numberOfFrames);
			MotionLine deltaReference = addThis.getMotionLine(0);
			for (int idx = 0; idx < addThis.getMotionSize(numberOfFrames); idx++) {
				getMotionLine(idx + addFrom).addDelta(addThis.getMotionLine(idx,numberOfFrames), deltaReference);
			}
		}
		
		public void  mergeRelativeReverse(BvhMotionFile addThis, int addFrom, int numberOfFrames) {
			extendToRequest(addThis, addFrom, numberOfFrames);
			MotionLine deltaReference = addThis.getMotionLine(0);
			int idxBase = addFrom;
			for (int idx = addThis.getMotionSize(numberOfFrames)-1; idx>=0;idx--) {
				getMotionLine(idxBase).addDelta(addThis.getMotionLine(idx,numberOfFrames), deltaReference);
				idxBase++;
			}
		}
		
		
	}
	


	private void extendToRequest (BvhMotionFile withThis, int fromThis, int numberOfFrames) {
		if ((fromThis + withThis.getMotionSize(numberOfFrames)) > getMotionSize()) {
			action.extend (fromThis + withThis.getMotionSize(numberOfFrames));
		}
	}

	









}
