package com.firestick.graphics.format.povray;

import java.io.IOException;
import java.io.Writer;

import com.firestick.graphics.util.Coord;
import com.firestick.graphics.util.IMeshConverter;
import com.firestick.graphics.util.ITriangle;

public class PovrayMeshStatsWriter implements IMeshConverter {

	private String baseStatName;
	private long triangleCount;
	private Coord runningTotal;

	
	public PovrayMeshStatsWriter(String baseStatName) {
		super();
		this.baseStatName = baseStatName;
	}


	public void startEvent(Writer writer) throws IOException {
		runningTotal = new Coord(0,0,0);
		triangleCount = 0;
	}

	public void triangleEvent(Writer writer, ITriangle triangle) throws IOException {
		triangleCount+=1;
		runningTotal.inc (triangle.getCenter());
	}
	
	public void endEvent(Writer writer) throws IOException {
		writer.write("#declare " + baseStatName + "_center = <" + runningTotal.getX()/triangleCount + ", " + runningTotal.getY()/triangleCount + ", " + runningTotal.getZ()/triangleCount + ">;\n");
	}
	
	
}
