package com.firestick.graphics.povray;

import com.firestick.file.PropertyFile;

public class PovrayIniFile extends PropertyFile{

	private static final String END_FRAME = "END_FRAME";
	private static final String INITIAL_FRAME = "Initial_Frame";
	private static final String START_FRAME = "Start_Frame";

	public PovrayIniFile(String fileName) {
		super(fileName);
	}
	
	public int getInitialFrame() {
		return getInteger(INITIAL_FRAME);
	}
	
	public int getFinalFrame() {
		return getInteger("Final_Frame");
	}
	
	public String getInputFileName() {
		return getString("Input_File_Name");
	}
	
	public String getOutputFileName() {
		return getString ("Output_File_Name");
	}

	public String getInputFileNameNoExtension() {
		return getInputFileName().substring(0,getInputFileName().indexOf("."));
	}
	
	public int getStartFrame () {
		if (containsKey(START_FRAME)) {
			return getInteger(START_FRAME);
		} else {
			return getInitialFrame(); 
		}
	}
	
	public int getEndFrame() {
		if (containsKey(END_FRAME)) {
			return getInteger(END_FRAME);
		} else {
			return getFinalFrame();
		}
	}
}
