package com.firestick.graphics.puppets;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

import com.firestick.file.FileList;
import com.firestick.graphics.format.bvh.BvhFileMatcher;
import com.firestick.graphics.format.bvh.BvhMotionFile;
import com.firestick.graphics.util.AnimationUtil;

public abstract class AbstractPuppet {
	
	private BvhMotionFile baseBvh;
	
	private Map<String, BvhMotionFile> bvhFiles = new Hashtable<String, BvhMotionFile>();
	
	public AbstractPuppet () throws IOException {
		baseBvh = new BvhMotionFile(new File(getBvhDir() + "/base.bvh"));
		
		FileList files = new FileList (getBvhDir(), new BvhFileMatcher());
		for (int idx=0;idx<files.size();idx++) {
			BvhMotionFile motionFile = new BvhMotionFile(files.get(idx));
			bvhFiles.put(files.get(idx).getName(), motionFile);
		}
	}
	
	protected abstract String getBvhDir();

	public int sec(double seconds) {
		return AnimationUtil.sec(seconds);
	}
	
	protected BvhMotionFile bvh(String name) {
		BvhMotionFile bvhFile = bvhFiles.get(name);
		if (bvhFile == null) {
			throw new RuntimeException("BVH File not found :  " + name);
		}
		return bvhFile;
	}

	protected void interpolate(String toThis, int from, int to, boolean reverse) throws IOException {
		baseBvh.action.correctiveInterpolation(bvh(toThis), from, to, reverse);
	}

	protected void merge(String withThis, int from, int scaleToFrame, boolean reverse) throws IOException {
		if (reverse) {
			baseBvh.action.mergeReverse(bvh(withThis), from, scaleToFrame);
		} else {
			baseBvh.action.merge(bvh(withThis), from, scaleToFrame);
		}
	}

	
	public void extendTo(int aToSec) {
		baseBvh.action.extend(sec(aToSec));
	}
	
	
	protected void mergeRelative(String addThis, int addFrom, int scaleToFrame, boolean reverse) {
		if (reverse) {
			baseBvh.action.mergeRelativeReverse(bvh(addThis), addFrom, scaleToFrame);
		} else {
			baseBvh.action.mergeRelative(bvh(addThis), addFrom, scaleToFrame);
		}
	}

	public void write(File file) throws IOException {
		baseBvh.write(file);
	}
	
}
