package com.firestick.graphics.puppets;

import java.io.IOException;

public class ClairePuppet extends AbstractPuppet {

	/*
	 
	  
	  
	  
	  
	  
	  
	 */
	
	
	
	private static final String KNEELING_TO_KNEEL_BACK_BVH = "kneelingToKneelBack.bvh";

	private static final String STANDING_TO_KNEE_UPRIGHT_MOVE_BVH = "standingToKneeUprightMove.bvh";

	private static final String STANDING_ARMS_SLIDE_OVER_FACE_MOVE_BVH = "standingArmsSlideOverFaceMove.bvh";

	private static final String STANDING_SWAY_SIDE_TO_SIDE_MOVE_BVH = "standingSwaySideToSideMove.bvh";

	private static final String STANDING_ARMS_OVER_HEAD_MOVE_BVH = "standingArmsOverHeadMove.bvh";

	private static final String BASE = "base.bvh";
		
	// 573444
	public ClairePuppet() throws IOException {
		super();
	}

	@Override
	protected String getBvhDir() {
		return "D:/data/graphics/poser/puppets/claire";
	}

	public Movement movement() {
		return new Movement();
	}

	// ******************************************************************************************************************************************
	public class Movement {
		
		private static final String STAND_HEAD_WIGGLE_BVH = "standHeadWiggle.bvh";
		private static final String HIPS_RIGHT_BVH = "hipsRight.bvh";
		private static final String THROW_FROM_OFFERING_BVH = "throwFromOffering.bvh";
		private static final String ARMS_OVER_HEAD_TO_RIGHT_BVH = "armsOverHeadToRight.bvh";
		private double fromSec;
		private double toSec;
		private double scaleToSec;
		private boolean reverse = false;
		private boolean relative = false;
		private boolean suppressCorrectiveInterpolation = false;
		
		public Movement from(double fromSec) {
			this.fromSec = fromSec;
			return this;
		}
		
		public Movement to (double toSec) {
			this.toSec = toSec;
			return this;
		}
		
		public Movement forr (double forSec) {
			toSec = fromSec+ forSec;
			return this;
		}
		
		public void backToBase(double inSec) throws IOException {
			interpolate(BASE, sec(fromSec), sec(fromSec) + sec(inSec), reverse);
		}
		
		public Movement inDefault() {
			scaleToSec = 0;
			return this;
		}
	
		public Movement in (double scaleToSec) {
			this.scaleToSec = scaleToSec;
			return this;
		}
		
		public Movement reverse() {
			this.reverse = true;
			return this;
		}
		
		public Movement relative() {
			this.relative = true;
			return this;
		}
		
		
		private double getScaledLength(double unscaledLengthSec) {
			if (scaleToSec > 0) {
				return scaleToSec;
			} else {
				return unscaledLengthSec;
			}
		}

		public void sway() throws IOException {
			suppressCorrectiveInterpolation (STANDING_SWAY_SIDE_TO_SIDE_MOVE_BVH) ;
			while (fromSec < toSec) {
				doMerge(STANDING_SWAY_SIDE_TO_SIDE_MOVE_BVH);
				fromSec += getScaledLength(1);
			}
		}

		public void swayGentle() throws IOException {
			suppressCorrectiveInterpolation(HIPS_RIGHT_BVH);
			while (fromSec < toSec) {
				reverse = false;
				hipsRight();
				fromSec += getScaledLength(0.5);
				
				reverse = true;
				hipsRight();
				fromSec += getScaledLength(0.5);
				
				reverse = false;
				hipsLeft();
				fromSec += getScaledLength(0.5);
				
				reverse = true;
				hipsLeft();
				fromSec += getScaledLength(0.5);
			}
		}
		
		
		public void swayArmsOverHead() throws IOException {
			//correctiveInterpolation(ARMS_OVER_HEAD_TO_RIGHT_BVH);
			suppressCorrectiveInterpolation(ARMS_OVER_HEAD_TO_RIGHT_BVH);
			while (fromSec < toSec) {
				reverse = false;
				armsRaisedOverHeadToRight();
				fromSec += getScaledLength(0.5);
				
				reverse = true;
				armsRaisedOverHeadToRight();
				fromSec += getScaledLength(0.5);
				
				reverse = false;
				armsRaisedOverHeadToLeft();
				fromSec += getScaledLength(0.5);
				
				reverse = true;
				armsRaisedOverHeadToLeft();
				fromSec += getScaledLength(0.5);			
				}
		}
		
		
		public void armsRaisedOverHeadToRight() throws IOException {
			doMerge(ARMS_OVER_HEAD_TO_RIGHT_BVH);
		}
		
		public void armsRaisedOverHeadToLeft() throws IOException {
			doMerge("armsOverHeadToLeft.bvh");
		}
		
		public void wiggleHead () throws IOException {
			suppressCorrectiveInterpolation (STAND_HEAD_WIGGLE_BVH);
			while (fromSec< toSec) {
				doMerge (STAND_HEAD_WIGGLE_BVH);
				fromSec += getScaledLength(1);
			}
		}
		
		public void correctiveInterpolation(String bvhName) throws IOException {
			interpolate(bvhName, sec(fromSec - 0.5), sec(fromSec), reverse);
		}

		public void raiseArmsOverHead() throws IOException {
			//correctiveInterpolation(STANDING_ARMS_OVER_HEAD_MOVE_BVH);
			doMerge(STANDING_ARMS_OVER_HEAD_MOVE_BVH);
		}

		public void slideArmsInFrontOfFace() throws IOException {
			//correctiveInterpolation(STANDING_ARMS_SLIDE_OVER_FACE_MOVE_BVH);
			doMerge(STANDING_ARMS_SLIDE_OVER_FACE_MOVE_BVH);
		}

		public void kneelUpright() throws IOException {
			doMerge(STANDING_TO_KNEE_UPRIGHT_MOVE_BVH);
		}

		public void kneelBackOverTwoSeconds() throws IOException {
			doMerge(KNEELING_TO_KNEEL_BACK_BVH);
		}

		public void putArmsOutInFront() throws IOException {
			doMerge("standingArmsOutInFront.bvh");
		}
		
		public void raiseRightArmOverHead() throws IOException {
			doMerge ("standingRaiseRightArm.bvh");
		}
	
		public void rightArmOutFrontToSide() throws IOException {
			doMerge ("standingRightArmOutFrontToSide.bvh");
		}
		
		public void hipsRight() throws IOException {
			doMerge (HIPS_RIGHT_BVH);
		}

		public void hipsLeft() throws IOException {
			doMerge ("hipsLeft.bvh");
		}
		
		public void offering() throws IOException {
			doMerge ("offering.bvh");
		}
		
		public void throwFromOffering() throws IOException {
			//correctiveInterpolation(THROW_FROM_OFFERING_BVH);
			doMerge (THROW_FROM_OFFERING_BVH);
		}
		
		public void chestForward() throws IOException {
			doMerge("chestForward.bvh");
		}
		
		public void hallelujah() throws IOException {
			doMerge("hallelujah.bvh");
		}
		
		
		private void suppressCorrectiveInterpolation (String bvhName) throws IOException{
			// used for composite moves, hence why we actually force one interpolation
			correctiveInterpolation(bvhName);
			suppressCorrectiveInterpolation = true;
			
		}
		
		public void doMerge (String bvhName) throws IOException { 
			if (relative) {
				mergeRelative(bvhName, sec(fromSec), sec(scaleToSec), reverse);
			} else {
				if (suppressCorrectiveInterpolation == false) {
					correctiveInterpolation(bvhName);
				}
				merge (bvhName, sec(fromSec), sec(scaleToSec), reverse);
			}
		}
		
	}

}