package com.firestick.main;

import com.firestick.file.FileList;
import com.firestick.graphics.format.detailer.DetailerFile;
import com.firestick.graphics.format.detailer.DetailerFileMatcher;
import com.firestick.graphics.format.povray.PovrayMeshStatsWriter;
import com.firestick.graphics.format.povray.PovrayMeshWriter;

public class DetailerFileToPovrayConverter {

	private static final String VTX_INPUT_DIR = "d:/carpet/poser/vtx";
	private static final String POVRAY_OUTPUT_DIR = "d:/carpet/poser/pov/";


	public static void main(String[] args) throws Exception {
		
		//convert ("body", true);
		//convert ("hands", false);
		convert("baby", true);
		
		System.out.println ("done");
	}
	
	
	public static void convert (String prefix, boolean mesh) throws Exception  {
		FileList inputFiles = new FileList (VTX_INPUT_DIR, new DetailerFileMatcher(prefix));
		for (int idx=0; idx<inputFiles.size();idx++) {
			System.out.println ("Converting : " + prefix + " : "+ idx);
			DetailerFile detailerFile = new DetailerFile(inputFiles.get(idx));
			detailerFile.convert(new PovrayMeshStatsWriter(prefix), POVRAY_OUTPUT_DIR + inputFiles.getFileNameNoExtension(idx) + "_stats.inc");
			if (mesh) {
				detailerFile.convert(new PovrayMeshWriter(prefix), POVRAY_OUTPUT_DIR + inputFiles.getFileNameNoExtension(idx) + ".inc");
			}
			
		}
	}

}
